/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.impl;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateDecorator;
import org.netbeans.modules.java.api.common.impl.DefaultProjectModulesModifier;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;

public final class TemplateModuleDeclarator
implements CreateFromTemplateDecorator {
    private static final String NAME_MODULE_INFO = "module-info.java";
    private static final String ATTRIBUTE_REQUIRED_MODULES = "java.template.requiredModules";
    private static final SpecificationVersion SOURCE_LEVEL_9 = new SpecificationVersion("9");
    private static final String MIME_JAVA = "text/x-java";
    private static final String CLASS_EXTENSION = ".class";

    public boolean isBeforeCreation() {
        return false;
    }

    public boolean isAfterCreation() {
        return true;
    }

    public boolean accept(CreateDescriptor desc) {
        if (desc.getValue(ATTRIBUTE_REQUIRED_MODULES) != null) {
            return true;
        }
        FileObject t = desc.getTarget();
        if (!MIME_JAVA.equals(desc.getTemplate().getMIMEType())) {
            return false;
        }
        String s = SourceLevelQuery.getSourceLevel((FileObject)t);
        if (s == null || SOURCE_LEVEL_9.compareTo(new SpecificationVersion(s)) > 0) {
            return false;
        }
        ClassPath srcPath = ClassPath.getClassPath((FileObject)t, (String)"classpath/source");
        if (srcPath == null) {
            return false;
        }
        return srcPath.findResource(NAME_MODULE_INFO) != null;
    }

    public List<FileObject> decorate(CreateDescriptor desc, List<FileObject> createdFiles) throws IOException {
        String s;
        ArrayList<FileObject> jsources = new ArrayList<FileObject>(createdFiles.size());
        for (FileObject f : createdFiles) {
            if (!MIME_JAVA.equals(f.getMIMEType())) continue;
            jsources.add(f);
        }
        if (jsources.isEmpty()) {
            return null;
        }
        FileObject t = desc.getTarget();
        ClassPath srcPath = ClassPath.getClassPath((FileObject)t, (String)"classpath/source");
        if (srcPath == null) {
            return null;
        }
        FileObject modinfo = srcPath.findResource(NAME_MODULE_INFO);
        if (modinfo == null) {
            return null;
        }
        Object a = desc.getTemplate().getAttribute(ATTRIBUTE_REQUIRED_MODULES);
        Set<String> modules = a instanceof String ? (!(s = a.toString()).isEmpty() ? new HashSet<String>(Arrays.asList(s.split(","))) : Collections.emptySet()) : this.inferModuleNames(t, jsources);
        if (modules.isEmpty()) {
            return null;
        }
        DefaultProjectModulesModifier.addRequiredModules(modinfo, modules);
        return null;
    }

    private Set<String> inferModuleNames(FileObject t, List<FileObject> jsources) throws IOException {
        ClasspathInfo cpi = ClasspathInfo.create((FileObject)t);
        JavaSource src = JavaSource.create((ClasspathInfo)cpi, jsources);
        final HashSet unresolved = new HashSet();
        src.runUserActionTask((Task)new Task<CompilationController>(){
            final /* synthetic */ TemplateModuleDeclarator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(CompilationController parameter) throws Exception {
                parameter.toPhase(JavaSource.Phase.RESOLVED);
                Scanner s = new Scanner((CompilationInfo)parameter, unresolved);
                s.scan(parameter.getCompilationUnit(), null);
            }
        }, true);
        ClassPath searchPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpi.getClassPath(ClasspathInfo.PathKind.MODULE_BOOT), cpi.getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE)});
        HashSet<String> moduleNames = new HashSet<String>();
        for (String fqn : unresolved) {
            this.findModuleNames(fqn, searchPath, moduleNames);
        }
        return moduleNames;
    }

    private void findModuleNames(String fqn, ClassPath searchPath, Set<String> moduleNames) {
        String resourceName = (fqn = fqn.replace(".", "/")) + CLASS_EXTENSION;
        FileObject classResource = searchPath.findResource(resourceName);
        if (classResource == null || classResource.isFolder()) {
            int last = fqn.length();
            int i = fqn.lastIndexOf(46);
            while (i >= 0) {
                resourceName = fqn.substring(0, i);
                classResource = searchPath.findResource(resourceName + CLASS_EXTENSION);
                if (classResource != null && classResource.isData()) {
                    resourceName = resourceName + fqn.substring(i).replace("/", "$") + CLASS_EXTENSION;
                    classResource = searchPath.findResource(resourceName);
                    break;
                }
                classResource = searchPath.findResource(resourceName);
                if (classResource != null && classResource.isFolder()) {
                    return;
                }
                i = fqn.lastIndexOf(47, last);
            }
        }
        if (classResource != null) {
            FileObject r = searchPath.findOwnerRoot(classResource);
            for (ClassPath.Entry e : searchPath.entries()) {
                FileObject er = e.getRoot();
                if (er == null || !er.equals(r)) continue;
                String name = SourceUtils.getModuleName((URL)e.getURL(), (boolean)true);
                moduleNames.add(name);
            }
        }
    }

    private static class Scanner
    extends ErrorAwareTreePathScanner<Boolean, Boolean> {
        private final CompilationInfo info;
        private final Set<String> unresolved;

        public Scanner(CompilationInfo info, Set<String> s) {
            this.info = info;
            this.unresolved = s;
        }

        public Boolean visitMemberSelect(MemberSelectTree node, Boolean p) {
            Boolean r = (Boolean)super.scan((Tree)node.getExpression(), (Object)p);
            if (r == Boolean.TRUE) {
                return r;
            }
            TreePath parentPath = this.getCurrentPath().getParentPath();
            if (parentPath == null) {
                return null;
            }
            ExpressionTree t = node;
            Tree par = parentPath.getLeaf();
            if (node.getIdentifier().contentEquals("*")) {
                t = node.getExpression();
                par = node;
                parentPath = new TreePath(parentPath, t);
            }
            if (par.getKind() == Tree.Kind.METHOD_INVOCATION) {
                return null;
            }
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el == null || !el.getKind().isClass() && !el.getKind().isInterface() && el.getKind() != ElementKind.PACKAGE) {
                return true;
            }
            TypeMirror type = el.asType();
            if (type == null) {
                return null;
            }
            String fqn = null;
            if (type.getKind() == TypeKind.ERROR) {
                AssignmentTree at;
                if (par.getKind() == Tree.Kind.ASSIGNMENT && (at = (AssignmentTree)this.getCurrentPath().getParentPath().getLeaf()).getVariable() == node) {
                    return null;
                }
            } else if (type.getKind() == TypeKind.PACKAGE) {
                String s = ((PackageElement)el).getQualifiedName().toString();
                if (this.info.getElements().getPackageElement(s) != null) {
                    return null;
                }
            }
            if ((fqn = node.toString()).endsWith(".<error>")) {
                fqn = fqn.substring(0, fqn.lastIndexOf("."));
            }
            this.unresolved.add(fqn);
            return null;
        }
    }
}

