/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.javamodel;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.design.javamodel.ConfigProjectService;
import org.netbeans.modules.websvc.design.javamodel.FaultModel;
import org.netbeans.modules.websvc.design.javamodel.JavadocModel;
import org.netbeans.modules.websvc.design.javamodel.LightProjectService;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ParamModel;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.design.javamodel.ResultModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class Utils {
    public static boolean isEqualTo(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static ProjectService getProjectService(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        String implClass = Utils.getImplClass(fileObject);
        JaxWsModel model = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        if (model == null) {
            JAXWSLightSupport support = JAXWSLightSupport.getJAXWSLightSupport((FileObject)fileObject);
            if (support == null) {
                return null;
            }
            List services = support.getServices();
            for (JaxWsService service : services) {
                String implementationClass = service.getImplementationClass();
                if (!implClass.equals(implementationClass)) continue;
                return new LightProjectService(support, service, dataObject);
            }
            return null;
        }
        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        Service service = model.findServiceByImplementationClass(implClass);
        return new ConfigProjectService(support, service, dataObject);
    }

    private static String getImplClass(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        String implClass = classPath.getResourceName(fileObject, '.', false);
        return implClass;
    }

    public static Service getService(ProjectService projectService) {
        if (projectService instanceof ConfigProjectService) {
            return ((ConfigProjectService)projectService).getService();
        }
        return null;
    }

    public static ServiceModel populateModel(final FileObject implClass) {
        final ServiceModel[] model = new ServiceModel[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)implClass);
        if (javaSource != null) {
            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    ServiceModel serviceModel;
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    model[0] = serviceModel = ServiceModel.getServiceModel();
                    TypeElement classEl = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                    if (classEl != null) {
                        boolean bl;
                        List<? extends AnnotationMirror> annotations = classEl.getAnnotationMirrors();
                        AnnotationMirror webServiceAn = null;
                        for (AnnotationMirror annotationMirror : annotations) {
                            Name qName;
                            Element annotationElement = annotationMirror.getAnnotationType().asElement();
                            if (!(annotationElement instanceof TypeElement) || !(qName = ((TypeElement)annotationElement).getQualifiedName()).contentEquals("javax.jws.WebService")) continue;
                            webServiceAn = annotationMirror;
                            break;
                        }
                        if (webServiceAn == null) {
                            serviceModel.status = 1;
                            return;
                        }
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = webServiceAn.getElementValues();
                        boolean bl2 = false;
                        boolean serviceNameFound = false;
                        boolean portNameFound = false;
                        boolean tnsFound = false;
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                            ExecutableElement ex = entry.getKey();
                            AnnotationValue value = entry.getValue();
                            if (ex.getSimpleName().contentEquals("serviceName")) {
                                serviceModel.serviceName = (String)value.getValue();
                                serviceNameFound = true;
                                continue;
                            }
                            if (ex.getSimpleName().contentEquals("name")) {
                                serviceModel.name = (String)value.getValue();
                                bl = true;
                                continue;
                            }
                            if (ex.getSimpleName().contentEquals("portName")) {
                                serviceModel.portName = (String)value.getValue();
                                portNameFound = true;
                                continue;
                            }
                            if (ex.getSimpleName().contentEquals("targetNamespace")) {
                                serviceModel.targetNamespace = (String)value.getValue();
                                tnsFound = true;
                                continue;
                            }
                            if (ex.getSimpleName().contentEquals("endpointInterface")) {
                                serviceModel.endpointInterface = (String)value.getValue();
                                continue;
                            }
                            if (!ex.getSimpleName().contentEquals("wsdlLocation")) continue;
                            serviceModel.wsdlLocation = (String)value.getValue();
                        }
                        if (!bl) {
                            serviceModel.name = implClass.getName();
                        }
                        if (!portNameFound) {
                            serviceModel.portName = serviceModel.getName() + "Port";
                        }
                        if (!serviceNameFound) {
                            serviceModel.serviceName = implClass.getName() + "Service";
                        }
                        if (!tnsFound) {
                            String qualifName = classEl.getQualifiedName().toString();
                            int ind = qualifName.lastIndexOf(".");
                            String packageName = ind >= 0 ? qualifName.substring(0, ind) : "";
                            String ns = Utils.getPackageReverseOrder(packageName);
                            serviceModel.targetNamespace = "http://" + ns + "/";
                        }
                        TypeElement seiClassEl = null;
                        if (serviceModel.endpointInterface != null && (seiClassEl = controller.getElements().getTypeElement(serviceModel.endpointInterface)) != null) {
                            classEl = seiClassEl;
                        }
                        boolean foundWebMethodAnnotation = false;
                        TypeElement methodAnotationEl = controller.getElements().getTypeElement("javax.jws.WebMethod");
                        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
                        block2: for (Element element : classEl.getEnclosedElements()) {
                            ExecutableElement methodEl;
                            if (element.getKind() != ElementKind.METHOD || !(methodEl = (ExecutableElement)element).getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                            List<? extends AnnotationMirror> methodAnnotations = methodEl.getAnnotationMirrors();
                            if (foundWebMethodAnnotation) {
                                for (AnnotationMirror annotationMirror : methodAnnotations) {
                                    if (!controller.getTypes().isSameType(methodAnotationEl.asType(), annotationMirror.getAnnotationType())) continue;
                                    methods.add(methodEl);
                                    continue block2;
                                }
                                continue;
                            }
                            for (AnnotationMirror annotationMirror : methodAnnotations) {
                                if (!controller.getTypes().isSameType(methodAnotationEl.asType(), annotationMirror.getAnnotationType())) continue;
                                methods.clear();
                                foundWebMethodAnnotation = true;
                                methods.add(methodEl);
                                break;
                            }
                            if (foundWebMethodAnnotation) continue;
                            methods.add(methodEl);
                        }
                        ArrayList<MethodModel> operations = new ArrayList<MethodModel>();
                        if (methods.size() == 0) {
                            serviceModel.operations = operations;
                            serviceModel.status = 2;
                            return;
                        }
                        boolean bl3 = serviceModel.endpointInterface != null;
                        FileObject seiClass = null;
                        if (bl3) {
                            String seiClassResource;
                            FileObject srcRoot;
                            FileObject[] srcRoots;
                            ClassPath classPath = ClassPath.getClassPath((FileObject)implClass, (String)"classpath/source");
                            FileObject[] fileObjectArray = srcRoots = classPath.getRoots();
                            int n = fileObjectArray.length;
                            for (int i = 0; i < n && (seiClass = (srcRoot = fileObjectArray[i]).getFileObject(seiClassResource = serviceModel.endpointInterface.replace('.', '/') + ".java")) == null; ++i) {
                            }
                            if (seiClass == null) {
                                Project project = FileOwnerQuery.getOwner((FileObject)implClass);
                                String seiPath = "build/generated/wsimport/service/" + serviceModel.endpointInterface.replace('.', '/') + ".java";
                                seiClass = project.getProjectDirectory().getFileObject(seiPath);
                                if (seiClass == null) {
                                    Utils.invokeWsImport(project, serviceModel.getName());
                                    seiClass = project.getProjectDirectory().getFileObject(seiPath);
                                }
                            }
                        }
                        for (int i = 0; i < methods.size(); ++i) {
                            MethodModel operation = new MethodModel();
                            if (bl3 && seiClass != null) {
                                operation.setImplementationClass(seiClass);
                            } else {
                                operation.setImplementationClass(implClass);
                            }
                            ElementHandle elementHandle = ElementHandle.create((Element)((ExecutableElement)methods.get(i)));
                            operation.setMethodHandle(elementHandle);
                            Utils.populateOperation(controller, (ExecutableElement)methods.get(i), elementHandle, operation, serviceModel.getTargetNamespace());
                            operations.add(operation);
                        }
                        serviceModel.operations = operations;
                    } else {
                        serviceModel.status = 2;
                    }
                }

                public void cancel() {
                }
            };
            try {
                Future future = javaSource.runWhenScanFinished((Task)task, true);
                future.get();
                return model[0];
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (CancellationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (ExecutionException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (InterruptedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void populateOperation(CompilationController controller, ExecutableElement methodEl, ElementHandle methodHandle, MethodModel methodModel, String targetNamespace) {
        TypeElement methodAnotationEl = controller.getElements().getTypeElement("javax.jws.WebMethod");
        TypeElement onewayAnotationEl = controller.getElements().getTypeElement("javax.jws.Oneway");
        TypeElement resultAnotationEl = controller.getElements().getTypeElement("javax.jws.WebResult");
        List<? extends AnnotationMirror> methodAnnotations = methodEl.getAnnotationMirrors();
        ResultModel resultModel = new ResultModel();
        boolean nameFound = false;
        boolean resultNameFound = false;
        for (AnnotationMirror annotationMirror : methodAnnotations) {
            ExecutableElement ex;
            Object expressions;
            if (controller.getTypes().isSameType(methodAnotationEl.asType(), annotationMirror.getAnnotationType())) {
                expressions = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                    ex = entry.getKey();
                    if (ex.getSimpleName().contentEquals("operationName")) {
                        methodModel.operationName = (String)entry.getValue().getValue();
                        nameFound = true;
                        continue;
                    }
                    if (!ex.getSimpleName().contentEquals("action")) continue;
                    methodModel.action = (String)entry.getValue().getValue();
                }
                continue;
            }
            if (controller.getTypes().isSameType(resultAnotationEl.asType(), annotationMirror.getAnnotationType())) {
                expressions = annotationMirror.getElementValues();
                for (Map.Entry entry : expressions.entrySet()) {
                    ex = (ExecutableElement)entry.getKey();
                    if (ex.getSimpleName().contentEquals("name")) {
                        resultModel.setName((String)((AnnotationValue)entry.getValue()).getValue());
                        resultNameFound = true;
                        continue;
                    }
                    if (ex.getSimpleName().contentEquals("partName")) {
                        resultModel.setPartName((String)((AnnotationValue)entry.getValue()).getValue());
                        continue;
                    }
                    if (!ex.getSimpleName().contentEquals("targetNamespace")) continue;
                    resultModel.setTargetNamespace((String)((AnnotationValue)entry.getValue()).getValue());
                }
                continue;
            }
            if (!controller.getTypes().isSameType(onewayAnotationEl.asType(), annotationMirror.getAnnotationType())) continue;
            methodModel.oneWay = true;
        }
        methodModel.javaName = methodEl.getSimpleName().toString();
        if (!nameFound) {
            methodModel.operationName = methodModel.javaName;
        }
        if (!methodModel.isOneWay()) {
            if (!resultNameFound) {
                resultModel.setName("return");
            }
            resultModel.setResultType(methodEl.getReturnType().toString());
        }
        methodModel.setResult(resultModel);
        List<? extends TypeMirror> faultTypes = methodEl.getThrownTypes();
        ArrayList<FaultModel> arrayList = new ArrayList<FaultModel>();
        for (TypeMirror typeMirror : faultTypes) {
            FaultModel faultModel = new FaultModel();
            boolean faultFound = false;
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                TypeElement faultAnotationEl = controller.getElements().getTypeElement("javax.xml.ws.WebFault");
                List<? extends AnnotationMirror> faultAnnotations = typeElement.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : faultAnnotations) {
                    if (!controller.getTypes().isSameType(faultAnotationEl.asType(), annotationMirror.getAnnotationType())) continue;
                    Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> it : expressions.entrySet()) {
                        if (it.getKey().getSimpleName().contentEquals("name")) {
                            faultModel.setName((String)it.getValue().getValue());
                            faultFound = true;
                            continue;
                        }
                        if (!it.getKey().getSimpleName().contentEquals("targetNamespace")) continue;
                        faultModel.setTargetNamespace((String)it.getValue().getValue());
                    }
                }
                faultModel.setFaultType(typeElement.getQualifiedName().toString());
            } else {
                faultModel.setFaultType(typeMirror.toString());
            }
            if (!faultFound) {
                String string = faultModel.getFaultType();
                int index = string.lastIndexOf(".");
                faultModel.setName(index >= 0 ? string.substring(index + 1) : string);
            }
            arrayList.add(faultModel);
        }
        methodModel.setFaults(arrayList);
        Utils.initJavaDoc(controller, methodEl, methodModel);
        List<? extends VariableElement> paramElements = methodEl.getParameters();
        ArrayList<ParamModel> arrayList2 = new ArrayList<ParamModel>();
        boolean bl = false;
        for (VariableElement variableElement : paramElements) {
            void var16_28;
            ParamModel param = new ParamModel("arg" + String.valueOf((int)(++var16_28)), variableElement.getSimpleName().toString());
            param.setImplementationClass(methodModel.getImplementationClass());
            param.setMethodHandle(methodHandle);
            Utils.populateParam(controller, variableElement, param);
            arrayList2.add(param);
        }
        methodModel.setParams(arrayList2);
        Utils.setSoapRequest(methodModel, targetNamespace);
        Utils.setSoapResponse(methodModel, targetNamespace);
    }

    private static void initJavaDoc(CompilationController controller, ExecutableElement methodEl, MethodModel methodModel) {
        DocCommentTree javadoc = controller.getDocTrees().getDocCommentTree(methodEl);
        if (javadoc != null) {
            JavadocModel javadocModel = new JavadocModel(javadoc.toString());
            methodModel.setJavadoc(javadocModel);
        }
    }

    private static void populateParam(CompilationController controller, VariableElement paramEl, ParamModel paramModel) {
        paramModel.setParamType(paramEl.asType().toString());
        TypeElement paramAnotationEl = controller.getElements().getTypeElement("javax.jws.WebParam");
        List<? extends AnnotationMirror> paramAnnotations = paramEl.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : paramAnnotations) {
            if (!controller.getTypes().isSameType(paramAnotationEl.asType(), annotationMirror.getAnnotationType())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                ExecutableElement ex = entry.getKey();
                AnnotationValue value = entry.getValue();
                if (ex.getSimpleName().contentEquals("name")) {
                    paramModel.name = (String)value.getValue();
                    continue;
                }
                if (ex.getSimpleName().contentEquals("partName")) {
                    paramModel.setPartName((String)value.getValue());
                    continue;
                }
                if (ex.getSimpleName().contentEquals("targetNamespace")) {
                    paramModel.setTargetNamespace((String)value.getValue());
                    continue;
                }
                if (!ex.getSimpleName().contentEquals("mode")) continue;
                paramModel.setMode(WebParam.Mode.valueOf((String)value.getValue().toString()));
            }
        }
    }

    private static void setSoapRequest(MethodModel methodModel, String tns) {
        MessageFactory messageFactory = null;
        try {
            messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.FINE, NbBundle.getMessage(Utils.class, (String)"MSG_SAAJ_PROBLEM"), ex);
        }
        if (messageFactory != null) {
            try {
                SOAPMessage request = messageFactory.createMessage();
                MimeHeaders headers = request.getMimeHeaders();
                String action = methodModel.getAction();
                headers.addHeader("SOAPAction", action == null ? "\"\"" : action);
                SOAPPart part = request.getSOAPPart();
                SOAPEnvelope envelope = part.getEnvelope();
                String prefix = envelope.getPrefix();
                if (!"soap".equals(prefix)) {
                    envelope.removeAttribute("xmlns:" + prefix);
                    envelope.setPrefix("soap");
                }
                SOAPBody body = envelope.getBody();
                body.setPrefix("soap");
                SOAPHeader header = envelope.getHeader();
                envelope.removeChild((Node)header);
                javax.xml.soap.Name methodName = envelope.createName(methodModel.getOperationName());
                SOAPBodyElement methodElement = body.addBodyElement(methodName);
                methodElement.setPrefix("ns0");
                methodElement.addNamespaceDeclaration("ns0", tns);
                List<ParamModel> params = methodModel.getParams();
                int i = 0;
                for (ParamModel param : params) {
                    String paramNs = param.getTargetNamespace();
                    javax.xml.soap.Name paramName = null;
                    if (param.getName() == null || param.getName().trim().length() == 0) continue;
                    if (paramNs != null && paramNs.length() > 0) {
                        String pref = "ns" + String.valueOf(++i);
                        paramName = envelope.createName(param.getName(), pref, paramNs);
                        methodElement.addNamespaceDeclaration(pref, paramNs);
                    } else {
                        paramName = envelope.createName(param.getName());
                    }
                    SOAPElement paramElement = methodElement.addChildElement(paramName);
                    String paramType = param.getParamType();
                    if ("javax.xml.namespace.QName".equals(paramType)) {
                        paramElement.addNamespaceDeclaration("sampleNs", "http://www.netbeans.org/sampleNamespace");
                        paramElement.addTextNode("sampleNs:sampleQName");
                        continue;
                    }
                    paramElement.addTextNode(Utils.getSampleValue(paramType));
                }
                methodModel.setSoapRequest(request);
            }
            catch (SOAPException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private static void setSoapResponse(MethodModel methodModel, String tns) {
        if (methodModel.isOneWay()) {
            return;
        }
        MessageFactory messageFactory = null;
        try {
            messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.FINE, NbBundle.getMessage(Utils.class, (String)"MSG_SAAJ_PROBLEM"), ex);
        }
        if (messageFactory != null) {
            try {
                SOAPMessage response = messageFactory.createMessage();
                SOAPPart part = response.getSOAPPart();
                SOAPEnvelope envelope = part.getEnvelope();
                String prefix = envelope.getPrefix();
                if (!"soap".equals(prefix)) {
                    envelope.removeAttribute("xmlns:" + prefix);
                    envelope.setPrefix("soap");
                }
                SOAPBody body = envelope.getBody();
                body.setPrefix("soap");
                SOAPHeader header = envelope.getHeader();
                envelope.removeChild((Node)header);
                javax.xml.soap.Name responseName = envelope.createName(methodModel.getOperationName() + "Response");
                SOAPBodyElement responseElement = body.addBodyElement(responseName);
                responseElement.setPrefix("ns0");
                responseElement.addNamespaceDeclaration("ns0", tns);
                ResultModel resultModel = methodModel.getResult();
                String resultNs = resultModel.getTargetNamespace();
                javax.xml.soap.Name resultName = null;
                if (resultNs != null && resultNs.length() > 0) {
                    responseElement.addNamespaceDeclaration("ns1", resultNs);
                    resultName = envelope.createName(resultModel.getName(), "ns1", resultNs);
                } else {
                    resultName = envelope.createName(resultModel.getName());
                }
                String resultType = resultModel.getResultType();
                if ("javax.xml.namespace.QName".equals(resultType)) {
                    SOAPElement resultElement = responseElement.addChildElement(resultName);
                    resultElement.addNamespaceDeclaration("sampleNs", "http://www.netbeans.org/sampleNamespace");
                    resultElement.addTextNode("sampleNs:sampleQName");
                } else if (!"void".equals(resultType)) {
                    SOAPElement resultElement = responseElement.addChildElement(resultName);
                    resultElement.addTextNode(Utils.getSampleValue(resultType));
                }
                methodModel.setSoapResponse(response);
            }
            catch (SOAPException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private static String getSampleValue(String paramType) {
        if ("java.lang.String".equals(paramType)) {
            return "sample text";
        }
        if ("int".equals(paramType) || "java.lang.Integer".equals(paramType) || "java.math.BigInteger".equals(paramType)) {
            return "99";
        }
        if ("double".equals(paramType) || "java.lang.Double".equals(paramType)) {
            return "999.999";
        }
        if ("float".equals(paramType) || "java.lang.Float".equals(paramType) || "java.math.BigDecimal".equals(paramType)) {
            return "99.99";
        }
        if ("long".equals(paramType) || "java.lang.Long".equals(paramType)) {
            return "999";
        }
        if ("boolean".equals(paramType) || "java.lang.Boolean".equals(paramType)) {
            return "false";
        }
        if ("char".equals(paramType) || "java.lang.Char".equals(paramType) || "short".equals(paramType) || "java.lang.Short".equals(paramType)) {
            return "65";
        }
        if ("byte[]".equals(paramType)) {
            return "73616D706C652074657874";
        }
        if ("javax.xml.datatype.XMLGregorianCalendar".equals(paramType) || "java.util.Date".equals(paramType) || "java.util.Calendar".equals(paramType) || "java.util.GregorianCalendar".equals(paramType)) {
            return "2007-04-19";
        }
        if ("javax.xml.datatype.Duration".equals(paramType)) {
            return "P2007Y4M";
        }
        if ("java.net.URI".equals(paramType) || "java.net.URL".equals(paramType)) {
            return "http://www.netbeans.org/sampleURI";
        }
        return "...";
    }

    public static void setJavadoc(FileObject implClass, final MethodModel methodModel, final String text) {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)implClass);
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker make = workingCopy.getTreeMaker();
                ClassTree classTree = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                List<? extends Tree> members = classTree.getMembers();
                TypeElement methodAnotationEl = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
                if (methodAnotationEl == null) {
                    return;
                }
                MethodTree targetMethod = null;
                for (Tree tree : members) {
                    if (Tree.Kind.METHOD != tree.getKind()) continue;
                    MethodTree method = (MethodTree)tree;
                    TreePath methodPath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), method);
                    ExecutableElement methodEl = (ExecutableElement)workingCopy.getTrees().getElement(methodPath);
                    List<? extends AnnotationMirror> methodAnnotations = methodEl.getAnnotationMirrors();
                    block1: for (AnnotationMirror annotationMirror : methodAnnotations) {
                        if (!workingCopy.getTypes().isSameType(methodAnotationEl.asType(), annotationMirror.getAnnotationType())) continue;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                            ExecutableElement ex = entry.getKey();
                            if (!ex.getSimpleName().contentEquals("operationName")) continue;
                            if (!methodModel.getOperationName().equals(entry.getValue().getValue())) break block1;
                            targetMethod = method;
                            break block1;
                        }
                    }
                    if (targetMethod != null) break;
                    if (!method.getName().contentEquals(methodModel.getOperationName())) continue;
                    targetMethod = method;
                    break;
                }
                if (targetMethod != null) {
                    Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)0, (int)0, (int)0, (String)text);
                    MethodTree methodTree = (MethodTree)make.setLabel((Tree)targetMethod, (CharSequence)targetMethod.getName());
                    ElementHandle methodHandle = methodModel.getMethodHandle();
                    Element method = methodHandle.resolve((CompilationInfo)workingCopy);
                    if (method == null) {
                        return;
                    }
                    DocCommentTree javadoc = workingCopy.getDocTrees().getDocCommentTree(method);
                    if (javadoc != null) {
                        make.removeComment((Tree)methodTree, 0, true);
                    }
                    make.addComment((Tree)methodTree, comment, true);
                    workingCopy.rewrite((Tree)targetMethod, (Tree)methodTree);
                }
            }

            public void cancel() {
            }
        };
        try {
            javaSource.runWhenScanFinished((Task)new Task<CompilationController>(){
                final /* synthetic */ CancellableTask val$modificationTask;
                final /* synthetic */ MethodModel val$methodModel;
                {
                    this.val$modificationTask = cancellableTask;
                    this.val$methodModel = methodModel;
                }

                public void run(CompilationController controller) throws Exception {
                    javaSource.runModificationTask((Task)this.val$modificationTask).commit();
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    ElementHandle methodHandle = this.val$methodModel.getMethodHandle();
                    Element method = methodHandle.resolve((CompilationInfo)controller);
                    if (method == null) {
                        return;
                    }
                    Utils.initJavaDoc(controller, (ExecutableElement)method, this.val$methodModel);
                }
            }, true);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public static String getFormatedDocument(SOAPMessage message) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)bos);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            StreamSource source = new StreamSource(bis);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void invokeWsImport(final Project project, final String serviceName) {
        Service service;
        JaxWsModel jaxWsModel;
        if (project != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null && (service = jaxWsModel.findServiceByName(serviceName)) != null && service.getWsdlUrl() != null) {
            final FileObject buildImplFo = project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            try {
                ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                    public Boolean run() throws IOException {
                        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
                        Properties props = WSUtils.identifyWsimport((AntProjectHelper)support.getAntProjectHelper());
                        ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-service-clean-" + serviceName, "wsimport-service-" + serviceName}, (Properties)props);
                        wsimportTask.waitFinished();
                        return Boolean.TRUE;
                    }
                });
            }
            catch (MutexException e) {
                ErrorManager.getDefault().log(e.getLocalizedMessage());
            }
        }
    }

    public static String getCurrentJavaName(final MethodModel method) {
        final String[] javaName = new String[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)method.getImplementationClass());
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.RESOLVED);
                ElementHandle methodHandle = method.getMethodHandle();
                Element methodEl = methodHandle.resolve((CompilationInfo)controller);
                javaName[0] = methodEl.getSimpleName().toString();
            }

            public void cancel() {
            }
        };
        try {
            javaSource.runUserActionTask((Task)task, true);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return javaName[0];
    }

    public static String getAttributeValue(FileObject clazz, final String annotationClass, final String attributeName) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)clazz);
        final String[] attributeValue = new String[]{""};
        if (javaSource != null) {
            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                    if (typeElement != null) {
                        List<? extends AnnotationMirror> annotations = typeElement.getAnnotationMirrors();
                        block0: for (AnnotationMirror annotationMirror : annotations) {
                            Name fqn;
                            Element annotationElement = annotationMirror.getAnnotationType().asElement();
                            if (!(annotationElement instanceof TypeElement) || !(fqn = ((TypeElement)annotationElement).getQualifiedName()).contentEquals(annotationClass)) continue;
                            Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                                String interfaceName;
                                ExecutableElement ex = entry.getKey();
                                if (!ex.getSimpleName().contentEquals(attributeName) || (interfaceName = (String)entry.getValue().getValue()) == null) continue;
                                attributeValue[0] = URLEncoder.encode(interfaceName, "UTF-8");
                                continue block0;
                            }
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)task, true);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return attributeValue[0];
    }

    private static String getPackageReverseOrder(String packageName) {
        String[] names = packageName.split("\\.");
        StringBuffer buf = new StringBuffer();
        for (int i = names.length - 1; i >= 0; --i) {
            if (i < names.length - 1) {
                buf.append(".");
            }
            buf.append(names[i]);
        }
        return buf.toString();
    }
}

