/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.masterfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.filesystems.VCSFilesystemInterceptor;
import org.netbeans.modules.versioning.masterfs.VersioningAnnotationProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;

class FilesystemInterceptor
extends ProvidedExtensions
implements FileChangeListener,
VCSFilesystemInterceptor.VCSAnnotationListener {
    private final VersioningAnnotationProvider vap;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.versioning.FilesystemInterceptor");

    public FilesystemInterceptor(VersioningAnnotationProvider vap) {
        super(true);
        this.vap = vap;
        VCSFilesystemInterceptor.registerFileStatusListener((VCSFilesystemInterceptor.VCSAnnotationListener)this);
        FilesystemInterceptor.getRootFilesystem().addFileChangeListener((FileChangeListener)this);
    }

    static FileSystem getRootFilesystem() {
        try {
            FileObject fo = FileUtil.toFileObject((File)Places.getUserDirectory());
            return fo.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void shutdown() {
        FilesystemInterceptor.getRootFilesystem().removeFileChangeListener((FileChangeListener)this);
    }

    public boolean canWrite(File file) {
        if (file.canWrite()) {
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        return VCSFilesystemInterceptor.canWriteReadonlyFile((VCSFileProxy)VCSFileProxy.createFileProxy((File)file));
    }

    public Object getAttribute(File file, String attrName) {
        return VCSFilesystemInterceptor.getAttribute((VCSFileProxy)VCSFileProxy.createFileProxy((File)file), (String)attrName);
    }

    public void fileChanged(FileEvent fe) {
        VCSFilesystemInterceptor.fileChanged((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fe.getFile()));
    }

    public void beforeChange(FileObject fo) {
        VCSFilesystemInterceptor.beforeChange((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fo));
    }

    public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
        ArrayList arr = new ArrayList();
        long ret = VCSFilesystemInterceptor.listFiles((VCSFileProxy)VCSFileProxy.createFileProxy((File)dir), (long)lastTimeStamp, arr);
        for (VCSFileProxy p : arr) {
            children.add(p.toFile());
        }
        assert (!children.contains(null));
        return ret;
    }

    public ProvidedExtensions.DeleteHandler getDeleteHandler(final File file) {
        VCSFileProxy p = VCSFileProxy.createFileProxy((File)file);
        final VCSFilesystemInterceptor.IOHandler h = VCSFilesystemInterceptor.getDeleteHandler((VCSFileProxy)p);
        if (h == null) {
            return null;
        }
        return new ProvidedExtensions.DeleteHandler(){
            final /* synthetic */ FilesystemInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            public boolean delete(File deleteHandlerFile) {
                try {
                    if (deleteHandlerFile.equals(file)) {
                        h.handle();
                    } else {
                        VCSFilesystemInterceptor.IOHandler h2 = VCSFilesystemInterceptor.getDeleteHandler((VCSFileProxy)VCSFileProxy.createFileProxy((File)deleteHandlerFile));
                        if (h2 == null) {
                            LOG.log(Level.WARNING, "no iohandler for file {0} which is supposed to be from {1}", new Object[]{deleteHandlerFile, file});
                            this.this$0.deleteRecursively(deleteHandlerFile);
                            return !deleteHandlerFile.exists();
                        }
                        h2.handle();
                    }
                    return true;
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, null, ex);
                    return false;
                }
            }
        };
    }

    public void deleteSuccess(FileObject fo) {
        VCSFilesystemInterceptor.deleteSuccess((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fo));
    }

    public void deletedExternally(FileObject fo) {
        VCSFilesystemInterceptor.deletedExternally((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fo));
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void beforeCreate(FileObject parent, String name, boolean isFolder) {
        VCSFilesystemInterceptor.beforeCreate((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)parent), (String)name, (boolean)isFolder);
    }

    public void createFailure(FileObject parent, String name, boolean isFolder) {
        VCSFilesystemInterceptor.createFailure((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)parent), (String)name, (boolean)isFolder);
    }

    public void createSuccess(FileObject fo) {
        VCSFilesystemInterceptor.createSuccess((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fo));
    }

    public void createdExternally(FileObject fo) {
        VCSFilesystemInterceptor.createdExternally((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fo));
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public ProvidedExtensions.IOHandler getMoveHandler(File from, File to) {
        return this.wrap(VCSFilesystemInterceptor.getMoveHandler((VCSFileProxy)VCSFileProxy.createFileProxy((File)from), (VCSFileProxy)VCSFileProxy.createFileProxy((File)to)));
    }

    public ProvidedExtensions.IOHandler getRenameHandler(File from, String newName) {
        return this.wrap(VCSFilesystemInterceptor.getRenameHandler((VCSFileProxy)VCSFileProxy.createFileProxy((File)from), (String)newName));
    }

    public void moveSuccess(FileObject from, File to) {
        VCSFilesystemInterceptor.afterMove((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)from), (VCSFileProxy)VCSFileProxy.createFileProxy((File)to));
    }

    public void fileRenamed(FileRenameEvent fe) {
        String name = fe.getName();
        String ext = fe.getExt();
        if (ext != null && !ext.isEmpty()) {
            name = name + "." + ext;
        }
        VCSFilesystemInterceptor.afterMove((VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fe.getFile()).getParentFile(), (String)name), (VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fe.getFile()));
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        LOG.log(Level.FINE, "fileAttributeChanged {0}", fe.getFile());
    }

    public ProvidedExtensions.IOHandler getCopyHandler(File from, File to) {
        return this.wrap(VCSFilesystemInterceptor.getCopyHandler((VCSFileProxy)VCSFileProxy.createFileProxy((File)from), (VCSFileProxy)VCSFileProxy.createFileProxy((File)to)));
    }

    public void beforeCopy(FileObject from, File to) {
        VCSFilesystemInterceptor.beforeCopy((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)from), (VCSFileProxy)VCSFileProxy.createFileProxy((File)to));
    }

    public void copySuccess(FileObject from, File to) {
        VCSFilesystemInterceptor.copySuccess((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)from), (VCSFileProxy)VCSFileProxy.createFileProxy((File)to));
    }

    public void copyFailure(FileObject from, File to) {
    }

    public void fileLocked(FileObject fo) throws IOException {
        VCSFilesystemInterceptor.fileLocked((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fo));
    }

    public void annotationChanged(VCSFilesystemInterceptor.VCSAnnotationEvent ev) {
        this.vap.deliverStatusEvent(FilesystemInterceptor.getRootFilesystem(), ev);
    }

    private ProvidedExtensions.IOHandler wrap(final VCSFilesystemInterceptor.IOHandler io) {
        if (io == null) {
            return null;
        }
        return new ProvidedExtensions.IOHandler(){
            final /* synthetic */ FilesystemInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            public void handle() throws IOException {
                io.handle();
            }
        };
    }

    private void deleteRecursively(File file) throws IOException {
        if (file.isFile()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    this.deleteRecursively(f);
                }
            }
            file.delete();
        }
    }
}

