/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.bugtracking.commons.StackTraceSupport;
import org.netbeans.modules.bugtracking.commons.Support;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.team.ide.spi.IDEServices;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class FindTypesSupport
implements MouseMotionListener,
MouseListener {
    private static final Pattern JAVA_CLASS_NAME_PATTERN = Pattern.compile("\\.?([a-z0-9\\.]*)([A-Z]\\w+)+");
    private static final String HIGHLIGHTS_PROPERTY = "highlights.property";
    private static final String PREV_HIGHLIGHT_PROPERTY = "prev.highlights.property";
    private static final String PREV_HIGHLIGHT_ATTRIBUTES = "prev.highlights.attributes";
    private static FindTypesSupport instance;
    private final Style defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
    private final PopupMenu popupMenu = new PopupMenu();

    private FindTypesSupport() {
    }

    public static FindTypesSupport getInstance() {
        if (instance == null) {
            instance = new FindTypesSupport();
        }
        return instance;
    }

    private Highlight getHighlight(JTextPane pane, int offset) {
        List<Highlight> highlights = this.getHighlights(pane);
        Highlight h = null;
        for (int i = 0; i < highlights.size(); ++i) {
            h = highlights.get(i);
            if (h.startOffset <= offset && h.endOffset >= offset) break;
            h = null;
        }
        return h;
    }

    private List<Highlight> getHighlights(JTextPane pane) {
        LinkedList highlights = (LinkedList)pane.getClientProperty(HIGHLIGHTS_PROPERTY);
        if (highlights == null) {
            highlights = new LinkedList();
            pane.putClientProperty(HIGHLIGHTS_PROPERTY, highlights);
        }
        return highlights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(final JTextPane pane) {
        IDEServices ideServices = Support.getInstance().getIDEServices();
        if (ideServices == null || !ideServices.providesJumpTo()) {
            return;
        }
        long t = System.currentTimeMillis();
        try {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ FindTypesSupport this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    StyledDocument doc = pane.getStyledDocument();
                    Style hlStyle = doc.addStyle("regularBlue-findtype", this.this$0.defStyle);
                    hlStyle.addAttribute("attribute.type.link", this.this$0.new TypeLink());
                    StyleConstants.setForeground(hlStyle, UIUtils.getLinkColor());
                    StyleConstants.setUnderline(hlStyle, true);
                    List<Object> l = Collections.emptyList();
                    try {
                        l = FindTypesSupport.getHighlightOffsets(doc.getText(0, doc.getLength()));
                    }
                    catch (BadLocationException ex) {
                        Support.LOG.log(Level.SEVERE, null, ex);
                    }
                    ArrayList<Highlight> highlights = new ArrayList<Highlight>(l.size());
                    for (int i = 0; i < l.size(); ++i) {
                        highlights.add(this.this$0.new Highlight((Integer)l.get(i), (Integer)l.get(++i)));
                    }
                    pane.putClientProperty(FindTypesSupport.HIGHLIGHTS_PROPERTY, highlights);
                    pane.removeMouseMotionListener(this.this$0);
                    pane.addMouseMotionListener(this.this$0);
                    pane.removeMouseListener(this.this$0);
                    pane.addMouseListener(this.this$0);
                }
            });
        }
        catch (Throwable throwable) {
            Support.LOG.log(Level.FINE, "{0}.register took  {1}", new Object[]{this.getClass().getName(), System.currentTimeMillis() - t});
            throw throwable;
        }
        Support.LOG.log(Level.FINE, "{0}.register took  {1}", new Object[]{this.getClass().getName(), System.currentTimeMillis() - t});
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int modifiers;
        JTextPane pane = (JTextPane)e.getSource();
        StyledDocument doc = pane.getStyledDocument();
        int offset = pane.viewToModel(e.getPoint());
        Element elem = doc.getCharacterElement(offset);
        Highlight h = this.getHighlight(pane, offset);
        Highlight prevHighlight = (Highlight)pane.getClientProperty(PREV_HIGHLIGHT_PROPERTY);
        AttributeSet prevAs = (AttributeSet)pane.getClientProperty(PREV_HIGHLIGHT_ATTRIBUTES);
        if (prevHighlight != null && prevAs != null) {
            doc.setCharacterAttributes(prevHighlight.startOffset, prevHighlight.endOffset - prevHighlight.startOffset, prevAs, true);
            pane.putClientProperty(PREV_HIGHLIGHT_PROPERTY, null);
            pane.putClientProperty(PREV_HIGHLIGHT_ATTRIBUTES, null);
        }
        if (((modifiers = e.getModifiers() | e.getModifiersEx()) & 0x80) == 128 || (modifiers & 0x100) == 256) {
            AttributeSet as = elem.getAttributes();
            if (StyleConstants.isUnderline(as)) {
                return;
            }
            Font font = doc.getFont(as);
            FontMetrics fontMetrics = pane.getFontMetrics(font);
            try {
                Rectangle rectangle = new Rectangle(pane.modelToView((int)elem.getStartOffset()).x, pane.modelToView((int)elem.getStartOffset()).y, fontMetrics.stringWidth(doc.getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset())), fontMetrics.getHeight());
                if (h != null && offset < elem.getEndOffset() - 1 && rectangle.contains(e.getPoint())) {
                    Style hlStyle = doc.getStyle("regularBlue-findtype");
                    pane.putClientProperty(PREV_HIGHLIGHT_ATTRIBUTES, as.copyAttributes());
                    doc.setCharacterAttributes(h.startOffset, h.endOffset - h.startOffset, hlStyle, true);
                    pane.putClientProperty(PREV_HIGHLIGHT_PROPERTY, h);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static List<Integer> getHighlightOffsets(String txt) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        if (txt == null) {
            return Collections.emptyList();
        }
        Matcher m = JAVA_CLASS_NAME_PATTERN.matcher(txt);
        while (m.find()) {
            int last = m.end();
            int start = last - (m.group(1) != null ? m.group(1).length() : 0) - m.group(2).length();
            result.add(start);
            result.add(last);
        }
        return result;
    }

    private Element element(MouseEvent e) {
        JTextPane pane = (JTextPane)e.getSource();
        StyledDocument doc = pane.getStyledDocument();
        return doc.getCharacterElement(pane.viewToModel(e.getPoint()));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            if (SwingUtilities.isLeftMouseButton(e)) {
                Element elem = this.element(e);
                AttributeSet as = elem.getAttributes();
                TypeLink action = (TypeLink)as.getAttribute("attribute.type.link");
                if (action != null) {
                    try {
                        String name = elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                        int idx = name.lastIndexOf(".");
                        if (idx > -1 && name.length() > idx) {
                            name = name.substring(idx + 1);
                        }
                        action.jumpTo(name);
                    }
                    catch (BadLocationException ex) {
                        Support.LOG.log(Level.SEVERE, null, ex);
                    }
                }
            } else if (SwingUtilities.isRightMouseButton(e)) {
                this.popupMenu.clickPoint.setLocation(e.getPoint());
                this.popupMenu.pane = (JTextPane)e.getSource();
                this.popupMenu.show((JTextPane)e.getSource(), e.getPoint().x, e.getPoint().y);
            }
        }
        catch (Exception ex) {
            Support.LOG.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class PopupMenu
    extends JPopupMenu {
        private final Point clickPoint = new Point();
        private JTextPane pane;

        private PopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.clickPoint.setLocation(x, y);
            super.show(invoker, x, y);
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                int offset;
                StyledDocument doc = this.pane.getStyledDocument();
                Element elem = doc.getCharacterElement(offset = this.pane.viewToModel(this.clickPoint));
                AttributeSet as = elem.getAttributes();
                final TypeLink link = (TypeLink)as.getAttribute("attribute.type.link");
                if (link != null) {
                    try {
                        String name = elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                        int idx = name.lastIndexOf(".");
                        final String shortname = idx > -1 && name.length() > idx ? name.substring(idx + 1) : name;
                        this.add(new JMenuItem(new AbstractAction(this, NbBundle.getMessage(FindTypesSupport.class, (String)"MSG_GotoType", (Object)name)){
                            final /* synthetic */ PopupMenu this$1;
                            {
                                this.this$1 = this$1;
                                super(arg0);
                            }

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                link.jumpTo(shortname);
                            }
                        }));
                        if (name.length() > shortname.length()) {
                            final String path = name.replace(".", "/") + ".java";
                            this.add(new JMenuItem(new AbstractAction(this, NbBundle.getMessage(FindTypesSupport.class, (String)"MSG_OpenType", (Object)name)){
                                final /* synthetic */ PopupMenu this$1;
                                {
                                    this.this$1 = this$1;
                                    super(arg0);
                                }

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    StackTraceSupport.open(path, -1);
                                }
                            }));
                        }
                    }
                    catch (Exception ex) {
                        Support.LOG.log(Level.SEVERE, null, ex);
                    }
                    super.setVisible(true);
                } else {
                    super.setVisible(false);
                }
            } else {
                super.setVisible(false);
                this.removeAll();
            }
        }
    }

    private class Highlight {
        int startOffset;
        int endOffset;

        public Highlight(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Highlight other = (Highlight)obj;
            if (this.startOffset != other.startOffset) {
                return false;
            }
            return this.endOffset == other.endOffset;
        }

        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + this.startOffset;
            hash = 71 * hash + this.endOffset;
            return hash;
        }
    }

    private class TypeLink {
        private TypeLink() {
        }

        public void jumpTo(String resource) {
            IDEServices ideServices = Support.getInstance().getIDEServices();
            if (ideServices != null) {
                ideServices.jumpTo(resource, NbBundle.getMessage(FindTypesSupport.class, (String)"LBL_FindType"));
            }
        }
    }
}

