/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.event.KeyEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.tax.TreeObject;
import org.openide.util.WeakListeners;

public abstract class AbstractTreeCustomizer
extends JPanel
implements Customizer,
PropertyChangeListener {
    private static final long serialVersionUID = 7141277140374364170L;
    private static final String TEXT_DEFAULT = Util.THIS.getString("TEXT_DEFAULT");
    public static final String MIME_XML = "text/xml";
    public static final String MIME_DTD = "text/x-dtd";
    public static final String MIME_TXT = "text/plain";
    protected boolean initializing = false;
    private TreeObject treeObject = null;
    private boolean treeListening = false;

    @Override
    public final void setObject(Object bean) throws IllegalArgumentException {
        try {
            this.initializing = true;
            if (!(bean instanceof TreeObject)) {
                throw new IllegalArgumentException(Util.THIS.getString("PROP__invalid_instance", bean));
            }
            this.treeObject = (TreeObject)bean;
            this.ownInitComponents();
            this.initValues();
        }
        finally {
            this.initializing = false;
        }
    }

    protected final TreeObject getTreeObject() {
        return this.treeObject;
    }

    private final void initValues() {
        this.initComponentValues();
        this.updateReadOnlyStatus();
        this.initListeners();
    }

    protected abstract void initComponentValues();

    protected void ownInitComponents() {
    }

    private void updateReadOnlyStatus() {
        this.updateReadOnlyStatus(!this.getTreeObject().isReadOnly());
    }

    protected abstract void updateReadOnlyStatus(boolean var1);

    private void initListeners() {
        if (!this.treeListening) {
            this.treeObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.treeObject));
            this.treeListening = true;
        }
    }

    protected void safePropertyChange(PropertyChangeEvent pche) {
        if (pche.getPropertyName().equals("readOnly")) {
            this.updateReadOnlyStatus();
        }
    }

    @Override
    public final void propertyChange(final PropertyChangeEvent e) {
        if (this.initializing) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.safePropertyChange(e);
        } else {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ AbstractTreeCustomizer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.safePropertyChange(e);
                }
            });
        }
    }

    protected static String text2null(String text) {
        if (text.equals(TEXT_DEFAULT)) {
            return null;
        }
        if (text.length() == 0) {
            return null;
        }
        if (text.trim().length() == 0) {
            return null;
        }
        return text;
    }

    protected static String null2text(String maybeNull) {
        if (maybeNull == null) {
            return TEXT_DEFAULT;
        }
        return maybeNull;
    }

    protected static boolean applyKeyPressed(KeyEvent evt) {
        return evt.isControlDown() && evt.getKeyCode() == 10;
    }
}

