/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.dlg.AddTableColumnDDL;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;
import org.netbeans.modules.db.explorer.dlg.DataModel;
import org.netbeans.modules.db.explorer.dlg.TypeElement;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AddTableColumnDialog
extends JPanel {
    static final Logger LOGGER = Logger.getLogger(AddTableColumnDialog.class.getName());
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport statusLine;
    Dialog dialog = null;
    JTextField colnamefield;
    JTextField colsizefield;
    JTextField colscalefield;
    JTextField defvalfield;
    JTextArea checkfield;
    JComboBox coltypecombo;
    JCheckBox pkcheckbox;
    JCheckBox ixcheckbox;
    JCheckBox checkcheckbox;
    JCheckBox nullcheckbox;
    JCheckBox uniquecheckbox;
    DataModel dmodel = new DataModel();
    private final Collection<String> sizelesstypes;
    private final Collection<String> charactertypes;

    public AddTableColumnDialog(Specification spe) {
        this.setBorder(new EmptyBorder(new Insets(12, 12, 5, 11)));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnName"));
        label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnNameA11yDesc"));
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 17;
        con.insets = new Insets(0, 0, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.add((Component)label, con);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.gridy = 0;
        con.gridwidth = 3;
        con.gridheight = 1;
        con.fill = 2;
        con.insets = new Insets(0, 12, 0, 0);
        con.weightx = 1.0;
        con.weighty = 0.0;
        this.colnamefield = new JTextField(35);
        this.colnamefield.setName("name");
        this.colnamefield.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnNameTextFieldA11yDesc"));
        this.colnamefield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnNameTextFieldA11yName"));
        label.setLabelFor(this.colnamefield);
        this.add((Component)this.colnamefield, con);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddTableColumnDialog.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddTableColumnDialog.this.updateState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddTableColumnDialog.this.updateState();
            }
        };
        this.colnamefield.getDocument().addDocumentListener(docListener);
        List sizelesstypesSpec = (List)spe.getProperties().get("SizelessTypes");
        List charactertypesSpec = (List)spe.getProperties().get("CharacterTypes");
        this.sizelesstypes = sizelesstypesSpec != null ? sizelesstypesSpec : Collections.emptyList();
        this.charactertypes = charactertypesSpec != null ? charactertypesSpec : Collections.emptyList();
        Map tmap = spe.getTypeMap();
        ArrayList<TypeElement> ttab = new ArrayList<TypeElement>(tmap.size());
        for (String key : tmap.keySet()) {
            ttab.add(new TypeElement(key, (String)tmap.get(key)));
        }
        ColumnItem item = new ColumnItem();
        item.setProperty("type", ttab.get(0));
        this.dmodel.addRow(item);
        label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnType"));
        label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnTypeA11yDesc"));
        con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 1;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 17;
        con.insets = new Insets(12, 0, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.add((Component)label, con);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        con.gridheight = 1;
        con.fill = 2;
        con.insets = new Insets(12, 12, 0, 0);
        con.weightx = 1.0;
        con.weighty = 0.0;
        this.coltypecombo = new JComboBox<Object>(ttab.toArray());
        this.coltypecombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTableColumnDialog.this.updateState();
            }
        });
        this.coltypecombo.setName("type");
        this.coltypecombo.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnTypeComboBoxA11yDesc"));
        this.coltypecombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnTypeComboBoxA11yName"));
        label.setLabelFor(this.coltypecombo);
        this.add((Component)this.coltypecombo, con);
        label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnSize"));
        label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnSizeA11yDesc"));
        con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 2;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 17;
        con.insets = new Insets(12, 0, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.add((Component)label, con);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.gridy = 2;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.fill = 2;
        con.insets = new Insets(12, 12, 0, 0);
        con.weightx = 1.0;
        con.weighty = 0.0;
        this.colsizefield = new JTextField();
        this.colsizefield.setName("size");
        this.colsizefield.getDocument().addDocumentListener(docListener);
        this.colsizefield.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnSizeTextFieldA11yDesc"));
        this.colsizefield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnSizeTextFieldA11yName"));
        label.setLabelFor(this.colsizefield);
        this.add((Component)this.colsizefield, con);
        label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnScale"));
        label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnScaleA11yDesc"));
        con = new GridBagConstraints();
        con.gridx = 2;
        con.gridy = 2;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 17;
        con.insets = new Insets(12, 12, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.add((Component)label, con);
        con = new GridBagConstraints();
        con.gridx = 3;
        con.gridy = 2;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.fill = 2;
        con.insets = new Insets(12, 12, 0, 0);
        con.weightx = 1.0;
        con.weighty = 0.0;
        this.colscalefield = new JTextField();
        this.colscalefield.setName("scale");
        this.colscalefield.getDocument().addDocumentListener(docListener);
        this.colscalefield.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnScaleTextFieldA11yDesc"));
        this.colscalefield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnScaleTextFieldA11yName"));
        label.setLabelFor(this.colscalefield);
        this.add((Component)this.colscalefield, con);
        label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnDefault"));
        label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnDefaultA11yDesc"));
        con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 3;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 17;
        con.insets = new Insets(12, 0, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.add((Component)label, con);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 3;
        con.gridheight = 1;
        con.fill = 2;
        con.insets = new Insets(12, 12, 0, 0);
        con.weightx = 1.0;
        con.weighty = 0.0;
        this.defvalfield = new JTextField(35);
        this.defvalfield.setName("defval");
        this.defvalfield.getDocument().addDocumentListener(docListener);
        this.defvalfield.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnDefaultTextFieldA11yDesc"));
        this.defvalfield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnDefaultTextFieldA11yName"));
        label.setLabelFor(this.defvalfield);
        layout.setConstraints(this.defvalfield, con);
        this.add(this.defvalfield);
        JPanel subpane = new JPanel();
        subpane.setBorder(new TitledBorder(NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnConstraintsTitle")));
        GridBagLayout sublayout = new GridBagLayout();
        subpane.setLayout(sublayout);
        ItemListener checkBoxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBox cbx = (JCheckBox)e.getSource();
                AddTableColumnDialog.this.dmodel.setValue(cbx.isSelected(), cbx.getName(), 0);
            }
        };
        con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 17;
        con.insets = new Insets(0, 0, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.pkcheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.pkcheckbox, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnConstraintPKTitle"));
        this.pkcheckbox.setName("pkey");
        this.pkcheckbox.addItemListener(checkBoxListener);
        this.pkcheckbox.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnConstraintPKTitleA11yDesc"));
        subpane.add((Component)this.pkcheckbox, con);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 17;
        con.insets = new Insets(0, 12, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.uniquecheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.uniquecheckbox, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnConstraintUniqueTitle"));
        this.uniquecheckbox.setName("unique");
        this.uniquecheckbox.addItemListener(checkBoxListener);
        this.uniquecheckbox.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnConstraintUniqueTitleA11yDesc"));
        subpane.add((Component)this.uniquecheckbox, con);
        con = new GridBagConstraints();
        con.gridx = 2;
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 17;
        con.insets = new Insets(0, 12, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.nullcheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.nullcheckbox, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnConstraintNullTitle"));
        this.nullcheckbox.setName("nullable");
        this.nullcheckbox.addItemListener(checkBoxListener);
        this.nullcheckbox.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnConstraintNullTitleA11yDesc"));
        subpane.add((Component)this.nullcheckbox, con);
        con = new GridBagConstraints();
        con.gridx = 3;
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 17;
        con.insets = new Insets(0, 12, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.ixcheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.ixcheckbox, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnIndexName"));
        this.ixcheckbox.setName("idx");
        this.ixcheckbox.addItemListener(checkBoxListener);
        this.ixcheckbox.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnIndexNameA11yDesc"));
        subpane.add((Component)this.ixcheckbox, con);
        con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 4;
        con.gridwidth = 4;
        con.gridheight = 1;
        con.fill = 2;
        con.insets = new Insets(12, 0, 0, 0);
        con.weightx = 1.0;
        con.weighty = 0.0;
        this.add((Component)subpane, con);
        con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 5;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 18;
        con.insets = new Insets(12, 0, 0, 0);
        con.weightx = 0.0;
        con.weighty = 0.0;
        this.checkcheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.checkcheckbox, (String)NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumnConstraintCheckTitle"));
        this.checkcheckbox.setName("check");
        this.checkcheckbox.addItemListener(checkBoxListener);
        this.checkcheckbox.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnCheckTitleA11yDesc"));
        this.add((Component)this.checkcheckbox, con);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.gridy = 5;
        con.gridwidth = 3;
        con.gridheight = 1;
        con.fill = 1;
        con.insets = new Insets(12, 12, 0, 0);
        con.weightx = 1.0;
        con.weighty = 1.0;
        this.checkfield = new JTextArea(3, 35);
        this.checkfield.setName("checkcode");
        this.checkfield.getDocument().addDocumentListener(docListener);
        this.checkfield.setToolTipText(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnCheckTextAreaA11yDesc"));
        this.checkfield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnCheckTextAreaA11yName"));
        this.checkfield.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnCheckTextAreaA11yDesc"));
        JScrollPane spane = new JScrollPane(this.checkfield);
        this.add((Component)spane, con);
        this.checkcheckbox.setSelected(false);
        this.checkcheckbox.setSelected(false);
        this.nullcheckbox.setSelected(true);
        this.uniquecheckbox.setSelected(false);
        item.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String pname = evt.getPropertyName();
                Object nval = evt.getNewValue();
                if (nval instanceof Boolean) {
                    boolean set = (Boolean)nval;
                    if (pname.equals("pkey")) {
                        AddTableColumnDialog.this.pkcheckbox.setSelected(set);
                    } else if (pname.equals("idx")) {
                        AddTableColumnDialog.this.ixcheckbox.setSelected(set);
                    } else if (pname.equals("unique")) {
                        AddTableColumnDialog.this.uniquecheckbox.setSelected(set);
                        AddTableColumnDialog.this.ixcheckbox.setEnabled(!set);
                    } else if (pname.equals("nullable")) {
                        AddTableColumnDialog.this.nullcheckbox.setSelected(set);
                    }
                }
            }
        });
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ACS_AddTableColumnDialogA11yDesc"));
        this.doLayout();
        Dimension referenceCurDimension = this.colsizefield.getSize();
        Dimension referencePrefDimension = this.colsizefield.getPreferredSize();
        Dimension referenceMinDimension = this.colsizefield.getMinimumSize();
        Dimension referenceMaxDimension = this.colsizefield.getMaximumSize();
        this.colsizefield.setSize(referenceCurDimension);
        this.colsizefield.setPreferredSize(referencePrefDimension);
        this.colsizefield.setMinimumSize(referenceMinDimension);
        this.colsizefield.setMaximumSize(referenceMaxDimension);
        this.colscalefield.setSize(referenceCurDimension);
        this.colscalefield.setPreferredSize(referencePrefDimension);
        this.colscalefield.setMinimumSize(referenceMinDimension);
        this.colscalefield.setMaximumSize(referenceMaxDimension);
    }

    private Integer getIntValue(JTextField textField) {
        String text = textField.getText();
        try {
            if (text == null || text.length() == 0) {
                text = "0";
            }
            return Integer.valueOf(text);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private void updateState() {
        String columnType;
        assert (this.statusLine != null) : "Notification status line not available";
        Object selectedItem = this.coltypecombo.getSelectedItem();
        String string = columnType = selectedItem == null ? null : selectedItem.toString();
        if (this.sizelesstypes.contains(columnType)) {
            if (this.colsizefield.isEditable()) {
                this.colsizefield.setText(null);
                this.colscalefield.setText(null);
            }
            this.colsizefield.setEditable(false);
            this.colscalefield.setEditable(false);
            this.colsizefield.setEnabled(false);
            this.colscalefield.setEnabled(false);
        } else {
            boolean disableScale = this.charactertypes.contains(columnType);
            this.colsizefield.setEditable(true);
            this.colscalefield.setEditable(!disableScale);
            this.colsizefield.setEnabled(true);
            this.colscalefield.setEnabled(!disableScale);
            if (disableScale) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddTableColumnDialog.this.colscalefield.setText(null);
                    }
                });
            }
        }
        String columnName = this.colnamefield.getText();
        if (columnName == null || columnName.length() < 1) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumn_EmptyColName"));
            this.updateOK(false);
            return;
        }
        Integer size = this.getIntValue(this.colsizefield);
        if (size == null) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumn_SizeNotNumber"));
            this.updateOK(false);
            return;
        }
        Integer scale = this.getIntValue(this.colscalefield);
        if (scale == null) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumn_ScaleNotNumber"));
            this.updateOK(false);
            return;
        }
        if (columnType.equals("VARCHAR")) {
            if (size == 0) {
                this.statusLine.setInformationMessage(NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumn_NotVarcharSize"));
                this.updateOK(false);
                return;
            }
            if (this.defvalfield.getText().length() > size) {
                this.statusLine.setInformationMessage(NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumn_DefaultOverSize"));
                this.updateOK(false);
                return;
            }
        }
        if (size < scale) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddTableColumn_ScaleOverSize"));
            this.updateOK(false);
            return;
        }
        this.dmodel.setValue(columnName, this.colnamefield.getName(), 0);
        this.dmodel.setValue(scale, this.colscalefield.getName(), 0);
        this.dmodel.setValue(size, this.colsizefield.getName(), 0);
        this.dmodel.setValue(this.defvalfield.getText(), this.defvalfield.getName(), 0);
        this.dmodel.setValue(this.checkfield.getText(), this.checkfield.getName(), 0);
        this.dmodel.setValue(this.coltypecombo.getSelectedItem(), this.coltypecombo.getName(), 0);
        this.statusLine.clearMessages();
        this.updateOK(true);
    }

    private void updateOK(boolean valid) {
        if (this.descriptor != null) {
            this.descriptor.setValid(valid);
        }
    }

    private void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        this.statusLine = descriptor.getNotificationLineSupport();
        this.updateState();
    }

    private ColumnItem getColumnItem() {
        return (ColumnItem)this.dmodel.getData().get(0);
    }

    private void setValues(ColumnItem columnItem) {
        this.colnamefield.setText(columnItem.getName());
        this.coltypecombo.setSelectedItem(columnItem.getType());
        if (!this.sizelesstypes.contains(columnItem.getType().toString())) {
            this.colsizefield.setText(String.valueOf(columnItem.getSize()));
            this.colscalefield.setText(String.valueOf(columnItem.getScale()));
        }
        this.defvalfield.setText(columnItem.getDefaultValue());
        this.pkcheckbox.setSelected(columnItem.isPrimaryKey());
        this.uniquecheckbox.setSelected(columnItem.isUnique());
        this.nullcheckbox.setSelected(columnItem.allowsNull());
        this.ixcheckbox.setSelected(columnItem.isIndexed());
        this.checkcheckbox.setSelected(columnItem.hasCheckConstraint());
        this.checkfield.setText(columnItem.getCheckConstraint());
    }

    public static ColumnItem showDialog(Specification spec, ColumnItem columnItem) {
        AddTableColumnDialog panel = new AddTableColumnDialog(spec);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddColumnDialogTitle"));
        descriptor.createNotificationLineSupport();
        panel.setDescriptor(descriptor);
        if (columnItem != null) {
            panel.setValues(columnItem);
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setVisible(true);
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return panel.getColumnItem();
        }
        return null;
    }

    public static boolean showDialogAndCreate(Specification spec, TableNode node) {
        final AddTableColumnDialog panel = new AddTableColumnDialog(spec);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(AddTableColumnDialog.class, (String)"AddColumnDialogTitle"));
        descriptor.createNotificationLineSupport();
        descriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        panel.setDescriptor(descriptor);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        String tableName = node.getName();
        String schemaName = node.getSchemaName();
        String catName = node.getCatalogName();
        if (schemaName == null) {
            schemaName = catName;
        }
        final AddTableColumnDDL ddl = new AddTableColumnDDL(spec, schemaName, tableName);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean wasException;
                if (event.getSource() != DialogDescriptor.OK_OPTION) {
                    return;
                }
                final ColumnItem columnItem = (ColumnItem)panel.dmodel.getData().get(0);
                try {
                    wasException = DbUtilities.doWithProgress(null, new Callable<Boolean>(){
                        final /* synthetic */ 6 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            return ddl.execute(panel.colnamefield.getText(), columnItem);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof DDLException) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                    } else {
                        LOGGER.log(Level.INFO, cause.getLocalizedMessage(), cause);
                        DbUtilities.reportError(NbBundle.getMessage(AddTableColumnDialog.class, (String)"ERR_UnableToAddColumn"), e.getMessage());
                    }
                    return;
                }
                if (wasException) {
                    return;
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        descriptor.setButtonListener(listener);
        dialog.setVisible(true);
        return descriptor.getValue() != DialogDescriptor.CANCEL_OPTION;
    }
}

