/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SchemaPanel
extends JPanel {
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private JTextArea commentTextArea;
    private JPanel connectProgressPanel;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JComboBox schemaComboBox;
    private JLabel schemaLabel;

    public SchemaPanel(ConnectionDialogMediator mediator, DatabaseConnection dbcon) {
        this.initComponents();
        this.initAccessibility();
        ConnectionProgressListener progressListener = new ConnectionProgressListener(){

            @Override
            public void connectionStarted() {
                SchemaPanel.this.startProgress();
            }

            @Override
            public void connectionStep(String step) {
                SchemaPanel.this.setProgressMessage(step);
            }

            @Override
            public void connectionFinished() {
                SchemaPanel.this.stopProgress(true);
            }

            @Override
            public void connectionFailed() {
                SchemaPanel.this.stopProgress(false);
            }
        };
        mediator.addConnectionProgressListener(progressListener);
    }

    private void initAccessibility() {
        this.schemaLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_SchemaDialogTextA11yDesc"));
        this.schemaComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_SchemaDialogTextComboBoxA11yName"));
        this.commentTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_SchemaPanelCommentA11yName"));
        this.commentTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_SchemaPanelCommentA11yDesc"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_ConnectionProgressBarA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_ConnectionProgressBarA11yDesc"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_GetSchemasPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_GetSchemasPanelA11yDesc"));
    }

    private void initComponents() {
        this.commentTextArea = new JTextArea();
        this.schemaLabel = new JLabel();
        this.schemaComboBox = new JComboBox();
        this.connectProgressPanel = new JPanel();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        this.setMinimumSize(new Dimension(163, 163));
        this.setPreferredSize(new Dimension(163, 1));
        this.setLayout(new GridBagLayout());
        this.commentTextArea.setEditable(false);
        this.commentTextArea.setFont(UIManager.getFont("Label.font"));
        this.commentTextArea.setLineWrap(true);
        this.commentTextArea.setText(NbBundle.getMessage(SchemaPanel.class, (String)"MSG_SchemaPanelComment"));
        this.commentTextArea.setWrapStyleWord(true);
        this.commentTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.commentTextArea.setEnabled(false);
        this.commentTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.commentTextArea, gridBagConstraints);
        this.schemaLabel.setLabelFor(this.schemaComboBox);
        Mnemonics.setLocalizedText((JLabel)this.schemaLabel, (String)NbBundle.getMessage(SchemaPanel.class, (String)"SchemaDialogText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.schemaLabel, gridBagConstraints);
        this.schemaComboBox.setToolTipText(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_SchemaDialogTextComboBoxA11yDesc"));
        this.schemaComboBox.setEnabled(false);
        this.schemaComboBox.setPrototypeDisplayValue("wwwwwwwwww");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.schemaComboBox, gridBagConstraints);
        this.connectProgressPanel.setToolTipText(NbBundle.getMessage(SchemaPanel.class, (String)"ACS_ConnectionProgressBarA11yDesc"));
        this.connectProgressPanel.setLayout(new BorderLayout(0, 5));
        Mnemonics.setLocalizedText((JLabel)this.progressMessageLabel, (String)" ");
        this.connectProgressPanel.add((Component)this.progressMessageLabel, "North");
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.progressContainerPanel.setLayout(new BorderLayout());
        this.connectProgressPanel.add((Component)this.progressContainerPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.connectProgressPanel, gridBagConstraints);
    }

    public String getSchema() {
        Object schema = this.schemaComboBox.getSelectedItem();
        if (schema != null && !schema.toString().equals(NbBundle.getMessage(SchemaPanel.class, (String)"TXT_NoSchema"))) {
            return schema.toString();
        }
        return null;
    }

    public boolean schemasAvailable() {
        boolean available = this.schemaComboBox.isEnabled();
        return available;
    }

    public boolean setSchemas(List<String> items, String schema) {
        if (items == null) {
            items = Collections.emptyList();
        }
        this.schemaComboBox.removeAllItems();
        for (int i = 0; i < items.size(); ++i) {
            this.schemaComboBox.addItem(items.get(i));
        }
        if (items.isEmpty()) {
            this.schemaComboBox.addItem(NbBundle.getMessage(SchemaPanel.class, (String)"TXT_NoSchema"));
            this.schemaComboBox.setEnabled(false);
        } else {
            this.schemaComboBox.setEnabled(true);
        }
        if (items.size() == 1) {
            return true;
        }
        int idx = items.indexOf(schema);
        if (idx == -1) {
            idx = items.indexOf(schema.toLowerCase());
        }
        if (idx == -1) {
            idx = items.indexOf(schema.toUpperCase());
        }
        if (idx != -1) {
            this.schemaComboBox.setSelectedIndex(idx);
            return true;
        }
        return false;
    }

    public void setComment(String msg) {
        this.commentTextArea.setText(msg);
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SchemaPanel.this.progressHandle = ProgressHandleFactory.createHandle(null);
                SchemaPanel.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)SchemaPanel.this.progressHandle);
                SchemaPanel.this.progressContainerPanel.add((Component)SchemaPanel.this.progressComponent, "Center");
                SchemaPanel.this.progressHandle.start();
                SchemaPanel.this.progressMessageLabel.setText(NbBundle.getMessage(SchemaPanel.class, (String)"ConnectionProgress_Connecting"));
            }
        });
    }

    private void setProgressMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SchemaPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.progressMessageLabel.setText(message);
            }
        });
    }

    public void terminateProgress() {
        this.stopProgress(false);
    }

    private void stopProgress(final boolean connected) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SchemaPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.progressHandle != null) {
                    this.this$0.progressHandle.finish();
                    this.this$0.progressContainerPanel.remove(this.this$0.progressComponent);
                    this.this$0.progressContainerPanel.repaint();
                    if (connected) {
                        this.this$0.progressMessageLabel.setText(NbBundle.getMessage(SchemaPanel.class, (String)"ConnectionProgress_Established"));
                    } else {
                        this.this$0.progressMessageLabel.setText(NbBundle.getMessage(SchemaPanel.class, (String)"ConnectionProgress_Failed"));
                    }
                }
            }
        });
    }

    public void resetProgress() {
        this.progressMessageLabel.setText(" ");
    }
}

