/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lsp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lsp.Range;
import org.netbeans.api.lsp.StructureElement;

public final class CallHierarchyEntry {
    private StructureElement element;
    private String customData;

    @NonNull
    public StructureElement getElement() {
        return this.element;
    }

    @CheckForNull
    public String getCustomData() {
        return this.customData;
    }

    public CallHierarchyEntry(StructureElement element, String customData) {
        this.element = element;
        this.customData = customData;
    }

    public static final class Call {
        private final CallHierarchyEntry item;
        private final List<Range> ranges;

        public Call(@NonNull CallHierarchyEntry item, List<Range> ranges) {
            this.item = item;
            this.ranges = ranges.size() > 1 ? Collections.unmodifiableList(new ArrayList<Range>(ranges)) : (ranges.isEmpty() ? Collections.emptyList() : Collections.singletonList(ranges.get(0)));
        }

        @NonNull
        public CallHierarchyEntry getItem() {
            return this.item;
        }

        public List<Range> getRanges() {
            return this.ranges;
        }
    }
}

