/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.attach;

import java.awt.Component;
import java.awt.Font;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.attach.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DAPAttachPanel
extends JPanel {
    private static final Map<DAPDebugger.Type, String> connectionType2DisplayName = Map.of(DAPDebugger.Type.ATTACH, Bundle.DN_Attach(), DAPDebugger.Type.LAUNCH, Bundle.DN_Launch());
    private static final String NODE = "attach";
    private static final String KEY_HOSTNAME = "hostname";
    private static final String KEY_PORT = "port";
    private static final String KEY_CONNECTION_TYPE = "type";
    private static final String KEY_CONFIGURATION = "configuration";
    private static final String KEY_DELAY = "delay";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_PORT = "";
    private static final String DEFAULT_CONNECTION_TYPE = "ATTACH";
    private static final String DEFAULT_CONFIGURATION = "";
    private static final boolean DEFAULT_DELAY = false;
    private JComboBox<DAPDebugger.Type> connectionType;
    private JCheckBox delay;
    private JTextField hostname;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JEditorPane jsonConfiguration;
    private JTextField port;

    public DAPAttachPanel() {
        this.initComponents();
    }

    public void load(Properties prefs) {
        this.hostname.setText(prefs.getString(KEY_HOSTNAME, DEFAULT_HOSTNAME));
        this.port.setText(prefs.getString(KEY_PORT, ""));
        try {
            this.connectionType.setSelectedItem((Object)DAPDebugger.Type.valueOf(prefs.getString(KEY_CONNECTION_TYPE, DEFAULT_CONNECTION_TYPE)));
        }
        catch (IllegalArgumentException ex) {
            this.connectionType.setSelectedItem((Object)DAPDebugger.Type.ATTACH);
        }
        this.jsonConfiguration.setText(prefs.getString(KEY_CONFIGURATION, ""));
        this.delay.setSelected(prefs.getBoolean(KEY_DELAY, false));
    }

    public void save(Properties prefs) {
        prefs.setString(KEY_HOSTNAME, this.getHostName());
        prefs.setString(KEY_PORT, this.port.getText());
        prefs.setString(KEY_CONNECTION_TYPE, this.getConnectionType().name());
        prefs.setString(KEY_CONFIGURATION, this.getJSONConfiguration());
        prefs.setBoolean(KEY_DELAY, this.getDelay());
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jsonConfiguration = new JEditorPane();
        this.delay = new JCheckBox();
        this.hostname = new JTextField();
        this.port = new JTextField();
        this.connectionType = new JComboBox();
        this.jLabel6 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DAPAttachPanel.class, (String)"DAPAttachPanel.jLabel4.text"));
        this.jLabel1.setLabelFor(this.hostname);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DAPAttachPanel.class, (String)"DAPAttachPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.port);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DAPAttachPanel.class, (String)"DAPAttachPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DAPAttachPanel.class, (String)"DAPAttachPanel.jLabel3.text"));
        this.jLabel5.setLabelFor(this.jsonConfiguration);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DAPAttachPanel.class, (String)"DAPAttachPanel.jLabel5.text"));
        this.jsonConfiguration.setContentType("application/json");
        this.jScrollPane1.setViewportView(this.jsonConfiguration);
        Mnemonics.setLocalizedText((AbstractButton)this.delay, (String)NbBundle.getMessage(DAPAttachPanel.class, (String)"DAPAttachPanel.delay.text"));
        this.hostname.setText(NbBundle.getMessage(DAPAttachPanel.class, (String)"DAPAttachPanel.hostname.text"));
        this.port.setText(NbBundle.getMessage(DAPAttachPanel.class, (String)"DAPAttachPanel.port.text"));
        this.connectionType.setModel(this.getConnectionTypeModel());
        this.connectionType.setRenderer(this.getConnectionTypeRenderer());
        this.jLabel6.setFont(new Font("sansserif", 2, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(DAPAttachPanel.class, (String)"DAPAttachPanel.jLabel6.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostname).addComponent(this.port).addComponent(this.connectionType, 0, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.delay).addComponent(this.jLabel6)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.hostname, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.port, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.connectionType, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 95, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.delay).addGap(10, 10, 10)));
    }

    private ComboBoxModel<DAPDebugger.Type> getConnectionTypeModel() {
        DefaultComboBoxModel<DAPDebugger.Type> result = new DefaultComboBoxModel<DAPDebugger.Type>();
        result.addElement(DAPDebugger.Type.ATTACH);
        result.addElement(DAPDebugger.Type.LAUNCH);
        return result;
    }

    private ListCellRenderer<? super DAPDebugger.Type> getConnectionTypeRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof DAPDebugger.Type) {
                    DAPDebugger.Type type = (DAPDebugger.Type)((Object)value);
                    value = connectionType2DisplayName.get((Object)type);
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        };
    }

    public String getHostName() {
        return this.hostname.getText();
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.port.getText());
        }
        catch (NumberFormatException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return -1;
        }
    }

    public DAPDebugger.Type getConnectionType() {
        return (DAPDebugger.Type)((Object)this.connectionType.getSelectedItem());
    }

    public String getJSONConfiguration() {
        return this.jsonConfiguration.getText();
    }

    public boolean getDelay() {
        return this.delay.isSelected();
    }
}

