/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.AgentIdentityRepository;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.netbeans.libs.jsch.agentproxy.ConnectorFactory;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.PasswordPanel;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.sftp.Bundle;
import org.netbeans.modules.php.project.connections.sftp.MessagePanel;
import org.netbeans.modules.php.project.connections.sftp.SftpConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class SftpClient
implements RemoteClient {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SftpClient.class.getName());
    private static final boolean NO_PROXY_PROPERTY = Boolean.getBoolean("nb.php.sftp.noProxy");
    private static final Map<Integer, String> PASSWORDS = new HashMap<Integer, String>();
    private static final Map<Integer, String> PASSPHRASES = new HashMap<Integer, String>();
    private static final Map<Integer, Set<String>> MESSAGES = new HashMap<Integer, Set<String>>();
    private static final SftpLogger DEV_NULL_LOGGER = new DevNullLogger();
    private final SftpConfiguration configuration;
    private final SftpLogger sftpLogger;
    private Session sftpSession;
    private ChannelSftp sftpClient;

    public SftpClient(SftpConfiguration configuration, InputOutput io) {
        assert (configuration != null);
        this.configuration = configuration;
        this.sftpLogger = new SftpLogger(io);
    }

    private void init() throws RemoteException {
        block10: {
            assert (Thread.holdsLock(this));
            if (this.sftpClient != null && this.sftpClient.isConnected()) {
                LOGGER.log(Level.FINE, "SFTP client already created and connected");
                return;
            }
            LOGGER.log(Level.FINE, "SFTP client creating");
            JSch.setLogger((Logger)this.sftpLogger);
            String knownHostsFile = this.configuration.getKnownHostsFile();
            String identityFile = this.configuration.getIdentityFile();
            JSch jsch = new JSch();
            if (StringUtils.hasText((String)knownHostsFile)) {
                try {
                    jsch.setKnownHosts(knownHostsFile);
                }
                catch (JSchException ex) {
                    LOGGER.log(Level.INFO, "Error in JSCH library", ex);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.SftpConfiguration_bug_knownHosts(), 0));
                }
            }
            boolean agentUsed = false;
            try {
                LOGGER.fine("Trying to set ssh-agent");
                agentUsed = this.setAgent(jsch, identityFile, true);
                LOGGER.fine("Trying to create session");
                this.sftpSession = this.createSftpSession(jsch, !agentUsed);
                try {
                    LOGGER.log(Level.FINE, "Trying to connect with agent used: {0}", agentUsed);
                    this.sftpClient = this.connectSftpClient();
                }
                catch (Exception exc) {
                    if (agentUsed) {
                        LOGGER.log(exc instanceof JSchException ? Level.FINE : Level.INFO, null, exc);
                        LOGGER.fine("Trying to create another session");
                        this.sftpSession = this.createSftpSession(jsch, true);
                        this.setAgent(jsch, identityFile, false);
                        LOGGER.fine("Trying to connect with agent used: false");
                        this.sftpClient = this.connectSftpClient();
                        break block10;
                    }
                    throw exc;
                }
            }
            catch (JSchException exc) {
                PASSWORDS.remove(this.configuration.hashCode());
                PASSPHRASES.remove(this.configuration.hashCode());
                MESSAGES.remove(this.configuration.hashCode());
                this.disconnect(true);
                LOGGER.log(Level.FINE, "Exception while connecting", exc);
                throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotConnect", (Object)this.configuration.getHost()), exc);
            }
        }
    }

    private Session createSftpSession(JSch jsch, boolean withUserInfo) throws JSchException {
        LOGGER.fine("Creating new SFTP session...");
        String host = this.configuration.getHost();
        int port = this.configuration.getPort();
        int timeout = this.configuration.getTimeout() * 1000;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Will connect to {0} [timeout: {1} ms]", new Object[]{host, timeout});
        }
        int keepAliveInterval = this.configuration.getKeepAliveInterval() * 1000;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Keep-alive interval is {0} ms", keepAliveInterval);
        }
        String username = this.configuration.getUserName();
        String password = this.configuration.getPassword();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Login as {0}", username);
        }
        Session session = jsch.getSession(username, host, port);
        if (StringUtils.hasText((String)password)) {
            session.setPassword(password);
        }
        this.setProxy(session, host);
        if (withUserInfo) {
            LOGGER.fine("Setting user info...");
            session.setUserInfo((UserInfo)new SftpUserInfo(this.configuration));
        }
        session.setTimeout(timeout);
        if (keepAliveInterval > 0) {
            session.setServerAliveInterval(keepAliveInterval);
        }
        return session;
    }

    private boolean setAgent(JSch jsch, String identityFile, boolean preferAgent) throws JSchException {
        AgentIdentityRepository irepo;
        AgentConnector agentConnector;
        boolean agentUsed = false;
        if (preferAgent && (agentConnector = ConnectorFactory.getInstance().createConnector(ConnectorFactory.ConnectorKind.ANY)) != null && (irepo = new AgentIdentityRepository(agentConnector)).getStatus() == 2) {
            jsch.setIdentityRepository((IdentityRepository)irepo);
            agentUsed = true;
        }
        if (!agentUsed) {
            jsch.setIdentityRepository(null);
            jsch.removeAllIdentity();
            if (StringUtils.hasText((String)identityFile)) {
                jsch.addIdentity(identityFile);
            }
        }
        return agentUsed;
    }

    private void setProxy(Session session, String host) {
        assert (Thread.holdsLock(this));
        if (NO_PROXY_PROPERTY) {
            LOGGER.log(Level.FINE, "No proxy will be used (disabled via system property)");
            return;
        }
        ProxySOCKS5 proxy = null;
        RemoteUtils.ProxyInfo proxyInfo = RemoteUtils.getSocksProxy(host);
        if (proxyInfo != null) {
            LOGGER.log(Level.FINE, "SOCKS proxy will be used");
            ProxySOCKS5 socksProxy = new ProxySOCKS5(proxyInfo.getHost(), proxyInfo.getPort());
            if (StringUtils.hasText((String)proxyInfo.getUsername())) {
                socksProxy.setUserPasswd(proxyInfo.getUsername(), proxyInfo.getPassword());
            }
            proxy = socksProxy;
        } else {
            proxyInfo = RemoteUtils.getHttpProxy(host);
            if (proxyInfo != null) {
                LOGGER.log(Level.FINE, "HTTP proxy will be used");
                ProxyHTTP httpProxy = new ProxyHTTP(proxyInfo.getHost(), proxyInfo.getPort());
                if (StringUtils.hasText((String)proxyInfo.getUsername())) {
                    httpProxy.setUserPasswd(proxyInfo.getUsername(), proxyInfo.getPassword());
                }
                proxy = httpProxy;
            }
        }
        if (proxy != null) {
            session.setProxy(proxy);
        }
    }

    private ChannelSftp connectSftpClient() throws JSchException {
        assert (Thread.holdsLock(this));
        assert (this.sftpSession != null);
        this.sftpSession.connect();
        Channel channel = this.sftpSession.openChannel("sftp");
        channel.connect();
        return (ChannelSftp)channel;
    }

    @Override
    public synchronized void connect() throws RemoteException {
        this.init();
        assert (this.sftpClient.isConnected());
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Remote server version is {0}", this.sftpClient.getServerVersion());
            }
        }
        catch (SftpException exc) {
            LOGGER.log(Level.FINE, "Exception while getting server version", exc);
        }
    }

    @Override
    public synchronized void disconnect(boolean force) throws RemoteException {
        if (this.sftpSession == null) {
            LOGGER.log(Level.FINE, "Remote client not created yet => nothing to do");
            return;
        }
        if (!force && this.sftpSession.getServerAliveInterval() > 0) {
            LOGGER.log(Level.FINE, "Keep-alive running and disconnecting not forced -> do nothing");
            return;
        }
        LOGGER.log(Level.FINE, "Remote client trying to disconnect");
        if (this.sftpSession.isConnected()) {
            LOGGER.log(Level.FINE, "Remote client connected -> disconnecting");
            JSch.setLogger((Logger)DEV_NULL_LOGGER);
            this.sftpSession.disconnect();
            LOGGER.log(Level.FINE, "Remote client disconnected");
        }
        this.sftpClient = null;
        this.sftpSession = null;
        this.sftpLogger.info("QUIT");
        this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_Goodbye"));
    }

    @Override
    public String getReplyString() {
        return null;
    }

    @Override
    public String getNegativeReplyString() {
        return null;
    }

    @Override
    public synchronized boolean isConnected() {
        if (this.sftpClient == null) {
            return false;
        }
        return this.sftpClient.isConnected();
    }

    @Override
    public synchronized String printWorkingDirectory() throws RemoteException {
        try {
            this.sftpLogger.info("PWD");
            String pwd = this.sftpClient.pwd();
            this.sftpLogger.info(pwd);
            return pwd;
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while pwd", ex);
            this.sftpLogger.error(ex.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotPwd", (Object)this.configuration.getHost()), ex);
        }
    }

    @Override
    public synchronized boolean storeFile(String remote, InputStream local) throws RemoteException {
        try {
            this.sftpLogger.info("STOR " + remote);
            this.sftpClient.put(local, remote);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_FileReceiveOk"));
            return true;
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while storing file " + remote, ex);
            this.sftpLogger.error(ex.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotStoreFile", (Object)remote), ex);
        }
    }

    @Override
    public boolean deleteFile(String pathname) throws RemoteException {
        return this.delete(pathname, false);
    }

    @Override
    public boolean deleteDirectory(String pathname) throws RemoteException {
        return this.delete(pathname, true);
    }

    private synchronized boolean delete(String pathname, boolean directory) throws RemoteException {
        try {
            this.sftpLogger.info("DELE " + pathname);
            if (directory) {
                this.sftpClient.rmdir(pathname);
            } else {
                this.sftpClient.rm(pathname);
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_FileDeleteOk"));
            return true;
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while deleting file " + pathname, ex);
            this.sftpLogger.error(ex.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public synchronized boolean rename(String from, String to) throws RemoteException {
        try {
            this.sftpLogger.info("RNFR " + from);
            this.sftpLogger.info("RNTO " + to);
            this.sftpClient.rename(from, to);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_RenameSuccessful"));
            return true;
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, String.format("Error while renaming file %s -> %s", from, to), ex);
            this.sftpLogger.error(ex.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public synchronized List<RemoteFile> listFiles() throws RemoteException {
        ArrayList<RemoteFile> result = null;
        String pwd = null;
        try {
            pwd = this.sftpClient.pwd();
            this.sftpLogger.info("LIST");
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirListing"));
            Vector files = this.sftpClient.ls(pwd);
            result = new ArrayList<RemoteFile>(files.size());
            for (ChannelSftp.LsEntry entry : files) {
                result.add(new RemoteFileImpl(entry, pwd));
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirectorySendOk"));
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while listing files for " + pwd, ex);
            this.sftpLogger.error(ex.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotListFiles", (Object)pwd), ex);
        }
        return result;
    }

    @Override
    public synchronized RemoteFile listFile(String absolutePath) throws RemoteException {
        assert (absolutePath.startsWith("/")) : "Not absolute path give but: " + absolutePath;
        RemoteFileImpl result = null;
        try {
            this.sftpLogger.info("LIST");
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirListing"));
            SftpATTRS attrs = this.sftpClient.stat(absolutePath);
            if (!attrs.isDir()) {
                Vector files = this.sftpClient.ls(absolutePath);
                if (files.size() == 1) {
                    for (ChannelSftp.LsEntry file : files) {
                        if (!file.getFilename().equals(RemoteUtils.getName(absolutePath))) continue;
                        String parentPath = RemoteUtils.getParentPath(absolutePath);
                        assert (parentPath != null) : "Parent path should exist for " + absolutePath;
                        result = new RemoteFileImpl(file, parentPath);
                    }
                } else assert (false) : "Only one file should be found and not " + files.size();
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirectorySendOk"));
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while listing file for " + absolutePath, ex);
            this.sftpLogger.error(ex.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotListFile", (Object)absolutePath), ex);
        }
        return result;
    }

    @Override
    public synchronized boolean retrieveFile(String remote, OutputStream local) throws RemoteException {
        try {
            this.sftpLogger.info("RETR " + remote);
            this.sftpClient.get(remote, local);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_FileSendOk"));
            return true;
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while retrieving file " + remote, ex);
            this.sftpLogger.error(ex.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotStoreFile", (Object)remote), ex);
        }
    }

    @Override
    public synchronized boolean changeWorkingDirectory(String pathname) throws RemoteException {
        try {
            this.sftpLogger.info("CWD " + pathname);
            this.sftpClient.cd(pathname);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_CdOk"));
            return true;
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while changing directory " + pathname, ex);
            this.sftpLogger.error(NbBundle.getMessage(SftpClient.class, (String)"LOG_CdKo"));
            return false;
        }
    }

    @Override
    public synchronized boolean makeDirectory(String pathname) throws RemoteException {
        try {
            this.sftpLogger.info("MKD " + pathname);
            this.sftpClient.mkdir(pathname);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_MkDirOk", (Object)pathname));
            return true;
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while creating directory " + pathname, ex);
            this.sftpLogger.error(ex.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public synchronized int getPermissions(String path) throws RemoteException {
        int permissions = -1;
        try {
            this.sftpLogger.info("LIST " + path);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirListing"));
            ChannelSftp.LsEntry file = this.getFile(path);
            if (file != null) {
                permissions = file.getAttrs().getPermissions();
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirectorySendOk"));
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while getting permissions for " + path, ex);
        }
        return permissions;
    }

    @Override
    public synchronized boolean setPermissions(int permissions, String path) throws RemoteException {
        try {
            this.sftpLogger.info(String.format("chmod %d %s", permissions, path));
            this.sftpClient.chmod(permissions, path);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_ChmodOk"));
            return true;
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while setting permissions for " + path, ex);
            this.sftpLogger.error(ex.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public synchronized boolean exists(String parent, String name) throws RemoteException {
        String fullPath = parent + "/" + name;
        try {
            this.sftpClient.ls(fullPath);
            return true;
        }
        catch (SftpException ex) {
            LOGGER.log(Level.FINE, "Error while checking existence of " + fullPath, ex);
            return false;
        }
    }

    private ChannelSftp.LsEntry getFile(String path) throws SftpException {
        assert (Thread.holdsLock(this));
        assert (path != null && path.trim().length() > 0);
        Vector files = this.sftpClient.ls(path);
        LOGGER.fine(String.format("Exactly 1 file should be found for %s; found %d", path, files.size()));
        if (files.size() > 0) {
            return (ChannelSftp.LsEntry)files.get(0);
        }
        return null;
    }

    static String getPasswordForUser(SftpConfiguration configuration) {
        PasswordPanel passwordPanel;
        String password = PASSWORDS.get(configuration.hashCode());
        if (password == null && (passwordPanel = PasswordPanel.forUser(configuration.getDisplayName(), configuration.getUserName())).open()) {
            password = passwordPanel.getPassword();
            PASSWORDS.put(configuration.hashCode(), password);
        }
        return password;
    }

    static String getPasswordForCertificate(SftpConfiguration configuration) {
        PasswordPanel passwordPanel;
        String password = PASSPHRASES.get(configuration.hashCode());
        if (password == null && (passwordPanel = PasswordPanel.forCertificate(configuration.getDisplayName())).open()) {
            password = passwordPanel.getPassword();
            PASSPHRASES.put(configuration.hashCode(), password);
        }
        return password;
    }

    static void showMessageForConfiguration(SftpConfiguration configuration, String message) {
        if (!StringUtils.hasText((String)message) || SftpClient.getMessages(configuration).contains(message)) {
            return;
        }
        MessagePanel messagePanel = new MessagePanel(message);
        DialogDescriptor descriptor = new DialogDescriptor((Object)messagePanel, configuration.getDisplayName(), true, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION && messagePanel.doNotShowThisMessageAgain()) {
            SftpClient.getMessages(configuration).add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getMessages(SftpConfiguration configuration) {
        Set<String> messages;
        Map<Integer, Set<String>> map = MESSAGES;
        synchronized (map) {
            messages = MESSAGES.get(configuration.hashCode());
            if (messages == null) {
                messages = new HashSet<String>();
                MESSAGES.put(configuration.hashCode(), messages);
            }
        }
        return messages;
    }

    private static class SftpLogger
    implements Logger {
        private final InputOutput io;

        public SftpLogger(InputOutput io) {
            this.io = io;
        }

        public boolean isEnabled(int level) {
            return true;
        }

        public void log(int level, String message) {
            if (this.io != null && level >= 1) {
                OutputWriter writer = level <= 1 ? this.io.getOut() : this.io.getErr();
                writer.println(message.trim());
                writer.flush();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Command listener: {0}", message.trim());
            }
        }

        public void info(String message) {
            this.log(1, message);
        }

        public void error(String message) {
            this.log(3, message);
        }
    }

    private static final class SftpUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SftpUserInfo.class.getName());
        private final SftpConfiguration configuration;
        private volatile String passwd;
        private volatile String passphrase;

        public SftpUserInfo(SftpConfiguration configuration) {
            assert (configuration != null);
            this.configuration = configuration;
        }

        public boolean promptYesNo(String message) {
            NotifyDescriptor descriptor = new NotifyDescriptor((Object)message, NbBundle.getMessage(SftpClient.class, (String)"LBL_Warning"), 0, 2, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION);
            return DialogDisplayer.getDefault().notify(descriptor) == NotifyDescriptor.YES_OPTION;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassphrase(String message) {
            this.passphrase = SftpClient.getPasswordForCertificate(this.configuration);
            return this.passphrase != null;
        }

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptPassword(String message) {
            this.passwd = SftpClient.getPasswordForUser(this.configuration);
            return this.passwd != null;
        }

        public void showMessage(String message) {
            SftpClient.showMessageForConfiguration(this.configuration, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("promptKeyboardInteractive called with these params:");
                LOGGER.log(Level.FINE, "destination: {0}", destination);
                LOGGER.log(Level.FINE, "name: {0}", name);
                LOGGER.log(Level.FINE, "instruction: {0}", instruction);
                LOGGER.log(Level.FINE, "prompt: {0}", Arrays.toString(prompt));
                LOGGER.log(Level.FINE, "echo: {0}", Arrays.toString(echo));
            }
            if (prompt.length == 1 && echo.length == 1 && !echo[0]) {
                this.passwd = this.configuration.getPassword();
                if (!StringUtils.hasText((String)this.passwd)) {
                    this.passwd = SftpClient.getPasswordForUser(this.configuration);
                }
                if (StringUtils.hasText((String)this.passwd)) {
                    return new String[]{this.passwd};
                }
            }
            return null;
        }
    }

    private static final class RemoteFileImpl
    implements RemoteFile {
        private final ChannelSftp.LsEntry entry;
        private final String parentDirectory;

        public RemoteFileImpl(ChannelSftp.LsEntry entry, String parentDirectory) {
            assert (entry != null);
            assert (parentDirectory != null);
            this.entry = entry;
            this.parentDirectory = parentDirectory;
        }

        @Override
        public String getName() {
            return this.entry.getFilename();
        }

        @Override
        public String getParentDirectory() {
            return this.parentDirectory;
        }

        @Override
        public boolean isDirectory() {
            return this.entry.getAttrs().isDir();
        }

        @Override
        public boolean isFile() {
            return !this.isDirectory();
        }

        @Override
        public boolean isLink() {
            return this.entry.getAttrs().isLink();
        }

        @Override
        public long getSize() {
            return this.entry.getAttrs().getSize();
        }

        @Override
        public long getTimestamp() {
            return this.entry.getAttrs().getMTime();
        }

        public String toString() {
            return "SftpFile[name: " + this.getName() + ", parent directory: " + this.getParentDirectory() + "]";
        }
    }

    private static final class DevNullLogger
    extends SftpLogger {
        public DevNullLogger() {
            super(null);
        }

        @Override
        public boolean isEnabled(int level) {
            return false;
        }

        @Override
        public void log(int level, String message) {
        }
    }
}

