/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.models.SessionsTableModelFilter;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class JPDASessionActionsProvider
implements NodeActionsProviderFilter {
    private HashSet listeners;

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        DebuggerEngine e;
        Action[] actions;
        if (!(node instanceof Session) || !SessionsTableModelFilter.isJPDASession((Session)node)) {
            return original.getActions(node);
        }
        Session session = (Session)node;
        try {
            actions = original.getActions(node);
        }
        catch (UnknownTypeException e2) {
            actions = new Action[]{};
        }
        ArrayList<Action> myActions = new ArrayList<Action>();
        if (actions.length > 0) {
            myActions.add(actions[0]);
        }
        if ((e = session.getCurrentEngine()) != null) {
            JPDADebugger d = (JPDADebugger)e.lookupFirst(null, JPDADebugger.class);
            myActions.add(new CustomizeSession(d));
        }
        myActions.add(new LanguageSelection(session));
        for (int i = 1; i < actions.length; ++i) {
            myActions.add(actions[i]);
        }
        return myActions.toArray(new Action[0]);
    }

    private String localize(String s) {
        s = NbBundle.getBundle(JPDASessionActionsProvider.class).getString(s);
        int ampIndex = Mnemonics.findMnemonicAmpersand((String)s);
        if (ampIndex >= 0) {
            s = s.substring(0, ampIndex) + s.substring(ampIndex + 1);
        }
        return s;
    }

    public void addModelListener(ModelListener l) {
        HashSet newListeners = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        newListeners.add(l);
        this.listeners = newListeners;
    }

    public void removeModelListener(ModelListener l) {
        if (this.listeners == null) {
            return;
        }
        HashSet newListeners = (HashSet)this.listeners.clone();
        newListeners.remove(l);
        this.listeners = newListeners;
    }

    private class CustomizeSession
    extends AbstractAction
    implements Presenter.Popup {
        private JPDADebugger dbg;

        public CustomizeSession(JPDADebugger dbg) {
            this.dbg = dbg;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu displayAsPopup = new JMenu(JPDASessionActionsProvider.this.localize("CTL_Session_Resume_Threads"));
            JRadioButtonMenuItem resumeAllItem = new JRadioButtonMenuItem(new AbstractAction(JPDASessionActionsProvider.this.localize("CTL_Session_Resume_All_Threads")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomizeSession.this.dbg.setSuspend(2);
                }
            });
            JRadioButtonMenuItem resumeCurrentItem = new JRadioButtonMenuItem(new AbstractAction(JPDASessionActionsProvider.this.localize("CTL_Session_Resume_Current_Thread")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomizeSession.this.dbg.setSuspend(1);
                }
            });
            if (this.dbg.getSuspend() == 2) {
                resumeAllItem.setSelected(true);
            } else {
                resumeCurrentItem.setSelected(true);
            }
            displayAsPopup.add(resumeAllItem);
            displayAsPopup.add(resumeCurrentItem);
            return displayAsPopup;
        }
    }

    private class LanguageSelection
    extends AbstractAction
    implements Presenter.Popup {
        private Session session;

        public LanguageSelection(Session session) {
            this.session = session;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu displayAsPopup = new JMenu(JPDASessionActionsProvider.this.localize("CTL_Session_Popup_Language"));
            String[] languages = this.session.getSupportedLanguages();
            String currentLanguage = this.session.getCurrentLanguage();
            for (int i = 0; i < languages.length; ++i) {
                final String language = languages[i];
                JRadioButtonMenuItem langItem = new JRadioButtonMenuItem(new AbstractAction(this, language){
                    final /* synthetic */ LanguageSelection this$1;
                    {
                        this.this$1 = this$1;
                        super(name);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.this$1.session.setCurrentLanguage(language);
                    }
                });
                if (currentLanguage.equals(language)) {
                    langItem.setSelected(true);
                }
                displayAsPopup.add(langItem);
            }
            return displayAsPopup;
        }
    }
}

