/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.io.IOProvider;
import org.netbeans.api.io.InputOutput;
import org.netbeans.api.io.OutputColor;
import org.netbeans.lib.v8debug.PropertyBoolean;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Breakpoint;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Event;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.commands.Backtrace;
import org.netbeans.lib.v8debug.commands.ClearBreakpoint;
import org.netbeans.lib.v8debug.commands.Frame;
import org.netbeans.lib.v8debug.commands.Scripts;
import org.netbeans.lib.v8debug.commands.SetBreakpoint;
import org.netbeans.lib.v8debug.connection.ClientConnection;
import org.netbeans.lib.v8debug.connection.IOListener;
import org.netbeans.lib.v8debug.events.AfterCompileEventBody;
import org.netbeans.lib.v8debug.events.BreakEventBody;
import org.netbeans.lib.v8debug.events.CompileErrorEventBody;
import org.netbeans.lib.v8debug.events.ExceptionEventBody;
import org.netbeans.lib.v8debug.events.ScriptCollectedEventBody;
import org.netbeans.modules.javascript.v8debug.Bundle;
import org.netbeans.modules.javascript.v8debug.ReferencedValues;
import org.netbeans.modules.javascript.v8debug.ScriptsHandler;
import org.netbeans.modules.javascript.v8debug.api.Connector;
import org.netbeans.modules.javascript.v8debug.breakpoints.BreakpointsHandler;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.frames.CallStack;
import org.netbeans.modules.javascript.v8debug.sources.ChangeLiveSupport;
import org.netbeans.modules.javascript.v8debug.vars.VarValuesLoader;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public final class V8Debugger {
    private static final Logger LOG = Logger.getLogger(V8Debugger.class.getName());
    private static final boolean SHOW_V8_PROTOCOL = Boolean.getBoolean("show.v8.protocol");
    private final String host;
    private final int port;
    private final ClientConnection connection;
    private final ScriptsHandler scriptsHandler;
    private final ChangeLiveSupport changeLiveSupport;
    private final BreakpointsHandler breakpointsHandler;
    @NullAllowed
    private final Runnable finishCallback;
    private DebuggerEngine engine;
    private DebuggerEngine.Destructor engineDestructor;
    private final RequestProcessor rp = new RequestProcessor(V8Debugger.class);
    private final Set<Listener> listeners = new CopyOnWriteArraySet<Listener>();
    private final AtomicLong requestSequence = new AtomicLong(1L);
    private final Map<Long, Pair<V8Request, CommandResponseCallback>> commandCallbacks = new HashMap<Long, Pair<V8Request, CommandResponseCallback>>();
    private boolean suspended = false;
    private final Object suspendedUpdateLock = new Object();
    private volatile boolean finished = false;
    private final ReentrantReadWriteLock accessLock = new ReentrantReadWriteLock(true);
    private CallFrame currentFrame;
    private CallStack currentCallStack;
    private final Object currentFrameRetrieveLock = new Object();
    private final Object currentCallStackRetrieveLock = new Object();
    private long runToBreakpointId = -1L;
    private CommandResponseCallback runToCallBack;
    private final ErrorMessageHandler errMsgHandler;

    public static DebuggerEngine startSession(Connector.Properties properties, @NullAllowed Runnable finishCallback) throws IOException {
        V8Debugger dbg = new V8Debugger(properties, finishCallback);
        VarValuesLoader vvl = new VarValuesLoader(dbg);
        DebuggerInfo dInfo = DebuggerInfo.create((String)"javascript-v8debuginfo", (Object[])new Object[]{dbg, vvl});
        DebuggerEngine[] engines = DebuggerManager.getDebuggerManager().startDebugging(dInfo);
        if (engines.length > 0) {
            dbg.setEngine(engines[0]);
            return engines[0];
        }
        if (finishCallback != null) {
            finishCallback.run();
        }
        return null;
    }

    private V8Debugger(Connector.Properties properties, Runnable finishCallback) throws IOException {
        this.host = properties.getHostName();
        this.port = properties.getPort();
        this.connection = new ClientConnection(properties.getHostName(), properties.getPort());
        if (SHOW_V8_PROTOCOL) {
            this.connection.addIOListener((IOListener)new CommListener());
        }
        this.scriptsHandler = new ScriptsHandler(properties.getLocalPaths(), properties.getServerPaths(), properties.getLocalPathExclusionFilters(), this);
        this.changeLiveSupport = new ChangeLiveSupport(this);
        this.breakpointsHandler = new BreakpointsHandler(this);
        this.finishCallback = finishCallback;
        this.errMsgHandler = (ErrorMessageHandler)Lookup.getDefault().lookup(ErrorMessageHandler.class);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void start() {
        this.spawnResponseLoop();
        this.initScripts();
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.notifyFinished();
        this.finishCallbacks();
        this.engineDestructor.killEngine();
        if (this.finishCallback != null) {
            this.finishCallback.run();
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ScriptsHandler getScriptsHandler() {
        return this.scriptsHandler;
    }

    public ChangeLiveSupport getChangeLiveSupport() {
        return this.changeLiveSupport;
    }

    public BreakpointsHandler getBreakpointsHandler() {
        return this.breakpointsHandler;
    }

    @CheckForNull
    public V8Request sendCommandRequest(V8Command cmd, V8Arguments args) {
        return this.sendCommandRequest(cmd, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    @CheckReturnValue
    public V8Request sendCommandRequest(V8Command cmd, V8Arguments args, CommandResponseCallback callback) {
        V8Request request = new V8Request(this.requestSequence.getAndIncrement(), cmd, args);
        if (callback != null) {
            Map<Long, Pair<V8Request, CommandResponseCallback>> map = this.commandCallbacks;
            synchronized (map) {
                this.commandCallbacks.put(request.getSequence(), (Pair<V8Request, CommandResponseCallback>)Pair.of((Object)request, (Object)callback));
            }
        }
        if (cmd.equals((Object)V8Command.Continue) || cmd.equals((Object)V8Command.Restartframe)) {
            this.notifySuspended(false);
        }
        try {
            this.connection.send(request);
            return request;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void suspend() {
        this.sendCommandRequest(V8Command.Suspend, null);
    }

    public void resume() {
        this.sendCommandRequest(V8Command.Continue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        assert (!this.accessLock.isWriteLockedByCurrentThread());
        Object object = this.suspendedUpdateLock;
        synchronized (object) {
            return this.suspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @CheckForNull
    public CallFrame getCurrentFrame() {
        ReentrantReadWriteLock.ReadLock rl = this.accessLock.readLock();
        rl.lock();
        try {
            CallFrame f = this.currentFrame;
            if (f == null && this.currentCallStack != null) {
                rl.unlock();
                rl = null;
                Object object = this.currentFrameRetrieveLock;
                // MONITORENTER : object
                f = this.currentCallStack.getTopFrame();
                if (f != null) {
                    ReentrantReadWriteLock.WriteLock wl = this.accessLock.writeLock();
                    wl.lock();
                    try {
                        this.currentFrame = f;
                    }
                    finally {
                        wl.unlock();
                    }
                }
                // MONITOREXIT : object
                if (f != null) {
                    this.fireCurrentFrame(f);
                    object = f;
                    return object;
                }
            }
            if (f != null) return f;
            if (!this.isSuspended()) return f;
            final CallFrame[] fRef = new CallFrame[]{null};
            if (rl != null) {
                rl.unlock();
                rl = null;
            }
            Object object = this.currentFrameRetrieveLock;
            // MONITORENTER : object
            rl = this.accessLock.readLock();
            rl.lock();
            try {
                if (this.currentFrame != null || !this.isSuspended()) {
                    CallFrame callFrame = this.currentFrame;
                    return callFrame;
                }
            }
            finally {
                rl.unlock();
                rl = null;
            }
            V8Request request = this.sendCommandRequest(V8Command.Frame, null, new CommandResponseCallback(){
                final /* synthetic */ V8Debugger this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void notifyResponse(V8Request request, V8Response response) {
                    if (response != null && response.isSuccess()) {
                        Frame.ResponseBody frb = (Frame.ResponseBody)response.getBody();
                        fRef[0] = new CallFrame(this.this$0, frb.getFrame(), new ReferencedValues(response), true);
                    }
                    Object object = this.this$0.currentFrameRetrieveLock;
                    synchronized (object) {
                        this.this$0.currentFrameRetrieveLock.notifyAll();
                    }
                }
            });
            if (request != null) {
                try {
                    this.currentFrameRetrieveLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            f = fRef[0];
            ReentrantReadWriteLock.WriteLock wl = this.accessLock.writeLock();
            wl.lock();
            try {
                this.currentFrame = f;
            }
            finally {
                wl.unlock();
            }
            // MONITOREXIT : object
            this.fireCurrentFrame(f);
            return f;
        }
        finally {
            if (rl != null) {
                rl.unlock();
            }
        }
    }

    public void setCurrentFrame(@NonNull CallFrame callFrame) {
        assert (callFrame != null) : "Only existing frames can be set";
        ReentrantReadWriteLock.WriteLock wl = this.accessLock.writeLock();
        wl.lock();
        try {
            this.currentFrame = callFrame;
        }
        finally {
            wl.unlock();
        }
        this.fireCurrentFrame(callFrame);
    }

    private void fireCurrentFrame(CallFrame cf) {
        for (Listener l : this.listeners) {
            l.notifyCurrentFrame(cf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CallStack getCurrentCallStack() {
        ReentrantReadWriteLock.ReadLock rl = this.accessLock.readLock();
        rl.lock();
        try {
            CallStack cs = this.currentCallStack;
            if (cs != null) return cs;
            if (!this.isSuspended()) return cs;
            final CallStack[] csRef = new CallStack[]{null};
            rl.unlock();
            rl = null;
            Object object = this.currentCallStackRetrieveLock;
            synchronized (object) {
                Object csRetrievingLock;
                rl = this.accessLock.readLock();
                rl.lock();
                try {
                    if (this.currentCallStack != null && this.suspended) {
                        CallStack callStack = this.currentCallStack;
                        return callStack;
                    }
                }
                finally {
                    rl.unlock();
                    rl = null;
                }
                Backtrace.Arguments bta = new Backtrace.Arguments(Long.valueOf(0L), Long.valueOf(1L), Boolean.valueOf(false), Boolean.valueOf(true));
                Object object2 = csRetrievingLock = new Object();
                synchronized (object2) {
                    V8Request request = this.sendCommandRequest(V8Command.Backtrace, (V8Arguments)bta, new CommandResponseCallback(){
                        final /* synthetic */ V8Debugger this$0;
                        {
                            this.this$0 = this$0;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void notifyResponse(V8Request request, V8Response response) {
                            Object object;
                            if (response == null) {
                                Object object2 = csRetrievingLock;
                                synchronized (object2) {
                                    csRetrievingLock.notifyAll();
                                }
                                return;
                            }
                            Backtrace.ResponseBody btrb = (Backtrace.ResponseBody)response.getBody();
                            long numFrames = btrb.getTotalFrames();
                            if (numFrames == 0L) {
                                object = csRetrievingLock;
                                synchronized (object) {
                                    csRef[0] = CallStack.EMPTY;
                                    csRetrievingLock.notifyAll();
                                }
                            }
                            if (numFrames == 1L) {
                                object = csRetrievingLock;
                                synchronized (object) {
                                    csRef[0] = new CallStack(this.this$0, btrb.getFrames(), response.getReferencedValues());
                                    csRetrievingLock.notifyAll();
                                }
                            }
                            Backtrace.Arguments bta = new Backtrace.Arguments(Long.valueOf(0L), Long.valueOf(numFrames), Boolean.valueOf(false), Boolean.valueOf(true));
                            V8Request request2 = this.this$0.sendCommandRequest(V8Command.Backtrace, (V8Arguments)bta, new CommandResponseCallback(){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void notifyResponse(V8Request request, V8Response response) {
                                    if (response != null) {
                                        Backtrace.ResponseBody btrb = (Backtrace.ResponseBody)response.getBody();
                                        csRef[0] = new CallStack(this.this$1.this$0, btrb.getFrames(), response.getReferencedValues());
                                    }
                                    Object object = csRetrievingLock;
                                    synchronized (object) {
                                        csRetrievingLock.notifyAll();
                                    }
                                }
                            });
                            if (request2 == null) {
                                Object object3 = csRetrievingLock;
                                synchronized (object3) {
                                    csRetrievingLock.notifyAll();
                                }
                            }
                        }
                    });
                    if (request != null) {
                        try {
                            csRetrievingLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                cs = csRef[0];
                ReentrantReadWriteLock.WriteLock wl = this.accessLock.writeLock();
                wl.lock();
                try {
                    this.currentCallStack = cs;
                }
                finally {
                    wl.unlock();
                }
                return cs;
            }
        }
        finally {
            if (rl != null) {
                rl.unlock();
            }
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void spawnResponseLoop() {
        new RequestProcessor("V8Debugger Response Loop").post(new Runnable(){

            @Override
            public void run() {
                V8Debugger.this.responseLoop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void responseLoop() {
        this.connection.runEventLoop(new ClientConnection.Listener(){

            public void header(Map<String, String> properties) {
                for (Map.Entry<String, String> pe : properties.entrySet()) {
                    LOG.fine("  " + pe.getKey() + " = " + pe.getValue());
                }
            }

            public void response(V8Response response) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("response: " + response + ", success = " + response.isSuccess() + ", running = " + response.isRunning() + ", body = " + response.getBody());
                }
                V8Debugger.this.handleResponse(response);
            }

            public void event(V8Event event) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("event: " + event + ", name = " + event.getKind());
                }
                V8Debugger.this.handleEvent(event);
            }
        });
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.finish();
        }
        catch (IOException ioex) {
            block17: {
                try {
                    LOG.log(Level.FINE, null, ioex);
                    Throwable cause = ioex.getCause();
                    if (cause == null) break block17;
                    Exceptions.printStackTrace((Throwable)cause);
                }
                catch (Throwable throwable) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        this.finish();
                    }
                    throw throwable;
                }
            }
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponse(V8Response response) {
        long requestSequenceNum = response.getRequestSequence();
        Map<Long, Pair<V8Request, CommandResponseCallback>> map = this.commandCallbacks;
        synchronized (map) {
            Pair<V8Request, CommandResponseCallback> callback;
            Map<Long, Pair<V8Request, CommandResponseCallback>> map2 = this.commandCallbacks;
            synchronized (map2) {
                callback = this.commandCallbacks.remove(requestSequenceNum);
            }
            if (callback != null) {
                ((CommandResponseCallback)callback.second()).notifyResponse((V8Request)callback.first(), response);
            }
        }
        String errorMessage = response.getErrorMessage();
        if (errorMessage != null) {
            if (this.errMsgHandler != null) {
                this.errMsgHandler.errorResponse(errorMessage);
            }
            return;
        }
        if (!response.isSuccess()) {
            return;
        }
        this.notifySuspended(!response.isRunning());
        switch (response.getCommand()) {
            // Empty switch
        }
    }

    private void handleEvent(V8Event event) {
        PropertyBoolean running = event.isRunning();
        V8Event.Kind eventKind = event.getKind();
        if (running.hasValue()) {
            this.notifySuspended(!event.isRunning().getValue());
        } else if (eventKind == V8Event.Kind.Break || eventKind == V8Event.Kind.Exception) {
            this.notifySuspended(true);
        }
        PropertyBoolean success = event.getSuccess();
        if (success.hasValue() && !success.getValue() && event.getErrorMessage() != null) {
            if (this.errMsgHandler != null) {
                this.errMsgHandler.errorEvent(event.getErrorMessage());
            }
            return;
        }
        switch (eventKind) {
            case AfterCompile: {
                AfterCompileEventBody aceb = (AfterCompileEventBody)event.getBody();
                V8Script script = aceb.getScript();
                this.scriptsHandler.add(script);
                break;
            }
            case CompileError: {
                CompileErrorEventBody ceeb = (CompileErrorEventBody)event.getBody();
                V8Script script = ceeb.getScript();
                this.scriptsHandler.add(script);
                break;
            }
            case ScriptCollected: {
                ScriptCollectedEventBody sceb = (ScriptCollectedEventBody)event.getBody();
                long scriptId = sceb.getScriptId();
                this.scriptsHandler.remove(scriptId);
                break;
            }
            case Break: {
                BreakEventBody beb = (BreakEventBody)event.getBody();
                long[] breakpoints = beb.getBreakpoints();
                if (breakpoints == null || breakpoints.length <= 0) break;
                if (this.runToBreakpointId > 0L) {
                    for (long b : breakpoints) {
                        if (b != this.runToBreakpointId) continue;
                        this.clearRunTo();
                        if (breakpoints.length != 1) continue;
                        return;
                    }
                }
                this.breakpointsHandler.event(beb);
                break;
            }
            case Exception: {
                ExceptionEventBody eeb = (ExceptionEventBody)event.getBody();
                break;
            }
            default: {
                LOG.info("Unknown event: " + event.getKind());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuspended(boolean suspended) {
        assert (!this.accessLock.isWriteLockedByCurrentThread());
        LOG.fine("notifySuspended(" + suspended + ")");
        boolean fireNullCF = false;
        Iterator<Listener> iterator = this.suspendedUpdateLock;
        synchronized (iterator) {
            if (this.suspended == suspended) {
                return;
            }
            ReentrantReadWriteLock.WriteLock wl = this.accessLock.writeLock();
            wl.lock();
            try {
                if (!suspended) {
                    fireNullCF = this.currentFrame != null;
                    this.currentFrame = null;
                    this.currentCallStack = null;
                }
                this.suspended = suspended;
                LOG.fine("notifySuspended():  suspended property is set to " + suspended);
            }
            finally {
                wl.unlock();
            }
        }
        if (fireNullCF) {
            for (Listener l : this.listeners) {
                l.notifyCurrentFrame(null);
            }
        }
        for (Listener l : this.listeners) {
            l.notifySuspended(suspended);
        }
    }

    private void notifyFinished() {
        for (Listener l : this.listeners) {
            l.notifyFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCallbacks() {
        ArrayList<Pair<V8Request, CommandResponseCallback>> callBacks = new ArrayList<Pair<V8Request, CommandResponseCallback>>();
        Map<Long, Pair<V8Request, CommandResponseCallback>> map = this.commandCallbacks;
        synchronized (map) {
            callBacks.addAll(this.commandCallbacks.values());
        }
        for (Pair pair : callBacks) {
            ((CommandResponseCallback)pair.second()).notifyResponse((V8Request)pair.first(), null);
        }
    }

    private void setEngine(DebuggerEngine debuggerEngine) {
        this.engine = debuggerEngine;
    }

    void setEngineDestructor(DebuggerEngine.Destructor destructor) {
        this.engineDestructor = destructor;
    }

    private void initScripts() {
        Scripts.Arguments sa = new Scripts.Arguments(null, null, Boolean.valueOf(false), null);
        this.sendCommandRequest(V8Command.Scripts, (V8Arguments)sa, new CommandResponseCallback(){

            @Override
            public void notifyResponse(V8Request request, V8Response response) {
                if (response != null) {
                    Scripts.ResponseBody srb = (Scripts.ResponseBody)response.getBody();
                    V8Script[] scripts = srb.getScripts();
                    V8Debugger.this.scriptsHandler.add(scripts);
                }
            }
        });
    }

    private void clearRunTo() {
        if (this.runToBreakpointId > 0L) {
            ClearBreakpoint.Arguments cbargs = new ClearBreakpoint.Arguments(this.runToBreakpointId);
            V8Request request = this.sendCommandRequest(V8Command.Clearbreakpoint, (V8Arguments)cbargs);
            this.runToBreakpointId = -1L;
        }
    }

    public void runTo(FileObject fo, long line) {
        this.clearRunTo();
        if (fo == null) {
            return;
        }
        String serverPath = this.scriptsHandler.getServerPath(fo);
        if (serverPath == null) {
            return;
        }
        SetBreakpoint.Arguments args = new SetBreakpoint.Arguments(V8Breakpoint.Type.scriptName, serverPath, Long.valueOf(line), null, Boolean.valueOf(true), null, null, null);
        if (this.runToCallBack == null) {
            this.runToCallBack = new RunToResponseCallback();
        }
        V8Request request = this.sendCommandRequest(V8Command.Setbreakpoint, (V8Arguments)args, this.runToCallBack);
    }

    private final class CommListener
    implements IOListener {
        private final OutputColor sentColor = OutputColor.rgb((int)0, (int)178, (int)0);
        private final OutputColor receivedColor = OutputColor.rgb((int)0, (int)0, (int)255);
        private final InputOutput ioLogger = IOProvider.getDefault().getIO(Bundle.V8DebugProtocolPane(), false);
        private final long startTime = System.currentTimeMillis();

        private CommListener() {
        }

        public synchronized void sent(String str) {
            long time = System.currentTimeMillis() - this.startTime;
            this.ioLogger.getOut().append((CharSequence)("Sent at " + (double)time / 1000.0 + ":"));
            this.ioLogger.getOut().print(str, this.sentColor);
            this.ioLogger.getOut().println();
        }

        public synchronized void received(String str) {
            long time = System.currentTimeMillis() - this.startTime;
            this.ioLogger.getOut().append((CharSequence)("Got at " + (double)time / 1000.0 + ":"));
            this.ioLogger.getOut().print(str, this.receivedColor);
            this.ioLogger.getOut().println();
        }

        public void closed() {
            this.ioLogger.getOut().close();
        }
    }

    public static interface ErrorMessageHandler {
        public void errorResponse(String var1);

        public void errorEvent(String var1);
    }

    public static interface CommandResponseCallback {
        public void notifyResponse(V8Request var1, @NullAllowed V8Response var2);
    }

    public static interface Listener {
        public void notifySuspended(boolean var1);

        public void notifyCurrentFrame(@NullAllowed CallFrame var1);

        public void notifyFinished();
    }

    private final class RunToResponseCallback
    implements CommandResponseCallback {
        private RunToResponseCallback() {
        }

        @Override
        public void notifyResponse(V8Request request, V8Response response) {
            if (response != null) {
                SetBreakpoint.ResponseBody sbrb = (SetBreakpoint.ResponseBody)response.getBody();
                long id = sbrb.getBreakpoint();
                V8Debugger.this.runToBreakpointId = id;
                V8Debugger.this.resume();
            }
        }
    }
}

