/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DatabaseManagementConfig;
import com.oracle.bmc.database.model.OperationsInsightsConfig;
import com.oracle.bmc.database.model.StackMonitoringConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalPluggableDatabaseSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sourceId")
    private final String sourceId;
    @JsonProperty(value="externalContainerDatabaseId")
    private final String externalContainerDatabaseId;
    @JsonProperty(value="operationsInsightsConfig")
    private final OperationsInsightsConfig operationsInsightsConfig;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="dbUniqueName")
    private final String dbUniqueName;
    @JsonProperty(value="dbId")
    private final String dbId;
    @JsonProperty(value="databaseVersion")
    private final String databaseVersion;
    @JsonProperty(value="databaseEdition")
    private final DatabaseEdition databaseEdition;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="characterSet")
    private final String characterSet;
    @JsonProperty(value="ncharacterSet")
    private final String ncharacterSet;
    @JsonProperty(value="dbPacks")
    private final String dbPacks;
    @JsonProperty(value="databaseConfiguration")
    private final DatabaseConfiguration databaseConfiguration;
    @JsonProperty(value="databaseManagementConfig")
    private final DatabaseManagementConfig databaseManagementConfig;
    @JsonProperty(value="stackMonitoringConfig")
    private final StackMonitoringConfig stackMonitoringConfig;

    @Deprecated
    @ConstructorProperties(value={"sourceId", "externalContainerDatabaseId", "operationsInsightsConfig", "compartmentId", "freeformTags", "definedTags", "displayName", "id", "lifecycleDetails", "lifecycleState", "timeCreated", "dbUniqueName", "dbId", "databaseVersion", "databaseEdition", "timeZone", "characterSet", "ncharacterSet", "dbPacks", "databaseConfiguration", "databaseManagementConfig", "stackMonitoringConfig"})
    public ExternalPluggableDatabaseSummary(String sourceId, String externalContainerDatabaseId, OperationsInsightsConfig operationsInsightsConfig, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String displayName, String id, String lifecycleDetails, LifecycleState lifecycleState, Date timeCreated, String dbUniqueName, String dbId, String databaseVersion, DatabaseEdition databaseEdition, String timeZone, String characterSet, String ncharacterSet, String dbPacks, DatabaseConfiguration databaseConfiguration, DatabaseManagementConfig databaseManagementConfig, StackMonitoringConfig stackMonitoringConfig) {
        this.sourceId = sourceId;
        this.externalContainerDatabaseId = externalContainerDatabaseId;
        this.operationsInsightsConfig = operationsInsightsConfig;
        this.compartmentId = compartmentId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.id = id;
        this.lifecycleDetails = lifecycleDetails;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.dbUniqueName = dbUniqueName;
        this.dbId = dbId;
        this.databaseVersion = databaseVersion;
        this.databaseEdition = databaseEdition;
        this.timeZone = timeZone;
        this.characterSet = characterSet;
        this.ncharacterSet = ncharacterSet;
        this.dbPacks = dbPacks;
        this.databaseConfiguration = databaseConfiguration;
        this.databaseManagementConfig = databaseManagementConfig;
        this.stackMonitoringConfig = stackMonitoringConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getExternalContainerDatabaseId() {
        return this.externalContainerDatabaseId;
    }

    public OperationsInsightsConfig getOperationsInsightsConfig() {
        return this.operationsInsightsConfig;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getDbId() {
        return this.dbId;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public DatabaseEdition getDatabaseEdition() {
        return this.databaseEdition;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getNcharacterSet() {
        return this.ncharacterSet;
    }

    public String getDbPacks() {
        return this.dbPacks;
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return this.databaseConfiguration;
    }

    public DatabaseManagementConfig getDatabaseManagementConfig() {
        return this.databaseManagementConfig;
    }

    public StackMonitoringConfig getStackMonitoringConfig() {
        return this.stackMonitoringConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalPluggableDatabaseSummary(");
        sb.append("super=").append(super.toString());
        sb.append("sourceId=").append(String.valueOf(this.sourceId));
        sb.append(", externalContainerDatabaseId=").append(String.valueOf(this.externalContainerDatabaseId));
        sb.append(", operationsInsightsConfig=").append(String.valueOf((Object)this.operationsInsightsConfig));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", dbUniqueName=").append(String.valueOf(this.dbUniqueName));
        sb.append(", dbId=").append(String.valueOf(this.dbId));
        sb.append(", databaseVersion=").append(String.valueOf(this.databaseVersion));
        sb.append(", databaseEdition=").append(String.valueOf((Object)this.databaseEdition));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(", characterSet=").append(String.valueOf(this.characterSet));
        sb.append(", ncharacterSet=").append(String.valueOf(this.ncharacterSet));
        sb.append(", dbPacks=").append(String.valueOf(this.dbPacks));
        sb.append(", databaseConfiguration=").append(String.valueOf((Object)this.databaseConfiguration));
        sb.append(", databaseManagementConfig=").append(String.valueOf((Object)this.databaseManagementConfig));
        sb.append(", stackMonitoringConfig=").append(String.valueOf((Object)this.stackMonitoringConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalPluggableDatabaseSummary)) {
            return false;
        }
        ExternalPluggableDatabaseSummary other = (ExternalPluggableDatabaseSummary)((Object)o);
        return Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.externalContainerDatabaseId, other.externalContainerDatabaseId) && Objects.equals((Object)this.operationsInsightsConfig, (Object)other.operationsInsightsConfig) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.dbUniqueName, other.dbUniqueName) && Objects.equals(this.dbId, other.dbId) && Objects.equals(this.databaseVersion, other.databaseVersion) && Objects.equals((Object)this.databaseEdition, (Object)other.databaseEdition) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.characterSet, other.characterSet) && Objects.equals(this.ncharacterSet, other.ncharacterSet) && Objects.equals(this.dbPacks, other.dbPacks) && Objects.equals((Object)this.databaseConfiguration, (Object)other.databaseConfiguration) && Objects.equals((Object)this.databaseManagementConfig, (Object)other.databaseManagementConfig) && Objects.equals((Object)this.stackMonitoringConfig, (Object)other.stackMonitoringConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + (this.externalContainerDatabaseId == null ? 43 : this.externalContainerDatabaseId.hashCode());
        result = result * 59 + (this.operationsInsightsConfig == null ? 43 : this.operationsInsightsConfig.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.dbUniqueName == null ? 43 : this.dbUniqueName.hashCode());
        result = result * 59 + (this.dbId == null ? 43 : this.dbId.hashCode());
        result = result * 59 + (this.databaseVersion == null ? 43 : this.databaseVersion.hashCode());
        result = result * 59 + (this.databaseEdition == null ? 43 : this.databaseEdition.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + (this.characterSet == null ? 43 : this.characterSet.hashCode());
        result = result * 59 + (this.ncharacterSet == null ? 43 : this.ncharacterSet.hashCode());
        result = result * 59 + (this.dbPacks == null ? 43 : this.dbPacks.hashCode());
        result = result * 59 + (this.databaseConfiguration == null ? 43 : this.databaseConfiguration.hashCode());
        result = result * 59 + (this.databaseManagementConfig == null ? 43 : this.databaseManagementConfig.hashCode());
        result = result * 59 + (this.stackMonitoringConfig == null ? 43 : this.stackMonitoringConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DatabaseConfiguration implements BmcEnum
    {
        Rac("RAC"),
        SingleInstance("SINGLE_INSTANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DatabaseConfiguration> map;

        private DatabaseConfiguration(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseConfiguration create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DatabaseConfiguration', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DatabaseConfiguration.class);
            map = new HashMap<String, DatabaseConfiguration>();
            for (DatabaseConfiguration v : DatabaseConfiguration.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseEdition implements BmcEnum
    {
        StandardEdition("STANDARD_EDITION"),
        EnterpriseEdition("ENTERPRISE_EDITION"),
        EnterpriseEditionHighPerformance("ENTERPRISE_EDITION_HIGH_PERFORMANCE"),
        EnterpriseEditionExtremePerformance("ENTERPRISE_EDITION_EXTREME_PERFORMANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DatabaseEdition> map;

        private DatabaseEdition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseEdition create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DatabaseEdition', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DatabaseEdition.class);
            map = new HashMap<String, DatabaseEdition>();
            for (DatabaseEdition v : DatabaseEdition.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        NotConnected("NOT_CONNECTED"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sourceId")
        private String sourceId;
        @JsonProperty(value="externalContainerDatabaseId")
        private String externalContainerDatabaseId;
        @JsonProperty(value="operationsInsightsConfig")
        private OperationsInsightsConfig operationsInsightsConfig;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="dbUniqueName")
        private String dbUniqueName;
        @JsonProperty(value="dbId")
        private String dbId;
        @JsonProperty(value="databaseVersion")
        private String databaseVersion;
        @JsonProperty(value="databaseEdition")
        private DatabaseEdition databaseEdition;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="characterSet")
        private String characterSet;
        @JsonProperty(value="ncharacterSet")
        private String ncharacterSet;
        @JsonProperty(value="dbPacks")
        private String dbPacks;
        @JsonProperty(value="databaseConfiguration")
        private DatabaseConfiguration databaseConfiguration;
        @JsonProperty(value="databaseManagementConfig")
        private DatabaseManagementConfig databaseManagementConfig;
        @JsonProperty(value="stackMonitoringConfig")
        private StackMonitoringConfig stackMonitoringConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.__explicitlySet__.add("sourceId");
            return this;
        }

        public Builder externalContainerDatabaseId(String externalContainerDatabaseId) {
            this.externalContainerDatabaseId = externalContainerDatabaseId;
            this.__explicitlySet__.add("externalContainerDatabaseId");
            return this;
        }

        public Builder operationsInsightsConfig(OperationsInsightsConfig operationsInsightsConfig) {
            this.operationsInsightsConfig = operationsInsightsConfig;
            this.__explicitlySet__.add("operationsInsightsConfig");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            this.__explicitlySet__.add("dbUniqueName");
            return this;
        }

        public Builder dbId(String dbId) {
            this.dbId = dbId;
            this.__explicitlySet__.add("dbId");
            return this;
        }

        public Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            this.__explicitlySet__.add("databaseVersion");
            return this;
        }

        public Builder databaseEdition(DatabaseEdition databaseEdition) {
            this.databaseEdition = databaseEdition;
            this.__explicitlySet__.add("databaseEdition");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder characterSet(String characterSet) {
            this.characterSet = characterSet;
            this.__explicitlySet__.add("characterSet");
            return this;
        }

        public Builder ncharacterSet(String ncharacterSet) {
            this.ncharacterSet = ncharacterSet;
            this.__explicitlySet__.add("ncharacterSet");
            return this;
        }

        public Builder dbPacks(String dbPacks) {
            this.dbPacks = dbPacks;
            this.__explicitlySet__.add("dbPacks");
            return this;
        }

        public Builder databaseConfiguration(DatabaseConfiguration databaseConfiguration) {
            this.databaseConfiguration = databaseConfiguration;
            this.__explicitlySet__.add("databaseConfiguration");
            return this;
        }

        public Builder databaseManagementConfig(DatabaseManagementConfig databaseManagementConfig) {
            this.databaseManagementConfig = databaseManagementConfig;
            this.__explicitlySet__.add("databaseManagementConfig");
            return this;
        }

        public Builder stackMonitoringConfig(StackMonitoringConfig stackMonitoringConfig) {
            this.stackMonitoringConfig = stackMonitoringConfig;
            this.__explicitlySet__.add("stackMonitoringConfig");
            return this;
        }

        public ExternalPluggableDatabaseSummary build() {
            ExternalPluggableDatabaseSummary model = new ExternalPluggableDatabaseSummary(this.sourceId, this.externalContainerDatabaseId, this.operationsInsightsConfig, this.compartmentId, this.freeformTags, this.definedTags, this.displayName, this.id, this.lifecycleDetails, this.lifecycleState, this.timeCreated, this.dbUniqueName, this.dbId, this.databaseVersion, this.databaseEdition, this.timeZone, this.characterSet, this.ncharacterSet, this.dbPacks, this.databaseConfiguration, this.databaseManagementConfig, this.stackMonitoringConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalPluggableDatabaseSummary model) {
            if (model.wasPropertyExplicitlySet("sourceId")) {
                this.sourceId(model.getSourceId());
            }
            if (model.wasPropertyExplicitlySet("externalContainerDatabaseId")) {
                this.externalContainerDatabaseId(model.getExternalContainerDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("operationsInsightsConfig")) {
                this.operationsInsightsConfig(model.getOperationsInsightsConfig());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("dbUniqueName")) {
                this.dbUniqueName(model.getDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("dbId")) {
                this.dbId(model.getDbId());
            }
            if (model.wasPropertyExplicitlySet("databaseVersion")) {
                this.databaseVersion(model.getDatabaseVersion());
            }
            if (model.wasPropertyExplicitlySet("databaseEdition")) {
                this.databaseEdition(model.getDatabaseEdition());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            if (model.wasPropertyExplicitlySet("characterSet")) {
                this.characterSet(model.getCharacterSet());
            }
            if (model.wasPropertyExplicitlySet("ncharacterSet")) {
                this.ncharacterSet(model.getNcharacterSet());
            }
            if (model.wasPropertyExplicitlySet("dbPacks")) {
                this.dbPacks(model.getDbPacks());
            }
            if (model.wasPropertyExplicitlySet("databaseConfiguration")) {
                this.databaseConfiguration(model.getDatabaseConfiguration());
            }
            if (model.wasPropertyExplicitlySet("databaseManagementConfig")) {
                this.databaseManagementConfig(model.getDatabaseManagementConfig());
            }
            if (model.wasPropertyExplicitlySet("stackMonitoringConfig")) {
                this.stackMonitoringConfig(model.getStackMonitoringConfig());
            }
            return this;
        }
    }
}

