/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Action;
import org.netbeans.modules.beans.ClassPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class PatternNode
extends AbstractNode {
    private static final SystemAction[] DEFAULT_ACTIONS = new SystemAction[0];
    protected Pattern pattern;
    protected boolean writeable;

    public PatternNode(Pattern pattern, Children children, boolean writeable) {
        super(children);
        this.pattern = pattern;
        this.writeable = writeable;
        this.displayFormat = null;
    }

    public PatternNode(ClassPattern cp, boolean writeable) {
        super((Children)new PatternChildren(cp.getPatterns()));
        this.writeable = writeable;
        this.pattern = cp;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Image getIcon(int type) {
        return this.pattern.getIcon();
    }

    public Image getOpenedIcon(int type) {
        return this.pattern.getIcon();
    }

    public String getDisplayName() {
        return this.pattern.getName();
    }

    public String getHtmlDisplayName() {
        return this.pattern.getHtmlDisplayName();
    }

    public String getShortDescription() {
        return super.getShortDescription();
    }

    public boolean canRename() {
        return this.writeable;
    }

    public boolean canDestroy() {
        return this.writeable;
    }

    public Transferable clipboardCopy() throws IOException {
        return super.clipboardCopy();
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.writeable) {
            throw new IOException();
        }
        return super.clipboardCopy();
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return this.writeable;
    }

    public Action[] getActions(boolean context) {
        return DEFAULT_ACTIONS;
    }

    public final void setName(String name) {
    }

    public final void superSetName(String name) {
        super.setName(name);
    }

    protected void setPatternName(String name) {
        throw new UnsupportedOperationException();
    }

    public void destroy() throws IOException {
    }

    public void updateRecursively(Pattern p) {
        Children ch = this.getChildren();
        if (ch instanceof PatternChildren) {
            HashSet<Pattern> oldSubs = new HashSet<Pattern>(p.getPatterns());
            Node[] nodes = ch.getNodes(true);
            HashMap<Pattern, PatternNode> oldPattern2node = new HashMap<Pattern, PatternNode>();
            for (Node node : nodes) {
                oldPattern2node.put(((PatternNode)node).pattern, (PatternNode)node);
            }
            ((PatternChildren)ch).resetKeys(p.getPatterns());
            nodes = ch.getNodes(true);
            for (Pattern newSub : p.getPatterns()) {
                PatternNode node = (PatternNode)((Object)oldPattern2node.get(newSub));
                if (node == null) continue;
                if (!oldSubs.contains(newSub) && node.getChildren() != Children.LEAF) {
                    this.pattern.getPatternAnalyser().getUI().expandNode((Node)node);
                }
                node.updateRecursively(newSub);
            }
        }
        Pattern oldPattern = this.pattern;
        this.pattern = p;
        if (oldPattern.getHtmlDisplayName() != null && !oldPattern.getHtmlDisplayName().equals(this.pattern.getHtmlDisplayName())) {
            this.fireDisplayNameChange(oldPattern.name, this.pattern.name);
        }
        if (oldPattern.getIcon() != null && oldPattern.getIcon() != this.pattern.getIcon()) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }
}

