/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import com.oracle.bmc.monitoring.MonitoringClient;
import com.oracle.bmc.monitoring.model.ListMetricsDetails;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.developer.Bundle;
import org.netbeans.modules.cloud.oracle.developer.MetricsItem;
import org.netbeans.modules.cloud.oracle.developer.MetricsNamespaceItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class MetricsNode
extends OCINode {
    private static final String METRICS_ICON = "org/netbeans/modules/cloud/oracle/resources/metrics.svg";

    public MetricsNode(MetricsItem instance) {
        super((OCIItem)instance, Children.LEAF);
        this.setName(instance.getName());
        this.setDisplayName(instance.getName());
        this.setIconBaseWithExtension(METRICS_ICON);
        this.setShortDescription(Bundle.MetricsDesc(instance.getNamespace()));
    }

    public static NodeProvider<MetricsItem> createNode() {
        return MetricsNode::new;
    }

    public static ChildrenProvider.SessionAware<MetricsNamespaceItem, MetricsItem> getMetrics() {
        return (metricsNamespace, session) -> {
            MonitoringClient client = session.newClient(MonitoringClient.class);
            ListMetricsDetails listMetricsDetails = ListMetricsDetails.builder().namespace(metricsNamespace.getName()).build();
            ListMetricsRequest request = ListMetricsRequest.builder().compartmentId(metricsNamespace.getCompartmentId()).listMetricsDetails(listMetricsDetails).build();
            HashSet uniqueMetrics = new HashSet();
            String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
            return client.listMetrics(request).getItems().stream().filter(m -> uniqueMetrics.add(m.getName())).map(d -> new MetricsItem(d.getCompartmentId(), d.getName(), d.getNamespace(), session.getRegion(), tenancyId)).collect(Collectors.toList());
        };
    }
}

