/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.netbeans.modules.cloud.oracle.steps.DatasourceNameStep;
import org.netbeans.modules.cloud.oracle.steps.VaultStep;
import org.netbeans.modules.cloud.oracle.vault.SecretItem;
import org.netbeans.modules.cloud.oracle.vault.SecretNode;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public class OverwriteStep
extends AbstractStep<Boolean> {
    private Set<String> dsNames;
    private String choice;
    private Lookup lookup;
    private String dsName;
    private static final Pattern p = Pattern.compile("[A-Z]*_([a-zA-Z0-9]*)_[A-Z]*");

    @Override
    public void prepare(ProgressHandle h, Steps.Values values) {
        this.dsName = (String)values.getValueForStep(DatasourceNameStep.class);
        VaultItem vault = (VaultItem)values.getValueForStep(VaultStep.class);
        if (this.dsName == null || this.dsName.isEmpty() || vault == null) {
            return;
        }
        List<SecretItem> secrets = SecretNode.getSecrets().apply(vault);
        this.dsNames = secrets.stream().map(s -> OverwriteStep.extractDatasourceName(s.getName())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public NotifyDescriptor createInput() {
        if (this.dsName == null || this.dsName.isEmpty()) {
            return new NotifyDescriptor.QuickPick("", Bundle.DatasourceEmpty(), Collections.emptyList(), false);
        }
        ArrayList<NotifyDescriptor.QuickPick.Item> yesNo = new ArrayList<NotifyDescriptor.QuickPick.Item>();
        yesNo.add(new NotifyDescriptor.QuickPick.Item(Bundle.AddVersion(), ""));
        yesNo.add(new NotifyDescriptor.QuickPick.Item(Bundle.Cancel(), ""));
        return new NotifyDescriptor.QuickPick("", Bundle.SecretExists(this.dsName), yesNo, false);
    }

    @Override
    public void setValue(String choice) {
        this.choice = choice;
    }

    @Override
    public Boolean getValue() {
        return Bundle.AddVersion().equals(this.choice) || this.onlyOneChoice();
    }

    @Override
    public boolean onlyOneChoice() {
        return this.dsNames == null || !this.dsNames.contains(this.dsName);
    }

    protected static String extractDatasourceName(String value) {
        Matcher m = p.matcher(value);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }
}

