/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.InstancesContainerNode;

final class HeapPatterns {
    private static final String LINKED_LIST_CLASSNAME = "java.util.LinkedList";
    private static final Map<String, String> LINKED_LIST_ENTRY_CLASSNAMES;

    HeapPatterns() {
    }

    static HeapWalkerNode[] processReferencePatterns(InstanceNode parent, List references) {
        Instance instance = parent.getInstance();
        JavaClass classs = instance.getJavaClass();
        String className = classs.getName();
        if (HeapPatterns.isEntryClass(className)) {
            return HeapPatterns.processLinkedListReferencePatterns(parent, instance, classs, references);
        }
        return null;
    }

    private static HeapWalkerNode[] processLinkedListReferencePatterns(InstanceNode parent, Instance instance, JavaClass classs, List<Value> references) {
        List<Object> instances;
        String nodesCount;
        int referencesCount;
        boolean nested;
        Instance e1 = null;
        Instance e2 = null;
        Value v1 = null;
        Value v2 = null;
        Value v3 = null;
        Field f = null;
        boolean passed = false;
        boolean bl = nested = references.size() != 3;
        while (v3 == null && ((referencesCount = references.size()) == 2 || referencesCount == 3)) {
            JavaClass c3;
            Instance i3;
            v1 = references.get(0);
            v2 = references.get(1);
            v3 = referencesCount == 2 ? null : references.get(2);
            Instance i1 = v1 instanceof ObjectFieldValue ? v1.getDefiningInstance() : null;
            Instance i2 = v2 instanceof ObjectFieldValue ? v2.getDefiningInstance() : null;
            Instance instance2 = i3 = v3 instanceof ObjectFieldValue ? v3.getDefiningInstance() : null;
            if (i1 == null || i2 == null) break;
            JavaClass c1 = i1.getJavaClass();
            JavaClass c2 = i2.getJavaClass();
            JavaClass javaClass = c3 = i3 == null ? null : i3.getJavaClass();
            if (classs.equals((Object)c3)) {
                JavaClass c;
                Instance i;
                Value v;
                if (!classs.equals((Object)c1)) {
                    v = v3;
                    i = i3;
                    c = c3;
                    v3 = v1;
                    i3 = i1;
                    c3 = c1;
                    v1 = v;
                    i1 = i;
                    c1 = c;
                } else {
                    if (classs.equals((Object)c2)) break;
                    v = v3;
                    i = i3;
                    c = c3;
                    v3 = v2;
                    i3 = i2;
                    c3 = c2;
                    v2 = v;
                    i2 = i;
                    c2 = c;
                }
            }
            if (!classs.equals((Object)c1) || !classs.equals((Object)c2)) {
                if (e1 == null) break;
                if (LINKED_LIST_CLASSNAME.equals(c1.getName())) {
                    v3 = v1;
                    passed = true;
                    break;
                }
                if (!LINKED_LIST_CLASSNAME.equals(c2.getName())) break;
                v3 = v2;
                passed = true;
                break;
            }
            if (e1 == null) {
                e1 = i1;
                e2 = i2;
            }
            if (v3 == null) {
                Field f1 = ((ObjectFieldValue)v1).getField();
                Field f2 = ((ObjectFieldValue)v2).getField();
                if (f == null) {
                    f = f1;
                } else {
                    Field nextF = null;
                    if (f.equals((Object)f1)) {
                        nextF = f1;
                    } else if (f.equals((Object)f2)) {
                        nextF = f2;
                    }
                    if (nextF == null) break;
                    f = nextF;
                }
                references = f == f1 ? i1.getReferences() : i2.getReferences();
                continue;
            }
            passed = LINKED_LIST_CLASSNAME.equals(c3.getName());
        }
        if (!passed) {
            return null;
        }
        if (e1.equals(e2)) {
            nodesCount = Bundle.HeapPatterns_InstanceOfString(e1.getJavaClass().getName());
            instances = Collections.singletonList(e1);
        } else {
            nodesCount = Bundle.HeapPatterns_InstancesOfString(2, e1.getJavaClass().getName());
            instances = Arrays.asList(e1, e2);
        }
        String collapsedNodeName = HeapPatterns.getFieldNames(e1.getJavaClass()) + " (" + nodesCount + ")";
        HeapWalkerNode[] result = nested ? new HeapWalkerNode[]{new InstancesContainerNode(collapsedNodeName, parent, Collections.singletonList(v3), instances)} : new HeapWalkerNode[]{HeapWalkerNodeFactory.createReferenceNode(v3, parent), new InstancesContainerNode(collapsedNodeName, parent, Collections.EMPTY_LIST, instances)};
        return result;
    }

    private static boolean isEntryClass(String className) {
        return LINKED_LIST_ENTRY_CLASSNAMES.containsKey(className);
    }

    private static String getFieldNames(JavaClass entryClass) {
        return LINKED_LIST_ENTRY_CLASSNAMES.get(entryClass.getName());
    }

    static {
        HashMap<String, String> entryClass = new HashMap<String, String>();
        entryClass.put("java.util.LinkedList$Entry", "previous, next");
        entryClass.put("java.util.LinkedList$Node", "prev, next");
        LINKED_LIST_ENTRY_CLASSNAMES = Collections.unmodifiableMap(entryClass);
    }
}

