/**
A <span> element and derives from the HTMLElement interface, but without implementing any additional properties or methods.

@returns {HTMLSpanElement}
*/
HTMLSpanElement = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.accessKey = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.accessKeyLabel = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.autocapitalize = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.dir = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLSpanElement.prototype.draggable = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLSpanElement.prototype.hidden = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.innerText = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.lang = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.offsetHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.offsetLeft = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLSpanElement.prototype.offsetParent = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.offsetTop = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.offsetWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.outerText = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLSpanElement.prototype.spellcheck = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.title = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLSpanElement.prototype.translate = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {ElementInternals}
**/
HTMLSpanElement.prototype.attachInternals = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
HTMLSpanElement.prototype.click = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NamedNodeMap}
**/
HTMLSpanElement.prototype.attributes = new NamedNodeMap();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMTokenList}
**/
HTMLSpanElement.prototype.classList = new DOMTokenList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.className = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.clientHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.clientLeft = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.clientTop = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.clientWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.id = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.localName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.namespaceURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Element, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onfullscreenchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Element, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onfullscreenerror = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.outerHTML = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Document}
**/
HTMLSpanElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMTokenList}
**/
HTMLSpanElement.prototype.part = new DOMTokenList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.prefix = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.scrollHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.scrollLeft = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.scrollTop = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.scrollWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ShadowRoot | null)} ShadowRoot | null
**/
HTMLSpanElement.prototype.shadowRoot = new ShadowRoot();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.slot = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.tagName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates a shadow root for element and returns it.

@param {ShadowRootInit} init ShadowRootInit
@returns {ShadowRoot}
**/
HTMLSpanElement.prototype.attachShadow = function(init) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the first (starting at element) inclusive ancestor that matches selectors, and null otherwise.

@param {String} selectors
@returns {(Object | null)} E | null
**/
HTMLSpanElement.prototype.closest = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns element's first attribute whose qualified name is qualifiedName, and null if there is no such attribute otherwise.

@param {String} qualifiedName
@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.getAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns element's attribute whose namespace is namespace and local name is localName, and null if there is no such attribute otherwise.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.getAttributeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the qualified names of all element's attributes. Can contain duplicates.

@returns {String}
**/
HTMLSpanElement.prototype.getAttributeNames = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} qualifiedName
@returns {(Attr | null)} Attr | null
**/
HTMLSpanElement.prototype.getAttributeNode = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@param {String} localName
@returns {(Attr | null)} Attr | null
**/
HTMLSpanElement.prototype.getAttributeNodeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMRect}
**/
HTMLSpanElement.prototype.getBoundingClientRect = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMRectList}
**/
HTMLSpanElement.prototype.getClientRects = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a HTMLCollection of the elements in the object on which the method was invoked (a document or an element) that have all the classes given by classNames. The classNames argument is interpreted as a space-separated list of classes.

@param {String} classNames
@returns {HTMLCollectionOf}
**/
HTMLSpanElement.prototype.getElementsByClassName = function(classNames) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} qualifiedName
@returns {HTMLCollectionOf}
**/
HTMLSpanElement.prototype.getElementsByTagName = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@param {String} localName
@returns {HTMLCollectionOf}
**/
HTMLSpanElement.prototype.getElementsByTagNameNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if element has an attribute whose qualified name is qualifiedName, and false otherwise.

@param {String} qualifiedName
@returns {Boolean}
**/
HTMLSpanElement.prototype.hasAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if element has an attribute whose namespace is namespace and local name is localName.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {Boolean}
**/
HTMLSpanElement.prototype.hasAttributeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if element has attributes, and false otherwise.

@returns {Boolean}
**/
HTMLSpanElement.prototype.hasAttributes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pointerId
@returns {Boolean}
**/
HTMLSpanElement.prototype.hasPointerCapture = function(pointerId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("beforebegin" | "afterbegin" | "beforeend" | "afterend")} where InsertPosition
@param {Element} element Element
@returns {(Element | null)} Element | null
**/
HTMLSpanElement.prototype.insertAdjacentElement = function(where, element) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("beforebegin" | "afterbegin" | "beforeend" | "afterend")} position InsertPosition
@param {String} text
@returns {undefined}
**/
HTMLSpanElement.prototype.insertAdjacentHTML = function(position, text) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("beforebegin" | "afterbegin" | "beforeend" | "afterend")} where InsertPosition
@param {String} data
@returns {undefined}
**/
HTMLSpanElement.prototype.insertAdjacentText = function(where, data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if matching selectors against element's root yields element, and false otherwise.

@param {String} selectors
@returns {Boolean}
**/
HTMLSpanElement.prototype.matches = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pointerId
@returns {undefined}
**/
HTMLSpanElement.prototype.releasePointerCapture = function(pointerId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes element's first attribute whose qualified name is qualifiedName.

@param {String} qualifiedName
@returns {undefined}
**/
HTMLSpanElement.prototype.removeAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes element's attribute whose namespace is namespace and local name is localName.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {undefined}
**/
HTMLSpanElement.prototype.removeAttributeNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Attr} attr Attr
@returns {Attr}
**/
HTMLSpanElement.prototype.removeAttributeNode = function(attr) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Displays element fullscreen and resolves promise when done.

When supplied, options's navigationUI member indicates whether showing navigation UI while in fullscreen is preferred or not. If set to "show", navigation simplicity is preferred over screen space, and if set to "hide", more screen space is preferred. User agents are always free to honor user preference over the application's. The default value "auto" indicates no application preference.

@param {FullscreenOptions} [options] FullscreenOptions
@returns {Promise}
**/
HTMLSpanElement.prototype.requestFullscreen = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
HTMLSpanElement.prototype.requestPointerLock = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
HTMLSpanElement.prototype.scroll = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
HTMLSpanElement.prototype.scrollBy = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Boolean | ScrollIntoViewOptions)} [arg] boolean | ScrollIntoViewOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.scrollIntoView = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
HTMLSpanElement.prototype.scrollTo = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Sets the value of element's first attribute whose qualified name is qualifiedName to value.

@param {String} qualifiedName
@param {String} value
@returns {undefined}
**/
HTMLSpanElement.prototype.setAttribute = function(qualifiedName, value) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Sets the value of element's attribute whose namespace is namespace and local name is localName to value.

@param {(String | null)} namespace string | null
@param {String} qualifiedName
@param {String} value
@returns {undefined}
**/
HTMLSpanElement.prototype.setAttributeNS = function(namespace, qualifiedName, value) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Attr} attr Attr
@returns {(Attr | null)} Attr | null
**/
HTMLSpanElement.prototype.setAttributeNode = function(attr) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Attr} attr Attr
@returns {(Attr | null)} Attr | null
**/
HTMLSpanElement.prototype.setAttributeNodeNS = function(attr) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pointerId
@returns {undefined}
**/
HTMLSpanElement.prototype.setPointerCapture = function(pointerId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
If force is not given, "toggles" qualifiedName, removing it if it is present and adding it if it is not present. If force is true, adds qualifiedName. If force is false, removes qualifiedName.

Returns true if qualifiedName is now present, and false otherwise.

@param {String} qualifiedName
@param {Boolean} [force]
@returns {Boolean}
**/
HTMLSpanElement.prototype.toggleAttribute = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} selectors
@returns {Boolean}
**/
HTMLSpanElement.prototype.webkitMatchesSelector = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
HTMLSpanElement.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLSpanElement.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
HTMLSpanElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
HTMLSpanElement.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
HTMLSpanElement.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
HTMLSpanElement.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
HTMLSpanElement.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
HTMLSpanElement.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
HTMLSpanElement.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
HTMLSpanElement.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
HTMLSpanElement.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
HTMLSpanElement.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
HTMLSpanElement.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
HTMLSpanElement.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
HTMLSpanElement.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
HTMLSpanElement.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
HTMLSpanElement.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaAtomic = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaAutoComplete = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaBusy = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaChecked = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaColCount = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaColIndex = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaColSpan = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaCurrent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaDisabled = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaExpanded = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaHasPopup = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaHidden = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaKeyShortcuts = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaLabel = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaLevel = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaLive = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaModal = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaMultiLine = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaMultiSelectable = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaOrientation = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaPlaceholder = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaPosInSet = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaPressed = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaReadOnly = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaRequired = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaRoleDescription = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaRowCount = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaRowIndex = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaRowSpan = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaSelected = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaSetSize = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaSort = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaValueMax = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaValueMin = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaValueNow = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.ariaValueText = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Keyframe[] | PropertyIndexedKeyframes | null)} keyframes Keyframe[] | PropertyIndexedKeyframes | null
@param {(Number | KeyframeAnimationOptions)} [options] number | KeyframeAnimationOptions
@returns {Animation}
**/
HTMLSpanElement.prototype.animate = function(keyframes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {GetAnimationsOptions} [options] GetAnimationsOptions
@returns {Animation[]}
**/
HTMLSpanElement.prototype.getAnimations = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes just after node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLSpanElement.prototype.after = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes just before node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLSpanElement.prototype.before = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes node.

@returns {undefined}
**/
HTMLSpanElement.prototype.remove = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Replaces node with nodes, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLSpanElement.prototype.replaceWith = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
HTMLSpanElement.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLSpanElement.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
HTMLSpanElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
HTMLSpanElement.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
HTMLSpanElement.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
HTMLSpanElement.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
HTMLSpanElement.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
HTMLSpanElement.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
HTMLSpanElement.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
HTMLSpanElement.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
HTMLSpanElement.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
HTMLSpanElement.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
HTMLSpanElement.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
HTMLSpanElement.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
HTMLSpanElement.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
HTMLSpanElement.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
HTMLSpanElement.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.innerHTML = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLSpanElement.prototype.nextElementSibling = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLSpanElement.prototype.previousElementSibling = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.childElementCount = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollection}
**/
HTMLSpanElement.prototype.children = new HTMLCollection();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLSpanElement.prototype.firstElementChild = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
HTMLSpanElement.prototype.lastElementChild = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes after the last child of node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLSpanElement.prototype.append = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes before the first child of node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLSpanElement.prototype.prepend = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the first element that is a descendant of node that matches selectors.

@param {String} selectors
@returns {(Object | null)} E | null
**/
HTMLSpanElement.prototype.querySelector = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns all element descendants of node that match selectors.

@param {String} selectors
@returns {NodeListOf}
**/
HTMLSpanElement.prototype.querySelectorAll = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Replace all children of node with nodes, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
HTMLSpanElement.prototype.replaceChildren = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
HTMLSpanElement.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLSpanElement.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
HTMLSpanElement.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
HTMLSpanElement.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
HTMLSpanElement.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
HTMLSpanElement.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
HTMLSpanElement.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
HTMLSpanElement.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
HTMLSpanElement.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
HTMLSpanElement.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
HTMLSpanElement.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
HTMLSpanElement.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
HTMLSpanElement.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
HTMLSpanElement.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
HTMLSpanElement.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
HTMLSpanElement.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
HTMLSpanElement.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
HTMLSpanElement.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
HTMLSpanElement.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
HTMLSpanElement.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLSlotElement | null)} HTMLSlotElement | null
**/
HTMLSpanElement.prototype.assignedSlot = new HTMLSlotElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
HTMLSpanElement.prototype.oncopy = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
HTMLSpanElement.prototype.oncut = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
HTMLSpanElement.prototype.onpaste = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {CSSStyleDeclaration}
**/
HTMLSpanElement.prototype.style = new CSSStyleDeclaration();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.contentEditable = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.enterKeyHint = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.inputMode = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLSpanElement.prototype.isContentEditable = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: UIEvent) => any) | null
**/
HTMLSpanElement.prototype.onabort = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLSpanElement.prototype.onanimationcancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLSpanElement.prototype.onanimationend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLSpanElement.prototype.onanimationiteration = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
HTMLSpanElement.prototype.onanimationstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.onauxclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null
**/
HTMLSpanElement.prototype.onblur = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.oncanplay = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.oncanplaythrough = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.onclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onclose = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.oncontextmenu = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.oncuechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.ondblclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLSpanElement.prototype.ondrag = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLSpanElement.prototype.ondragend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLSpanElement.prototype.ondragenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLSpanElement.prototype.ondragleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLSpanElement.prototype.ondragover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLSpanElement.prototype.ondragstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
HTMLSpanElement.prototype.ondrop = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.ondurationchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onemptied = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onended = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(OnErrorEventHandlerNonNull | null)} OnErrorEventHandler
**/
HTMLSpanElement.prototype.onerror = new OnErrorEventHandlerNonNull();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null
**/
HTMLSpanElement.prototype.onfocus = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FormDataEvent) => any) | null
**/
HTMLSpanElement.prototype.onformdata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.ongotpointercapture = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.oninput = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.oninvalid = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
HTMLSpanElement.prototype.onkeydown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
HTMLSpanElement.prototype.onkeypress = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
HTMLSpanElement.prototype.onkeyup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onload = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onloadeddata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onloadedmetadata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onloadstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.onlostpointercapture = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.onmousedown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.onmouseenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.onmouseleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.onmousemove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.onmouseout = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.onmouseover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
HTMLSpanElement.prototype.onmouseup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onpause = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onplay = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onplaying = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.onpointercancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.onpointerdown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.onpointerenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.onpointerleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.onpointermove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.onpointerout = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.onpointerover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
HTMLSpanElement.prototype.onpointerup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: ProgressEvent) => any) | null
**/
HTMLSpanElement.prototype.onprogress = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onratechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onreset = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: UIEvent) => any) | null
**/
HTMLSpanElement.prototype.onresize = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onscroll = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: SecurityPolicyViolationEvent) => any) | null
**/
HTMLSpanElement.prototype.onsecuritypolicyviolation = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onseeked = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onseeking = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onselect = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onselectionchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onselectstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onslotchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onstalled = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: SubmitEvent) => any) | null
**/
HTMLSpanElement.prototype.onsubmit = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onsuspend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.ontimeupdate = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.ontoggle = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLSpanElement.prototype.ontouchcancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLSpanElement.prototype.ontouchend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLSpanElement.prototype.ontouchmove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
HTMLSpanElement.prototype.ontouchstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLSpanElement.prototype.ontransitioncancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLSpanElement.prototype.ontransitionend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLSpanElement.prototype.ontransitionrun = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
HTMLSpanElement.prototype.ontransitionstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onvolumechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onwaiting = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onwebkitanimationend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onwebkitanimationiteration = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onwebkitanimationstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
HTMLSpanElement.prototype.onwebkittransitionend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: WheelEvent) => any) | null
**/
HTMLSpanElement.prototype.onwheel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
HTMLSpanElement.prototype.autofocus = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMStringMap}
**/
HTMLSpanElement.prototype.dataset = new DOMStringMap();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
HTMLSpanElement.prototype.nonce = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
HTMLSpanElement.prototype.tabIndex = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
HTMLSpanElement.prototype.blur = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {FocusOptions} [options] FocusOptions
@returns {undefined}
**/
HTMLSpanElement.prototype.focus = function() {};

