/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.Iterator;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentNode;
import org.locationtech.jts.noding.SegmentNodeList;

class NodeVertexIterator
implements Iterator {
    private SegmentNodeList nodeList;
    private NodedSegmentString edge;
    private Iterator nodeIt;
    private SegmentNode currNode = null;
    private SegmentNode nextNode = null;
    private int currSegIndex = 0;

    NodeVertexIterator(SegmentNodeList nodeList) {
        this.nodeList = nodeList;
        this.edge = nodeList.getEdge();
        this.nodeIt = nodeList.iterator();
        this.readNextNode();
    }

    public boolean hasNext() {
        return this.nextNode != null;
    }

    public Object next() {
        if (this.currNode == null) {
            this.currNode = this.nextNode;
            this.currSegIndex = this.currNode.segmentIndex;
            this.readNextNode();
            return this.currNode;
        }
        if (this.nextNode == null) {
            return null;
        }
        if (this.nextNode.segmentIndex == this.currNode.segmentIndex) {
            this.currNode = this.nextNode;
            this.currSegIndex = this.currNode.segmentIndex;
            this.readNextNode();
            return this.currNode;
        }
        if (this.nextNode.segmentIndex > this.currNode.segmentIndex) {
            // empty if block
        }
        return null;
    }

    private void readNextNode() {
        this.nextNode = this.nodeIt.hasNext() ? (SegmentNode)this.nodeIt.next() : null;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

