/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.mapper;

import java.util.Optional;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableFieldType;

public class SparseVectorField
extends Field {
    public static final String SPARSE_FIELD = "sparse_vector_field";

    public SparseVectorField(String name, byte[] value, IndexableFieldType type) {
        super(name, value, type);
    }

    public static boolean isSparseField(FieldInfo field) {
        if (field == null) {
            return false;
        }
        return Optional.ofNullable((String)field.attributes().get(SPARSE_FIELD)).map(Boolean::parseBoolean).orElse(false);
    }
}

