/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlockLoader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MemoryMappableBlockLoader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.NativePmemMappableBlockLoader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.PmemMappableBlockLoader;
import org.apache.hadoop.io.nativeio.NativeIO;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class MappableBlockLoaderFactory {
    private MappableBlockLoaderFactory() {
    }

    public static MappableBlockLoader createCacheLoader(DNConf conf) {
        if (conf.getPmemVolumes() == null || conf.getPmemVolumes().length == 0) {
            return new MemoryMappableBlockLoader();
        }
        if (NativeIO.isAvailable() && NativeIO.POSIX.isPmdkAvailable()) {
            return new NativePmemMappableBlockLoader();
        }
        return new PmemMappableBlockLoader();
    }
}

