/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.InventoryTableConfiguration;
import software.amazon.awssdk.services.s3.model.JournalTableConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataConfiguration> {
    private static final SdkField<JournalTableConfiguration> JOURNAL_TABLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JournalTableConfiguration").getter(MetadataConfiguration.getter(MetadataConfiguration::journalTableConfiguration)).setter(MetadataConfiguration.setter(Builder::journalTableConfiguration)).constructor(JournalTableConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JournalTableConfiguration").unmarshallLocationName("JournalTableConfiguration").build(), RequiredTrait.create()}).build();
    private static final SdkField<InventoryTableConfiguration> INVENTORY_TABLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InventoryTableConfiguration").getter(MetadataConfiguration.getter(MetadataConfiguration::inventoryTableConfiguration)).setter(MetadataConfiguration.setter(Builder::inventoryTableConfiguration)).constructor(InventoryTableConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryTableConfiguration").unmarshallLocationName("InventoryTableConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOURNAL_TABLE_CONFIGURATION_FIELD, INVENTORY_TABLE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetadataConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final JournalTableConfiguration journalTableConfiguration;
    private final InventoryTableConfiguration inventoryTableConfiguration;

    private MetadataConfiguration(BuilderImpl builder) {
        this.journalTableConfiguration = builder.journalTableConfiguration;
        this.inventoryTableConfiguration = builder.inventoryTableConfiguration;
    }

    public final JournalTableConfiguration journalTableConfiguration() {
        return this.journalTableConfiguration;
    }

    public final InventoryTableConfiguration inventoryTableConfiguration() {
        return this.inventoryTableConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.journalTableConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventoryTableConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataConfiguration)) {
            return false;
        }
        MetadataConfiguration other = (MetadataConfiguration)obj;
        return Objects.equals(this.journalTableConfiguration(), other.journalTableConfiguration()) && Objects.equals(this.inventoryTableConfiguration(), other.inventoryTableConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataConfiguration").add("JournalTableConfiguration", (Object)this.journalTableConfiguration()).add("InventoryTableConfiguration", (Object)this.inventoryTableConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JournalTableConfiguration": {
                return Optional.ofNullable(clazz.cast(this.journalTableConfiguration()));
            }
            case "InventoryTableConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inventoryTableConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JournalTableConfiguration", JOURNAL_TABLE_CONFIGURATION_FIELD);
        map.put("InventoryTableConfiguration", INVENTORY_TABLE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataConfiguration, T> g) {
        return obj -> g.apply((MetadataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JournalTableConfiguration journalTableConfiguration;
        private InventoryTableConfiguration inventoryTableConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataConfiguration model) {
            this.journalTableConfiguration(model.journalTableConfiguration);
            this.inventoryTableConfiguration(model.inventoryTableConfiguration);
        }

        public final JournalTableConfiguration.Builder getJournalTableConfiguration() {
            return this.journalTableConfiguration != null ? this.journalTableConfiguration.toBuilder() : null;
        }

        public final void setJournalTableConfiguration(JournalTableConfiguration.BuilderImpl journalTableConfiguration) {
            this.journalTableConfiguration = journalTableConfiguration != null ? journalTableConfiguration.build() : null;
        }

        @Override
        public final Builder journalTableConfiguration(JournalTableConfiguration journalTableConfiguration) {
            this.journalTableConfiguration = journalTableConfiguration;
            return this;
        }

        public final InventoryTableConfiguration.Builder getInventoryTableConfiguration() {
            return this.inventoryTableConfiguration != null ? this.inventoryTableConfiguration.toBuilder() : null;
        }

        public final void setInventoryTableConfiguration(InventoryTableConfiguration.BuilderImpl inventoryTableConfiguration) {
            this.inventoryTableConfiguration = inventoryTableConfiguration != null ? inventoryTableConfiguration.build() : null;
        }

        @Override
        public final Builder inventoryTableConfiguration(InventoryTableConfiguration inventoryTableConfiguration) {
            this.inventoryTableConfiguration = inventoryTableConfiguration;
            return this;
        }

        public MetadataConfiguration build() {
            return new MetadataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataConfiguration> {
        public Builder journalTableConfiguration(JournalTableConfiguration var1);

        default public Builder journalTableConfiguration(Consumer<JournalTableConfiguration.Builder> journalTableConfiguration) {
            return this.journalTableConfiguration((JournalTableConfiguration)((JournalTableConfiguration.Builder)JournalTableConfiguration.builder().applyMutation(journalTableConfiguration)).build());
        }

        public Builder inventoryTableConfiguration(InventoryTableConfiguration var1);

        default public Builder inventoryTableConfiguration(Consumer<InventoryTableConfiguration.Builder> inventoryTableConfiguration) {
            return this.inventoryTableConfiguration((InventoryTableConfiguration)((InventoryTableConfiguration.Builder)InventoryTableConfiguration.builder().applyMutation(inventoryTableConfiguration)).build());
        }
    }
}

