/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4JNI;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.SafeUtils;

final class LZ4JNISafeDecompressor
extends LZ4SafeDecompressor {
    public static final LZ4JNISafeDecompressor INSTANCE = new LZ4JNISafeDecompressor();
    private static LZ4SafeDecompressor SAFE_INSTANCE;

    LZ4JNISafeDecompressor() {
    }

    @Override
    public final int decompress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        SafeUtils.checkRange(byArray, n2, n3);
        SafeUtils.checkRange(byArray2, n4, n5);
        int n6 = LZ4JNI.LZ4_decompress_safe(byArray, null, n2, n3, byArray2, null, n4, n5);
        if (n6 < 0) {
            throw new LZ4Exception("Error decoding offset " + (n2 - n6) + " of input buffer");
        }
        return n6;
    }

    @Override
    public int decompress(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) {
        ByteBufferUtils.checkNotReadOnly(byteBuffer2);
        ByteBufferUtils.checkRange(byteBuffer, n2, n3);
        ByteBufferUtils.checkRange(byteBuffer2, n4, n5);
        if ((byteBuffer.hasArray() || byteBuffer.isDirect()) && (byteBuffer2.hasArray() || byteBuffer2.isDirect())) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            ByteBuffer byteBuffer3 = null;
            ByteBuffer byteBuffer4 = null;
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n2 += byteBuffer.arrayOffset();
            } else {
                assert (byteBuffer.isDirect());
                byteBuffer3 = byteBuffer;
            }
            if (byteBuffer2.hasArray()) {
                byArray2 = byteBuffer2.array();
                n4 += byteBuffer2.arrayOffset();
            } else {
                assert (byteBuffer2.isDirect());
                byteBuffer4 = byteBuffer2;
            }
            int n6 = LZ4JNI.LZ4_decompress_safe(byArray, byteBuffer3, n2, n3, byArray2, byteBuffer4, n4, n5);
            if (n6 < 0) {
                throw new LZ4Exception("Error decoding offset " + (n2 - n6) + " of input buffer");
            }
            return n6;
        }
        LZ4SafeDecompressor lZ4SafeDecompressor = SAFE_INSTANCE;
        if (lZ4SafeDecompressor == null) {
            lZ4SafeDecompressor = SAFE_INSTANCE = LZ4Factory.safeInstance().safeDecompressor();
        }
        return lZ4SafeDecompressor.decompress(byteBuffer, n2, n3, byteBuffer2, n4, n5);
    }
}

