/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.lz4.LZ4JNI;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.SafeUtils;

final class LZ4JNIFastDecompressor
extends LZ4FastDecompressor {
    public static final LZ4JNIFastDecompressor INSTANCE = new LZ4JNIFastDecompressor();
    private static LZ4FastDecompressor SAFE_INSTANCE;

    LZ4JNIFastDecompressor() {
    }

    @Override
    public final int decompress(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        SafeUtils.checkRange(byArray, n2);
        SafeUtils.checkRange(byArray2, n3, n4);
        int n5 = LZ4JNI.LZ4_decompress_fast(byArray, null, n2, byArray2, null, n3, n4);
        if (n5 < 0) {
            throw new LZ4Exception("Error decoding offset " + (n2 - n5) + " of input buffer");
        }
        return n5;
    }

    @Override
    public int decompress(ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        ByteBufferUtils.checkNotReadOnly(byteBuffer2);
        ByteBufferUtils.checkRange(byteBuffer, n2);
        ByteBufferUtils.checkRange(byteBuffer2, n3, n4);
        if ((byteBuffer.hasArray() || byteBuffer.isDirect()) && (byteBuffer2.hasArray() || byteBuffer2.isDirect())) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            ByteBuffer byteBuffer3 = null;
            ByteBuffer byteBuffer4 = null;
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n2 += byteBuffer.arrayOffset();
            } else {
                assert (byteBuffer.isDirect());
                byteBuffer3 = byteBuffer;
            }
            if (byteBuffer2.hasArray()) {
                byArray2 = byteBuffer2.array();
                n3 += byteBuffer2.arrayOffset();
            } else {
                assert (byteBuffer2.isDirect());
                byteBuffer4 = byteBuffer2;
            }
            int n5 = LZ4JNI.LZ4_decompress_fast(byArray, byteBuffer3, n2, byArray2, byteBuffer4, n3, n4);
            if (n5 < 0) {
                throw new LZ4Exception("Error decoding offset " + (n2 - n5) + " of input buffer");
            }
            return n5;
        }
        LZ4FastDecompressor lZ4FastDecompressor = SAFE_INSTANCE;
        if (lZ4FastDecompressor == null) {
            lZ4FastDecompressor = SAFE_INSTANCE = LZ4Factory.safeInstance().fastDecompressor();
        }
        return lZ4FastDecompressor.decompress(byteBuffer, n2, byteBuffer2, n3, n4);
    }
}

