---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 脆弱性レポート
description: フィルターリング、グループ化、エクスポート、手動追加
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- 脆弱性の修正アクティビティーアイコンは、GitLab 17.5で[`vulnerability_report_vr_badge`](https://gitlab.com/gitlab-org/gitlab/-/issues/486549)フラグとともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/15036)されました。デフォルトでは無効になっています。
- GitLab 17.6では、[デフォルトで有効になっています](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171718)。
- GitLab 18.0で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/503568)になりました。機能フラグ`vulnerability_report_vr_badge`は削除されました。

{{< /history >}}

{{< alert type="flag" >}}

脆弱性の修正アクティビティーアイコンの利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

脆弱性レポートには、コードベースで見つかったセキュリティの脆弱性に関する統合ビューが用意されています。重大度、レポートの種類、スキャナー（プロジェクトのみ）、その他の属性で脆弱性を並べ替えて、最初に対応が必要なイシューを判断します。ステータスインジケーターと、修正の進捗状況を示すアクティビティーアイコンを使用して、ライフサイクル全体を通して脆弱性を追跡します。

共通脆弱性評価システム（CVSS）のスコアや、利用可能な場合はファイルロケーションなど、各脆弱性に関する詳細情報にアクセスできます。類似した脆弱性をフィルタリングしてグループ化し、体系的に対処します。

パフォーマンス上の理由から、脆弱性レポートに表示される脆弱性の合計数が1000件を超えると、正確な数ではなく**1000以上**と表示されます。この制限は、ページの上部に表示される件数にのみ影響します。テーブルにはすべての脆弱性が引き続き表示されます。

正確な数を表示するための改善は、[イシュー547510](https://gitlab.com/gitlab-org/gitlab/-/issues/547510)で提案されています。正確な数を見つけるには、[イシュー480378](https://gitlab.com/gitlab-org/gitlab/-/issues/480378#workarounds)の回避策のいずれかを使用してください。

{{< alert type="note" >}}

GitLab.comでは、脆弱性は最終更新から1年後に[アーカイブ](../vulnerability_archival/_index.md)されます。

{{< /alert >}}

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>概要については、[脆弱性管理 - 高度なセキュリティテスト](https://www.youtube.com/watch?v=alMRIq5UPbw)を参照してください。

## 脆弱性レポートの内容 {#contents-of-the-vulnerability-report}

レポートにはデフォルトブランチのデータが含まれており、成功したすべてのセキュリティスキャンジョブからの累積結果が表示されます。スキャンの結果は、ジョブの完了後、またはパイプラインが手動ジョブによってブロックされている場合に表示されます。

プロジェクトおよびグループの場合、脆弱性レポートには以下が含まれます:

- 重大度レベルごとの脆弱性の合計。
- 一般的な脆弱性属性のフィルター。
- テーブル形式で表示される各脆弱性の詳細。

一部の脆弱性では、詳細にデフォルトブランチ内の関連ファイルと行番号へのリンクが含まれます。CVEの脆弱性については、脆弱性レポートでKEVステータス、CVSSおよびEPSSスコア、到達可能性情報を表示することもできます。

プロジェクトの場合、脆弱性レポートには以下も含まれます:

- タイムスタンプは、デフォルトブランチが最後に更新された時刻を示し、最新のパイプラインへのリンクが含まれています。デフォルト以外のブランチに対して実行されるパイプラインは、タイムスタンプを更新しません。
- 最新のパイプラインで発生した失敗の数。エラー通知を選択して、パイプラインのページの**失敗したジョブ**タブを表示します。

**アクティビティー**列には、その行の脆弱性に対して行われたアクティビティー（ある場合）を示すアイコンが含まれています:

- イシュー{{< icon name="issues" >}}: 脆弱性に対して作成されたイシューへのリンク。
- マージリクエスト{{< icon name="merge-request" >}}: 脆弱性に対して作成されたマージリクエストへのリンク。
- チェックされた円{{< icon name="check-circle-dashed" >}}: 脆弱性は修正されました。
- 誤検出{{< icon name="false-positive" >}}: スキャナーは、この脆弱性が誤検出であると判断しました。
- 解決策{{< icon name="bulb" >}}: 脆弱性に対処策が利用可能であることを示します。
- 脆弱性の修正{{< icon name="tanuki-ai" >}}: 脆弱性に利用可能なAI修正があることを示します。

脆弱性に対して作成されたイシューを開くには、**アクティビティー**エントリにカーソルを合わせ、リンクを選択します。イシューアイコン（{{< icon name="issues" >}}）は、イシューのステータスを示します。[Jiraイシューサポート](../../../integration/jira/configure.md)が有効になっている場合、**アクティビティー**エントリにあるイシューリンクは、Jiraイシューにリンクします。GitLabイシューとは異なり、JiraイシューのステータスはGitLab UIには表示されません。

![プロジェクト脆弱性レポートの例](img/vulnerability_report_v18_4.png)

脆弱性が複数プロジェクトのパイプライン設定から発生した場合、このページには、選択したプロジェクトから発生した脆弱性が表示されます。

## 脆弱性レポートを表示する {#view-the-vulnerability-report}

脆弱性レポートを表示して、プロジェクトまたはグループ内のすべての脆弱性を一覧表示します。

前提要件:

- プロジェクトまたはグループのデベロッパーロール以上を持っている必要があります。

脆弱性レポートを表示するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **脆弱性レポート**を選択します。

## 脆弱性をフィルタリングする {#filtering-vulnerabilities}

{{< history >}}

- **識別子**フィルターは、GitLab 17.7で`vulnerability_filtering_by_identifier`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/452492)されました。デフォルトでは有効になっています。
- GitLab 17.9で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/502930)になりました。機能フラグ`vulnerability_filtering_by_identifier`は削除されました。

{{< /history >}}

脆弱性レポートの脆弱性をフィルタリングすることで、より効率的にトリアージできます。

以下でフィルタリングできます:

<!-- vale gitlab_base.SubstitutionWarning = NO -->

- **ステータス**: 脆弱性の現在の[状態](../vulnerabilities/_index.md#vulnerability-status-values)：トリアージが必要、確認済、無視、または解決。却下された脆弱性は、却下された理由によってまとめて、または個別にフィルタリングできます。
- **重大度**: 脆弱性の重大度の値：重大、高、中、低、情報、不明。
- **レポートタイプ**: 脆弱性を検出したレポートの種類（SAST、コンテナファジングなど）。
- **スキャナー**: 脆弱性を特定した特定のスキャナー。
- **アクティビティー**: 脆弱性に関する追加のプロパティ（イシュー、マージリクエスト、またはソリューションが利用可能かどうかなど）。
- **識別子**: 脆弱性の識別子でフィルタリングします（[advanced vulnerability management](#advanced-vulnerability-management)（高度な脆弱性管理）が必要です）。高度な脆弱性管理がない場合、利用できるのは最大20,000件の脆弱性を持つプロジェクトとグループに制限されます）。
- **プロジェクト**: 特定のプロジェクトの脆弱性をフィルタリングします（グループでのみ使用可能）。
- **到達可能性**: 脆弱性が到達可能かどうか（はい、見つからない、利用不可）に基づいてフィルター処理します。
- **有効性チェック**: 脆弱性をその有効性ステータス（アクティブ、非アクティブ、またはアクティブの可能性あり）でフィルタリングします。

<!-- vale gitlab_base.SubstitutionWarning = YES -->

### 脆弱性をフィルタリングする {#filter-vulnerabilities}

{{< history >}}

- 改善されたフィルタリングは、GitLab 16.9で`vulnerability_report_advanced_filtering` [フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/13339)されました。デフォルトでは無効になっています。
- GitLab 17.1で[GitLab.com、GitLab Self-Managed、およびGitLab Dedicatedで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/437128)。
- GitLab 17.2で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157172)になりました。機能フラグ`vulnerability_report_advanced_filtering`は削除されました。

{{< /history >}}

脆弱性レポートをフィルタリングして、脆弱性のサブセットに焦点を当てます。

脆弱性のリストをフィルタリングするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **脆弱性レポート**を選択します。
1. （オプション）デフォルトのフィルターを削除するには、**クリア**（{{< icon name="clear" >}}）を選択します。
1. 脆弱性のリストの上にある、フィルターバーを選択します。
1. 表示されるドロップダウンリストで、フィルタリングする属性を選択し、ドロップダウンリストから値を選択します。
1. フィルターフィールドの外側を選択します。脆弱性の重大度の合計と、一致する脆弱性のリストが更新されます。
1. 複数の属性でフィルタリングするには、前の3つの手順を繰り返します。複数の属性は、論理積で結合されます。

### レポートタイプのフィルター {#report-type-filter}

脆弱性を検出したレポートの種類に基づいて、脆弱性をフィルタリングできます。デフォルトでは、脆弱性レポートにはすべてのレポートタイプの脆弱性がリストされます。

**手動で追加されました**属性を使用して、手動で追加された脆弱性をフィルタリングします。

### スキャナーフィルター {#scanner-filter}

プロジェクトの場合、脆弱性を検出したスキャナーに基づいて脆弱性をフィルタリングできます。デフォルトでは、脆弱性レポートにはすべての[スキャナー](../detect/_index.md)からの脆弱性がリストされます。

### プロジェクトフィルター {#project-filter}

プロジェクトフィルターの内容は異なります:

- **Security Center**（セキュリティセンター）: [個人のセキュリティセンターに追加](../security_dashboard/_index.md#adding-projects-to-the-security-center)したプロジェクトのみ。
- **グループ**: グループ内のすべてのプロジェクト。
- **プロジェクト**: 該当なし。

### アクティビティーをフィルタリング {#activity-filter}

{{< history >}}

- GitLab 16.7で`activity_filter_has_remediations`[フラグ](../../../administration/feature_flags/_index.md)とともに導入されました。デフォルトでは無効になっています。
- GitLab 16.9で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/429262)になりました。機能フラグ`activity_filter_has_remediations`は削除されました。
- アクティビティーをフィルタリングするオプション**GitLab Duo (AI)**は、[`vulnerability_report_vr_filter`](https://gitlab.com/gitlab-org/gitlab/-/issues/486534)という名前のフラグが設定されたGitLab 17.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/15036)されました。デフォルトでは無効になっています。
- アクティビティーフィルターオプション**GitLab Duo (AI)**がGitLab 17.6で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171718)になりました。
- アクティビティーフィルターオプション**GitLab Duo (AI)**はGitLab 18.0で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172372)になりました。`vulnerability_report_vr_filter`フラグは削除されました。

{{< /history >}}

アクティビティーのフィルタリングは、他のフィルターとは動作が異なります。各カテゴリで選択できる値は1つだけです。フィルターを削除するには、アクティビティーをフィルタリングのドロップダウンリストから、削除するフィルターを選択します。

アクティビティーをフィルタリングを使用する場合の選択の動作は、次の通りです:

- **アクティビティー**
  - **すべてのアクティビティー**: アクティビティーステータスが任意（このフィルターを無視するのと同じ）の脆弱性。これを選択すると、他のすべてのアクティビティーフィルターオプションの選択が解除されます。
- **検出**
  - **まだ検出されています** (デフォルト): `default`ブランチの最新のパイプラインスキャンでまだ検出されている脆弱性。
  - **検出されませんでした**: `default`ブランチの最新のパイプラインスキャンで検出されなくなった脆弱性。
- **イシュー**
  - **Has issues**（イシューがあります）: 1つ以上の関連するイシューがある脆弱性。
  - **イシューはありません**: 関連するイシューがない脆弱性。
- **マージリクエスト**
  - **マージリクエストがあります**: 1つ以上の関連するマージリクエストがある脆弱性。
  - **マージリクエストはありません**: 関連するマージリクエストがない脆弱性。
- **利用可能な対策**
  - **解決策あり**: [自動マージリクエストで解決](../vulnerabilities/_index.md#resolve-a-vulnerability-with-a-merge-request)できる脆弱性。
  - **解決策がありません**: 自動マージリクエストによる解決が利用できない脆弱性。
- **GitLab Duo (AI)**:
  - **脆弱性の解決策は利用可能**: 利用可能なAI修正がある脆弱性。
  - **脆弱性の解決策は利用不可**: 利用可能なAI修正がない脆弱性。

**GitLab Duo (AI)**フィルターは、以下の場合に利用できます:

- セキュリティセンターの脆弱性レポート: [セキュリティセンター](../security_dashboard/_index.md#adding-projects-to-the-security-center)のすべてのプロジェクトで、**GitLab Duo**の切替がオンになっているとき。
- グループ脆弱性レポート: グループの場合、**GitLab Duoの機能**が**デフォルトで有効にする**に設定されているとき。
- プロジェクト脆弱性レポート: プロジェクトの場合、**GitLab Duo**切替がオンになっているとき。

### 到達可能性フィルター {#reachability-filter}

{{< history >}}

- GitLab 18.3で[導入](https://gitlab.com/groups/gitlab-org/-/epics/17251)されました。

{{< /history >}}

グループとプロジェクトの場合、[到達可能性](../dependency_scanning/static_reachability.md#understanding-the-results)の値に基づいて脆弱性をフィルタリングできます。デフォルトでは、脆弱性レポートには、到達可能性の値に関係なく、すべての脆弱性がリストされます。

OWASPトップ10 2021（[高度な脆弱性管理](#advanced-vulnerability-management)が必要）

### 有効性チェックフィルター {#validity-check-filter}

{{< history >}}

- GitLab 18.5で[`validity_check_es_filter`](https://gitlab.com/gitlab-org/gitlab/-/issues/560433)というフラグとともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/17407)されました。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能はテストには利用できますが、本番環境での使用には適していません。

{{< /alert >}}

グループとプロジェクトの場合、[有効性チェックの値](../vulnerabilities/validity_check.md)に基づいて脆弱性をフィルタリングできます。デフォルトでは、脆弱性レポートには、アクティブの可能性のあるステータスの脆弱性が一覧表示されます。

OWASPトップ10 2021（[高度な脆弱性管理](#advanced-vulnerability-management)が必要）

## 脆弱性をグループ化する {#grouping-vulnerabilities}

{{< history >}}

- プロジェクトごとの脆弱性のグループ化は、GitLab 16.4で[フラグ](../../../administration/feature_flags/_index.md)`vulnerability_report_grouping`とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/10164)されました。デフォルトでは無効になっています。
- GitLab 16.5では、プロジェクトごとの脆弱性のグループ化が[GitLab Self-ManagedおよびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134073)になっています。
- GitLab 16.6で、プロジェクトごとの脆弱性のグループ化が[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/422509)になりました。機能フラグ`vulnerability_report_grouping`は削除されました。
- グループごとの脆弱性のグループ化は、GitLab 16.7で[`group_level_vulnerability_report_grouping`](https://gitlab.com/gitlab-org/gitlab/-/issues/432778)フラグとともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137778)されました。デフォルトでは無効になっています。
- GitLab 17.2では、グループごとの脆弱性のグループ化が[GitLab Self-ManagedおよびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157949)になっています。
- GitLab 17.3で、グループごとの脆弱性のグループ化が[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/472669)になりました。機能フラグ`group_level_vulnerability_report_grouping`は削除されました。
- グループごとの脆弱性のOWASPトップ10グループ化は、GitLab 16.8で`vulnerability_owasp_top_10_group`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/432618)されました。デフォルトでは無効になっています。
- GitLab 17.4では、グループごとの脆弱性のOWASPトップ10グループ化が[GitLab Self-ManagedおよびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/437253)になっています。
- GitLab 17.4で、グループごとの脆弱性のOWASP Top 10グループ化が[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/437253)になりました。機能フラグ`vulnerability_owasp_top_10_group`は削除されました。
- OWASP Top 10グループ化の非OWASPカテゴリは、GitLab 17.1で`owasp_top_10_null_filtering`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/442526)されました。デフォルトでは無効になっています。
- GitLab 17.5では、OWASPトップ10グループ化の非OWASPカテゴリが[GitLab Self-ManagedおよびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/463783)になっています。
- GitLab 17.6で、OWASPトップ10グループ化の非OWASPカテゴリが[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/463783)になりました。機能フラグ`owasp_top_10_null_filtering`は削除されました。
- GitLab 18.1で、GitLab.comおよびGitLab DedicatedのOWASP 2021トップ10のグループ化が[追加](https://gitlab.com/gitlab-org/gitlab/-/issues/466034)されました。

{{< /history >}}

脆弱性レポートページで脆弱性をグループ化して、より効率的にトリアージできます。

以下によってグループ化できます:

- ステータス
- 重大度
- レポートタイプ
- スキャナー
- OWASPトップ10 2017
- OWASPトップ10 2021（[高度な脆弱性管理](#advanced-vulnerability-management)が必要）

### 脆弱性をグループ化する {#group-vulnerabilities}

脆弱性をグループ化するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **脆弱性レポート**を選択します。
1. **Group By**（グループごと）ドロップダウンリストから、グループを選択します。

脆弱性は、選択したグループに従ってグループ化されます。各グループは折りたたまれ、グループごとの脆弱性の合計数が名前の横に表示されます。各グループの脆弱性を表示するには、グループの名前を選択します。

## 脆弱性の詳細を表示する {#view-details-of-a-vulnerability}

脆弱性の詳細を表示するには、脆弱性の**説明**を選択します。[脆弱性の詳細](../vulnerabilities/_index.md)ページが開きます。

## 脆弱性のステータスを変更する {#change-status-of-vulnerabilities}

{{< history >}}

- GitLab 16.0で、コメントと却下理由の提供が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/408366)されました。

{{< /history >}}

脆弱性のトリアージを行う際に、脆弱性を無視するなど、ステータスを変更できます。

脆弱性が無視された場合、監査ログには、誰がいつ無視したか、そしてその理由が記録されます。脆弱性のレコードは削除できないため、永続的な記録が常に残ります。

前提要件:

- プロジェクトのメンテナーロール以上を持っている必要があります。`admin_vulnerability`権限は、GitLab 17.0のデベロッパーロールから[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/412693)されました。

脆弱性のステータスを変更するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **脆弱性レポート**を選択します。
1. 選択方法は次の通りです:
   - 1つ以上の脆弱性を選択するには、各脆弱性の横にあるチェックボックスを選択します。
   - ページ上のすべての脆弱性を選択するには、テーブルヘッダーのチェックボックスを選択します。
1. **ステータスの設定**ドロップダウンリストで、必要なステータスを選択します。
1. **やめる**ステータスを選択した場合は、ドロップダウンリストの**Set dismissal reason**（却下理由を設定））から目的の理由を選択します。
1. **コメントを追加**インプットに、コメントを入力できます。**やめる**ステータスの場合、コメントは必須です。
1. **ステータスの変更**を選択します。

選択した脆弱性のステータスが更新され、脆弱性レポートの内容が更新されます。

![プロジェクト脆弱性レポート](img/project_security_dashboard_status_change_v16_0.png)

## 脆弱性の重大度を変更またはオーバーライドする {#change-or-override-vulnerability-severity}

{{< history >}}

- GitLab 17.9で`vulnerability_severity_override`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/16157)されました。デフォルトでは無効になっています。
- GitLab 17.10の[GitLab.com、GitLab Self-Managed、およびGitLab Dedicatedで有効になりました](https://gitlab.com/groups/gitlab-org/-/epics/16157)。
- GitLab 18.1で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/ISSUE_ID)になりました。機能フラグ`vulnerability_severity_override`は削除されました。
- GitLab 18.1で、`hide_vulnerability_severity_override`[フラグ](../../../administration/feature_flags/_index.md)とともに、管理者が有効にすることでユーザーが重大度レベルを変更またはオーバーライドすることを防ぐことができる機能フラグが[追加](https://gitlab.com/gitlab-org/gitlab/-/issues/537229)されました。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

場合によっては、組織の優先順位をより適切に反映するために、検出された脆弱性の重大度を調整する必要があります。たとえば、スキャナーが低い重大度を報告する可能性がありますが、環境または設定に基づいて、より重大であると見なす場合があります。この機能を使用すると、スキャナーによって割り当てられたデフォルトの重大度を上書きできます。

前提要件:

- プロジェクトまたは`admin_vulnerability`権限に対して、少なくともメンテナーロールを持っている必要があります。

脆弱性の重大度を手動でオーバーライドするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **脆弱性レポート**に移動します。
1. 脆弱性を選択します:
   - 個々の脆弱性を選択するには、各脆弱性の横にあるチェックボックスを選択します。
   - ページ上のすべての脆弱性を選択するには、テーブルヘッダーのチェックボックスを選択します。
1. **アクションを選択**ドロップダウンリストで、**重大度の変更**を選択します。
1. **重大度を選択**ドロップダウンリストで、目的の重大度レベルを選択します。
1. **重大度の変更理由を追加(必須)**テキストボックスに、重大度を変更する理由を簡単に説明する文を追加します。
1. **重大度の変更**を選択します。

脆弱性を選択すると、その都度次の通りとなります:

- その重大度は、**Vulnerability details page**（脆弱性の詳細ページ）と**脆弱性レポート**の両方で更新されます。
- 重大度にバッジが追加され、重大度がオーバーライドされたことが示されます。
- 手動による重大度の調整は、脆弱性の**history**（履歴）に記録されます。

![脆弱性の重大度のオーバーライド](img/vulnerability_severity_change_v17_10.png)

## ユーザーが脆弱性の重大度をオーバーライドするのを防ぐ {#prevent-users-from-overriding-vulnerability-severities}

{{< history >}}

- GitLab 18.1で`hide_vulnerability_severity_override`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/537229)されました。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

環境によっては、ユーザーが脆弱性の重大度をオーバーライドできないようにする必要がある場合があります。`hide_vulnerability_severity_override`機能フラグを使用すると、管理者は脆弱性レポートで重大度のオーバーライド機能を非表示にできます。この機能は、組織がプロジェクト全体で標準化された脆弱性の重大度評価を維持するのに役立ちます。この機能を有効にすると、次のようになります:

- 脆弱性レポートのアクションドロップダウンリストから**重大度の変更**オプションを非表示にします。
- ユーザーが重大度レベルを手動で変更できないようにすることで、スキャナーの結果に基づいて一貫した脆弱性スコアリングを保証します。
- すべてのアクセス方法で一貫性を維持しながら、脆弱性の重大度の変更に関連するすべてのAPIエンドポイントを無効にします。

`hide_vulnerability_severity_override`フラグを有効にするには、[機能フラグの背後にデプロイされたGitLab機能を有効/無効にする](../../../administration/feature_flags/_index.md)を参照してください。

## 既存のイシューに脆弱性を追加する {#add-vulnerabilities-to-an-existing-issue}

{{< history >}}

- GitLab 17.9で`enhanced_vulnerability_bulk_actions`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/13216)されました。デフォルトでは無効になっています。
- GitLab 18.0 [でGitLab.com、GitLab Self-Managed、GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190213)で有効になりました。
- GitLab 18.1で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/515204)になりました。機能フラグ`enhanced_vulnerability_bulk_actions`は削除されました。

{{< /history >}}

1つまたは複数の脆弱性を脆弱性レポート内の既存のイシューにリンクできます。

前提要件:

- 少なくともプロジェクトに対するメンテナーロールか、カスタムロールでの`admin_vulnerability`権限を持っている必要があります。`admin_vulnerability`権限は、GitLab 17.0のデベロッパーロールから[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/412693)されました。

脆弱性を既存のイシューにアタッチするには、次のようにします:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **脆弱性レポート**に移動します。
1. 脆弱性を選択します:
   - 個々の脆弱性を選択するには、各脆弱性の横にあるチェックボックスを選択します。
   - ページ上のすべての脆弱性を選択するには、テーブルヘッダーのチェックボックスを選択します。
1. **アクションを選択**ドロップダウンリストで、**既存のイシューにアタッチ**を選択します。
1. **イシューのURLか、 <#イシューID>**テキストボックスに、オートコンプリートするイシューのIDを入力するか、イシューのURLを追加します。複数のイシューを入力して、脆弱性を追加することができます。
1. **追加**を選択します。

選択した各脆弱性は、指定したすべてのイシューにリンクされます。

![脆弱性を既存のイシューにアタッチ](img/vulnerability_attach_existing_issue_v18_0.png)

## 新規のイシューに脆弱性を追加する {#add-vulnerabilities-to-a-new-issue}

{{< history >}}

- GitLab 17.9で`new_issue_attachment_from_vulnerability_bulk_action`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/13216)されました。デフォルトでは無効になっています。
- GitLab 18.0 [でGitLab.com、GitLab Self-Managed、GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190213)で有効になりました。
- GitLab 18.1で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/516939)になりました。機能フラグ`new_issue_attachment_from_vulnerability_bulk_action`は削除されました。

{{< /history >}}

1つまたは複数の脆弱性を新規のイシューにリンクできます。

前提要件:

- 少なくともプロジェクトに対するメンテナーロールか、カスタムロールでの`admin_vulnerability`権限を持っている必要があります。`admin_vulnerability`権限は、GitLab 17.0のデベロッパーロールから[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/412693)されました。

脆弱性を新規のイシューにアタッチするには、次のようにします:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **脆弱性レポート**に移動します。
1. 脆弱性を選択します:
   - 個々の脆弱性を選択するには、各脆弱性の横にあるチェックボックスを選択します。
   - ページ上のすべての脆弱性を選択するには、テーブルヘッダーのチェックボックスを選択します。
1. **アクションを選択**ドロップダウンリストで、**新規のイシューにアタッチ**を選択します。
1. **イシューの作成**を選択します。

新規のイシューにリダイレクトされます。選択した各脆弱性は、すでにリンクされています。

![脆弱性を新規のイシューにアタッチ](img/vulnerability_attach_new_issue_v18_0.png)

## 検出された日付で脆弱性をソートする {#sort-vulnerabilities-by-date-detected}

デフォルトでは、脆弱性は重大度レベルでソートされ、最も重大度の高い脆弱性がリストの一番上に表示されます。

各脆弱性が検出された日付で脆弱性をソートするには、「検出日」列のヘッダーを選択します。

## エクスポート {#exporting}

{{< history >}}

- GitLab 16.8で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/434076)されたCSVエクスポートの列として「Dismissal Reason（無視する理由）」を追加しました。

{{< /history >}}

脆弱性レポートにリストされている脆弱性の詳細をエクスポートできます。エクスポート形式はCSV（カンマ区切り値）です。フィルターはエクスポートに適用されないため、すべての脆弱性が含まれます。

含まれるフィールドは次のとおりです:

- ステータス（ステータス値がどのようにエクスポートされるかの詳細については、次のテーブルを参照してください）
- グループ名
- プロジェクト名
- レポートタイプ
- スキャナー名
- 脆弱性
- 基本的な詳細
- 追加情報
- 重大度
- [CVE](https://cve.mitre.org/)（共通脆弱性識別子）
- [CWE](https://cwe.mitre.org/)（共通脆弱性タイプ一覧）
- その他の識別子
- 検出日時
- 場所
- アクティビティー: デフォルトブランチで脆弱性が解決された場合は`true`を返し、そうでない場合は`false`を返します。
- コメント
- フルパス
- CVSSベクター
- [無視する理由](../vulnerabilities/_index.md#vulnerability-dismissal-reasons)
- 脆弱性ID

{{< alert type="note" >}}

完全な詳細については、[ジョブアーティファクトAPI](../../../api/job_artifacts.md#download-a-single-artifact-file-by-reference-name)をご覧ください。`gl-*-report.json`レポートファイル名のいずれかを`*artifact_path`の代わりに使用して、たとえば、脆弱性が検出されたファイルへのパスを取得します。

{{< /alert >}}

脆弱性レポートに表示されるStatus（ステータス）フィールドの値は、脆弱性エクスポートに含まれる値とは異なります。それらを一致させるには、次の参照テーブルを使用します。

| 脆弱性レポート | 脆弱性エクスポート |
|:---------------------|:---------------------|
| トリアージが必要         | 検出済み             |
| 削除済み            | 削除済み            |
| 解決済み             | 解決済み             |
| 確認済み            | 確認済み            |

### 詳細をエクスポート {#export-details}

脆弱性レポートにリストされているすべての脆弱性の詳細をエクスポートするには、**エクスポート**を選択します。

エクスポートされた詳細が利用可能になると、メールが届きます。エクスポートされた詳細をダウンロードするには、メール内のリンクを選択します。

{{< alert type="note" >}}

一部のCSVリーダーは、行数または列のサイズに制限があり、大規模なエクスポートと互換性がない場合があります。脆弱性エクスポートは、個々のプログラムの制限を考慮していません。

{{< /alert >}}

## 脆弱性を手動で追加する {#manually-add-a-vulnerability}

{{< history >}}

- GitLab 15.0で[機能フラグ`new_vulnerability_form`](https://gitlab.com/gitlab-org/gitlab/-/issues/359049)が削除されました。

{{< /history >}}

GitLab脆弱性データベースで使用できない場合は、脆弱性を手動で追加します。プロジェクトの脆弱性レポートでのみ脆弱性を追加できます。

脆弱性を手動で追加するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **脆弱性レポート**を選択します。
1. **脆弱性を送信**を選択します。
1. フィールドに入力してフォームを送信します。

新しく作成された脆弱性の詳細ページが開きます。

## 高度な脆弱性管理 {#advanced-vulnerability-management}

{{< history >}}

- 高度な検索への脆弱性データの取り込みは、GitLab 18.1で`vulnerability_es_ingestion`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/536299)されました。GitLab.comおよびGitLab Dedicatedで使用できます。デフォルトでは無効になっています。
- 高度な検索でのOWASP 2021のグループ化および識別子のフィルターは、GitLab 18.1の機能フラグ`advanced_vulnerability_management`により[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/537673)されました。GitLab.comおよびGitLab Dedicatedで使用できます。デフォルトでは無効になっています。
- 高度な検索への脆弱性データの取り込みは、GitLab 18.2のGitLab.comおよびGitLab Dedicatedで[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/536299)されています。機能フラグ`vulnerability_es_ingestion`は削除されました。
- 高度な検索でのOWASP 2021のグループ化および識別子のフィルターは、GitLab 18.2の機能フラグ`advanced_vulnerability_management`により[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/537673)されました。GitLab.comおよびGitLab Dedicatedで使用できます。デフォルトでは有効になっています。

{{< /history >}}

{{< alert type="flag" >}}

高度な脆弱性管理は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

GitLabは主に、脆弱性レポートのフィルター処理にPostgreSQLを使用します。データベースインデックス作成の制限と、複数のフィルターを適用する際のパフォーマンス上の課題のため、GitLabでは特定の脆弱性管理機能に[高度な検索](../../search/advanced_search.md)を使用します。

高度な検索は、次の機能を強化します:

1. プロジェクトまたはグループの脆弱性レポートで、データをOWASP 2021カテゴリ別にグループ化します。
1. プロジェクトまたはグループの脆弱性レポートで、脆弱性の識別子に基づいてフィルター処理を行います。
1. プロジェクトまたはグループの脆弱性レポートで、到達可能性の値に基づいてフィルタリングします。
1. プロジェクトまたはグループの脆弱性レポートで、有効性チェックの値に基づいてフィルタリングします。

高度な検索は、これらの特定の機能でのみ使用され、ここには他の[フィルター](#filter-vulnerabilities)と組み合わせた場合も含まれます。他のフィルターは、個別に使用すると、引き続き標準のPostgreSQLフィルター処理を使用します。

### 要件 {#requirements}

高度な脆弱性管理でフィルターを使用するには:

- [高度な検索が有効](../../search/advanced_search.md#use-advanced-search)になっている必要があります。
- プロジェクトまたはグループの脆弱性レポートの参照が必要です。この機能はセキュリティダッシュボードではサポートされていませんが、[イシュー537807](https://gitlab.com/gitlab-org/gitlab/-/issues/537807)でサポートが提案されています。

## 運用上の脆弱性 {#operational-vulnerabilities}

**運用上の脆弱性**タブには、[運用コンテナスキャン（OCS）](../../clusters/agent/vulnerabilities.md)によって検出された脆弱性がリスト表示されます。このタブは、プロジェクト、グループ、およびセキュリティセンターの脆弱性レポートに表示されます。
