---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: コントリビュートカレンダー
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

コントリビューションカレンダーには、過去12か月間の[ユーザーのイベント](#user-contribution-events)が表示されます。これには、フォークしたリポジトリと[プライベート](#show-private-contributions-on-your-user-profile-page)リポジトリで行われたコントリビューションが含まれます。

![コントリビュートカレンダー](img/contributions_calendar_v15_6.png)

タイルのグラデーションカラーは、1日あたりのコントリビューション数を示しています。グラデーションは、空白（コントリビューション0件）から濃い青色（コントリビューション30件超）までの範囲です。

{{< alert type="note" >}}

コントリビューションカレンダーには、過去12か月間のコントリビューションのみが表示されますが、イシュー[24264](https://gitlab.com/gitlab-org/gitlab/-/issues/24264)では、これを12か月以上に変更することが提案されています。ユーザープロファイルの一般的な改善は、イシュー[8488](https://gitlab.com/groups/gitlab-org/-/epics/8488)で提案されています。

{{< /alert >}}

グループのすべてのメンバーのコントリビューションイベントの包括的なビューについては、[コントリビューション分析](../group/contribution_analytics/_index.md)を使用できます。

## ユーザーコントリビューションイベント {#user-contribution-events}

GitLabは、次のコントリビューションイベントを追跡します:

| イベント | コントリビューション |
| ----- | ------------ |
| `approved` | マージリクエスト |
| `closed` | [エピック](../group/epics/_index.md)、イシュー、マージリクエスト、マイルストーン、作業アイテム |
| `commented`すべての`Noteable`レコードで。 | アラート、コミット、デザイン、イシュー、マージリクエスト、スニペット |
| `created` | デザイン、エピック、イシュー、マージリクエスト、マイルストーン、プロジェクト、Wikiページ、作業アイテム |
| `destroyed` | デザイン、マイルストーン、Wikiページ |
| `expired` | プロジェクトメンバーシップ |
| `joined` | プロジェクトメンバーシップ |
| `left` | プロジェクトメンバーシップ |
| `merged` | マージリクエスト |
| `pushed`リポジトリへのコミット（またはリポジトリからのコミットの削除）を、個別または一括して。 | プロジェクト |
| `reopened` | エピック、イシュー、マージリクエスト、マイルストーン |
| `updated` | デザイン、Wikiページ |

### 毎日のコントリビューションを表示する {#view-daily-contributions}

毎日のコントリビューションを表示するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. ドロップダウンリストから自分の名前を選択します。
1. コントリビューションカレンダーの場合:
   - 特定の日付のコントリビューション数を表示するには、タイルにカーソルを合わせるます。
   - 特定の日付のすべてのコントリビューションを表示するには、タイルを選択します。リストに、すべてのコントリビューションと作成時刻が表示されます。

### ユーザープロファイルページにプライベートコントリビュートを表示する {#show-private-contributions-on-your-user-profile-page}

コントリビューションカレンダーグラフと最近のアクティビティーリストには、プライベートプロジェクトへの[コントリビューションアクション](#user-contribution-events)が表示されます。

プライベートなコントリビュートを表示するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. **主要設定**セクションで、**Include private contributions on my profile**（プロファイルにプライベートコントリビュートを含める）チェックボックスをオンにします。
1. **プロファイル設定を更新**を選択します。

## ユーザーアクティビティー {#user-activity}

### ユーザーのアクティビティーをフォローする {#follow-a-users-activity}

アクティビティーに関心のあるユーザーを追跡できます。[GitLab 15.5以降](https://gitlab.com/gitlab-org/gitlab/-/issues/360755)では、フォローできるユーザーの最大数は300人です。

ユーザーをフォローするには、次のいずれかの方法を使用します:

- ユーザーのプロファイルから、**フォローする**を選択します。
- ユーザーの名前にカーソルを合わせる、**フォローする** （GitLab 15.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76050)）を選択します。

フォローしているユーザーのアクティビティーを表示するには:

1. GitLabメニューで、**アクティビティー**を選択します。
1. **フォロー中のユーザー**タブを選択します。

### フィードとしてユーザーアクティビティーを取得する {#retrieve-user-activity-as-a-feed}

GitLabは、ユーザーアクティビティーのRSSフィードを提供します。ユーザーアクティビティーのRSSフィードをサブスクライブするには:

1. [ユーザーのプロフィール](_index.md#access-your-user-profile)に移動します。
1. 右上隅で、フィードシンボル（{{< icon name="rss" >}}）を選択して、結果をAtom形式のRSSフィードとして表示します。

結果のURLには、フィードトークンと、表示が許可されているユーザーのアクティビティーの両方が含まれています。このURLをフィードリーダーに追加できます。

### ユーザーアクティビティーフィードトークンをリセットする {#reset-the-user-activity-feed-token}

フィードトークンは機密性が高く、機密のイシューから情報が漏洩する可能性があります。フィードトークンが漏洩したと思われる場合は、リセットする必要があります。

フィードトークンをリセットするには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. **パーソナルアクセストークン**を選択します。
1. 下にスクロールします。**フィードトークン**セクションで、**reset this token**（このトークンをリセットします）リンクを選択します。
1. 確認ダイアログで、**OK**を選択します。

新しいトークンが生成されました。

### イベント期間の制限 {#event-time-period-limit}

GitLabでは、パフォーマンス上の理由から、3年以上前のユーザーアクティビティーイベントをイベントテーブルから削除します。
