# frozen_string_literal: true

require 'gitlab'
require 'time'
require_relative 'error_pattern_matcher'
require_relative 'error_message_normalizer'
require_relative 'incident_checker'

module GitlabQuality
  module TestTooling
    module Report
      module GroupIssues
        class GroupResultsInIssues
          attr_reader :grouped_failures

          def initialize(options = {})
            @options = options
            @failure_processor = FailureProcessor.new(options)
            @issue_manager = IssueManager.new(options)
            @grouped_failures = {}
          end

          def process_failures(failures)
            @failure_processor.process_failures(failures) do |grouped_failure|
              fingerprint = grouped_failure[:fingerprint]
              @grouped_failures[fingerprint] = grouped_failure
            end

            @failure_processor.filter_groups_by_threshold(@grouped_failures)
          end

          def process_issues
            @grouped_failures.each_value do |grouped_failure|
              @issue_manager.create_or_update_issue(grouped_failure)
            end
          end

          def summary
            {
              grouped_issues: @grouped_failures.size,
              total_grouped_failures: @grouped_failures.values.sum { |group| group[:failures].size }
            }
          end
        end
      end
    end
  end
end
