/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.math.BigDecimal;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeFinite;
import org.assertj.core.error.ShouldBeInfinite;
import org.assertj.core.error.ShouldNotBeFinite;
import org.assertj.core.error.ShouldNotBeInfinite;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;

public abstract class RealNumbers<NUMBER extends Number>
extends Numbers<NUMBER> {
    protected RealNumbers() {
    }

    protected RealNumbers(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    public void assertIsNaN(AssertionInfo info, NUMBER actual) {
        this.assertEqualByComparison(info, (Comparable)actual, this.NaN());
    }

    protected BigDecimal absBigDecimalDiff(NUMBER number1, NUMBER number2) {
        BigDecimal number1AsbigDecimal = new BigDecimal(String.valueOf(number1));
        BigDecimal number2AsbigDecimal = new BigDecimal(String.valueOf(number2));
        return number1AsbigDecimal.subtract(number2AsbigDecimal).abs();
    }

    protected abstract NUMBER NaN();

    public void assertIsNotNaN(AssertionInfo info, NUMBER actual) {
        this.assertNotEqualByComparison(info, (Comparable)actual, this.NaN());
    }

    @Override
    protected boolean isGreaterThan(NUMBER value, NUMBER other) {
        return ((Comparable)value).compareTo(other) > 0;
    }

    public void assertIsFinite(AssertionInfo info, NUMBER actual) {
        RealNumbers.assertNotNull(info, actual);
        if (this.isFinite(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeFinite.shouldBeFinite(actual));
    }

    protected abstract boolean isFinite(NUMBER var1);

    public void assertIsNotFinite(AssertionInfo info, NUMBER actual) {
        RealNumbers.assertNotNull(info, actual);
        if (this.isNotFinite(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeFinite.shouldNotBeFinite(actual));
    }

    protected abstract boolean isNotFinite(NUMBER var1);

    public void assertIsInfinite(AssertionInfo info, NUMBER actual) {
        RealNumbers.assertNotNull(info, actual);
        if (this.isInfinite(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInfinite.shouldBeInfinite(actual));
    }

    protected abstract boolean isInfinite(NUMBER var1);

    public void assertIsNotInfinite(AssertionInfo info, NUMBER actual) {
        RealNumbers.assertNotNull(info, actual);
        if (this.isNotInfinite(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeInfinite.shouldNotBeInfinite(actual));
    }

    public boolean isNanOrInfinite(NUMBER value) {
        return this.isNaN(value) || this.isInfinite(value);
    }

    protected abstract boolean isNaN(NUMBER var1);

    protected abstract boolean isNotInfinite(NUMBER var1);
}

