/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.StatementCountVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyLongMethodInspectionBase
extends GroovyMethodMetricInspection {
    public GroovyOverlyLongMethodInspectionBase() {
        super(30);
    }

    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.method.ref.too.long.statement.count", args[0], args[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod method) {
            if (method == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            int limit = GroovyOverlyLongMethodInspectionBase.this.getLimit();
            StatementCountVisitor visitor2 = new StatementCountVisitor();
            GrOpenBlock block = method.getBlock();
            if (block == null) {
                return;
            }
            block.accept((PsiElementVisitor)visitor2);
            int statementCount = visitor2.getStatementCount();
            if (statementCount <= limit) {
                return;
            }
            this.registerMethodError(method, statementCount, limit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyLongMethodInspectionBase$Visitor", "visitMethod"));
        }
    }
}

