/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public class GroovyFilterLexer
extends BaseFilterLexer {
    public GroovyFilterLexer(Lexer originalLexer, OccurrenceConsumer occurrenceConsumer) {
        super(originalLexer, occurrenceConsumer);
    }

    public void advance() {
        IElementType tokenType = this.getDelegate().getTokenType();
        if (tokenType == GroovyTokenTypes.mIDENT || TokenSets.KEYWORDS.contains(tokenType)) {
            this.addOccurrenceInToken(1);
        } else if (TokenSets.STRING_LITERALS.contains(tokenType)) {
            this.scanWordsInToken(12, false, true);
        } else if (TokenSets.COMMENT_SET.contains(tokenType)) {
            this.scanWordsInToken(2, false, false);
            this.advanceTodoItemCountsInToken();
        } else {
            this.scanWordsInToken(16, false, false);
        }
        this.getDelegate().advance();
    }
}

