/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import org.jetbrains.coverage.org.objectweb.asm.ByteVector;
import org.jetbrains.coverage.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.coverage.org.objectweb.asm.SymbolTable;

final class ModuleWriter
extends ModuleVisitor {
    private final SymbolTable symbolTable;
    private final int moduleNameIndex;
    private final int moduleFlags;
    private final int moduleVersionIndex;
    private int requiresCount;
    private final ByteVector requires;
    private int exportsCount;
    private final ByteVector exports;
    private int opensCount;
    private final ByteVector opens;
    private int usesCount;
    private final ByteVector usesIndex;
    private int providesCount;
    private final ByteVector provides;
    private int packageCount;
    private final ByteVector packageIndex;
    private int mainClassIndex;

    /*
     * WARNING - void declaration
     */
    ModuleWriter(SymbolTable symbolTable, int name, int access, int version) {
        super(589824);
        void var3_3;
        void var2_2;
        void var1_1;
        this.symbolTable = var1_1;
        this.moduleNameIndex = var2_2;
        this.moduleFlags = var3_3;
        this.moduleVersionIndex = version;
        this.requires = new ByteVector();
        this.exports = new ByteVector();
        this.opens = new ByteVector();
        this.usesIndex = new ByteVector();
        this.provides = new ByteVector();
        this.packageIndex = new ByteVector();
    }

    /*
     * WARNING - void declaration
     */
    public final void visitMainClass(String mainClass) {
        void var1_1;
        this.mainClassIndex = this.symbolTable.addConstantClass((String)var1_1).index;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitPackage(String packaze) {
        void var1_1;
        this.packageIndex.putShort(this.symbolTable.addConstantPackage((String)var1_1).index);
        ++this.packageCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitRequire(String module, int access, String version) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.requires.putShort(this.symbolTable.addConstantModule((String)var1_1).index).putShort((int)var2_2).putShort(version == null ? 0 : this.symbolTable.addConstantUtf8((String)var3_3));
        ++this.requiresCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitExport(String packaze, int access, String ... modules) {
        int n;
        void var1_1;
        this.exports.putShort(this.symbolTable.addConstantPackage((String)var1_1).index).putShort(n);
        if (modules == null) {
            this.exports.putShort(0);
        } else {
            void var3_3;
            this.exports.putShort(modules.length);
            for (void module : var3_3) {
                this.exports.putShort(this.symbolTable.addConstantModule((String)module).index);
            }
        }
        ++this.exportsCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitOpen(String packaze, int access, String ... modules) {
        int n;
        void var1_1;
        this.opens.putShort(this.symbolTable.addConstantPackage((String)var1_1).index).putShort(n);
        if (modules == null) {
            this.opens.putShort(0);
        } else {
            void var3_3;
            this.opens.putShort(modules.length);
            for (void module : var3_3) {
                this.opens.putShort(this.symbolTable.addConstantModule((String)module).index);
            }
        }
        ++this.opensCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitUse(String service) {
        void var1_1;
        this.usesIndex.putShort(this.symbolTable.addConstantClass((String)var1_1).index);
        ++this.usesCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitProvide(String service, String ... providers) {
        void var2_2;
        void var1_1;
        this.provides.putShort(this.symbolTable.addConstantClass((String)var1_1).index);
        this.provides.putShort(providers.length);
        for (void provider : var2_2) {
            this.provides.putShort(this.symbolTable.addConstantClass((String)provider).index);
        }
        ++this.providesCount;
    }

    public final void visitEnd() {
    }

    final int getAttributeCount() {
        return 1 + (this.packageCount > 0 ? 1 : 0) + (this.mainClassIndex > 0 ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    final int computeAttributesSize() {
        void var1_1;
        this.symbolTable.addConstantUtf8("Module");
        int size = 22 + this.requires.length + this.exports.length + this.opens.length + this.usesIndex.length + this.provides.length;
        if (this.packageCount > 0) {
            this.symbolTable.addConstantUtf8("ModulePackages");
            size += 8 + this.packageIndex.length;
        }
        if (this.mainClassIndex > 0) {
            this.symbolTable.addConstantUtf8("ModuleMainClass");
            size += 8;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void putAttributes(ByteVector output) {
        void var2_2;
        int moduleAttributeLength = 16 + this.requires.length + this.exports.length + this.opens.length + this.usesIndex.length + this.provides.length;
        output.putShort(this.symbolTable.addConstantUtf8("Module")).putInt((int)var2_2).putShort(this.moduleNameIndex).putShort(this.moduleFlags).putShort(this.moduleVersionIndex).putShort(this.requiresCount).putByteArray(this.requires.data, 0, this.requires.length).putShort(this.exportsCount).putByteArray(this.exports.data, 0, this.exports.length).putShort(this.opensCount).putByteArray(this.opens.data, 0, this.opens.length).putShort(this.usesCount).putByteArray(this.usesIndex.data, 0, this.usesIndex.length).putShort(this.providesCount).putByteArray(this.provides.data, 0, this.provides.length);
        if (this.packageCount > 0) {
            output.putShort(this.symbolTable.addConstantUtf8("ModulePackages")).putInt(2 + this.packageIndex.length).putShort(this.packageCount).putByteArray(this.packageIndex.data, 0, this.packageIndex.length);
        }
        if (this.mainClassIndex > 0) {
            void var1_1;
            var1_1.putShort(this.symbolTable.addConstantUtf8("ModuleMainClass")).putInt(2).putShort(this.mainClassIndex);
        }
    }
}

