/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.DependenciesAccessors;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.DefaultDependencyAccessorsModel;
import org.jetbrains.plugins.gradle.model.DependencyAccessorsModel;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

public class DependencyAccessorsModelBuilder
implements ModelBuilderService {
    public boolean canBuild(String modelName) {
        return DependencyAccessorsModel.class.getName().equals(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"7.0") && project instanceof ProjectInternal) {
            try {
                DependenciesAccessors accessors = (DependenciesAccessors)((ProjectInternal)project).getServices().get(DependenciesAccessors.class);
                List<String> sources = accessors.getSources().getAsFiles().stream().map(Objects::toString).collect(Collectors.toList());
                List<String> classes = accessors.getClasses().getAsFiles().stream().map(Objects::toString).collect(Collectors.toList());
                return new DefaultDependencyAccessorsModel(sources, classes);
            }
            catch (ServiceLookupException | UnknownServiceException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            DependencyAccessorsModelBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DependencyAccessorsModelBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DependencyAccessorsModelBuilder.$$$reportNull$$$0(2);
        }
        if (exception == null) {
            DependencyAccessorsModelBuilder.$$$reportNull$$$0(3);
        }
        context.getMessageReporter().createMessage().withGroup("gradle.dependencyAccessorModel.group").withKind(Message.Kind.WARNING).withTitle("Cannot find dependency accessors").withText("Unable to build IntelliJ project settings").withException(exception).reportMessage(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "modelName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "exception";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/tooling/builder/DependencyAccessorsModelBuilder";
        objectArray[2] = "reportErrorMessage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

