/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.ui.graphics.Color;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.UIDefaults;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeKt;
import org.jetbrains.jewel.foundation.theme.ThemeColorPalette;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\n\u0010\b\u001a\u00020\u0005*\u00020\t\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u000f\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "windowsPopupBorder", "Landroidx/compose/ui/graphics/Color;", "Lorg/jetbrains/jewel/foundation/theme/ThemeColorPalette;", "getWindowsPopupBorder", "(Lorg/jetbrains/jewel/foundation/theme/ThemeColorPalette;)Landroidx/compose/ui/graphics/Color;", "readFromLaF", "Lorg/jetbrains/jewel/foundation/theme/ThemeColorPalette$Companion;", "readPaletteColors", "", "", "colorName", "readPaletteColor", "(Ljava/lang/String;)J", "intellij.platform.jewel.ideLafBridge"})
@SourceDebugExtension(value={"SMAP\nBridgeThemeColorPalette.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeThemeColorPalette.kt\norg/jetbrains/jewel/bridge/theme/BridgeThemeColorPaletteKt\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n*L\n1#1,87:1\n635#2:88\n*S KotlinDebug\n*F\n+ 1 BridgeThemeColorPalette.kt\norg/jetbrains/jewel/bridge/theme/BridgeThemeColorPaletteKt\n*L\n35#1:88\n*E\n"})
public final class BridgeThemeColorPaletteKt {
    @NotNull
    private static final Logger logger;

    @Nullable
    public static final Color getWindowsPopupBorder(@NotNull ThemeColorPalette $this$windowsPopupBorder) {
        Intrinsics.checkNotNullParameter((Object)$this$windowsPopupBorder, (String)"<this>");
        return $this$windowsPopupBorder.lookup-ijrfgN4("windowsPopupBorder");
    }

    @NotNull
    public static final ThemeColorPalette readFromLaF(@NotNull ThemeColorPalette.Companion $this$readFromLaF) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)$this$readFromLaF, (String)"<this>");
        Map<String, Color> gray = BridgeThemeColorPaletteKt.readPaletteColors("Gray");
        Map<String, Color> blue = BridgeThemeColorPaletteKt.readPaletteColors("Blue");
        Map<String, Color> green = BridgeThemeColorPaletteKt.readPaletteColors("Green");
        Map<String, Color> red = BridgeThemeColorPaletteKt.readPaletteColors("Red");
        Map<String, Color> yellow = BridgeThemeColorPaletteKt.readPaletteColors("Yellow");
        Map<String, Color> orange = BridgeThemeColorPaletteKt.readPaletteColors("Orange");
        Map<String, Color> purple = BridgeThemeColorPaletteKt.readPaletteColors("Purple");
        Map<String, Color> teal = BridgeThemeColorPaletteKt.readPaletteColors("Teal");
        long windowsPopupBorder = BridgeThemeColorPaletteKt.readPaletteColor("windowsPopupBorder");
        Map $this$readFromLaF_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$readFromLaF_u24lambda_u240.putAll(gray);
        $this$readFromLaF_u24lambda_u240.putAll(blue);
        $this$readFromLaF_u24lambda_u240.putAll(green);
        $this$readFromLaF_u24lambda_u240.putAll(red);
        $this$readFromLaF_u24lambda_u240.putAll(yellow);
        $this$readFromLaF_u24lambda_u240.putAll(orange);
        $this$readFromLaF_u24lambda_u240.putAll(purple);
        $this$readFromLaF_u24lambda_u240.putAll(teal);
        long l = windowsPopupBorder;
        boolean bl2 = false;
        if (l != 16L) {
            $this$readFromLaF_u24lambda_u240.put("windowsPopupBorder", Color.box-impl((long)windowsPopupBorder));
        }
        Map rawMap = MapsKt.build((Map)map);
        return new ThemeColorPalette(CollectionsKt.toList((Iterable)gray.values()), CollectionsKt.toList((Iterable)blue.values()), CollectionsKt.toList((Iterable)green.values()), CollectionsKt.toList((Iterable)red.values()), CollectionsKt.toList((Iterable)yellow.values()), CollectionsKt.toList((Iterable)orange.values()), CollectionsKt.toList((Iterable)purple.values()), CollectionsKt.toList((Iterable)teal.values()), rawMap);
    }

    private static final Map<String, Color> readPaletteColors(String colorName) {
        Map map;
        UIDefaults defaults = IntUiBridgeKt.getUiDefaults();
        Set set = defaults.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Set allKeys = set;
        String colorNameKeyPrefix = "ColorPalette." + colorName;
        int colorNameKeyPrefixLength = colorNameKeyPrefix.length();
        Integer n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)allKeys), String.class), arg_0 -> BridgeThemeColorPaletteKt.readPaletteColors$lambda$0(colorNameKeyPrefix, arg_0)), arg_0 -> BridgeThemeColorPaletteKt.readPaletteColors$lambda$1(colorNameKeyPrefixLength, arg_0)));
        if (n == null) {
            return new TreeMap();
        }
        int lastColorIndex = n;
        Map $this$readPaletteColors_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        int i = 1;
        if (i <= lastColorIndex) {
            while (true) {
                String key;
                Object object;
                java.awt.Color value;
                java.awt.Color color = value = (object = defaults.get(key = colorNameKeyPrefix + i)) instanceof java.awt.Color ? (java.awt.Color)object : null;
                if (value == null) {
                    logger.error("Unable to find color value for palette key '" + colorNameKeyPrefix + i + "'");
                } else {
                    $this$readPaletteColors_u24lambda_u242.put(key, Color.box-impl((long)BridgeUtilsKt.toComposeColor(value)));
                }
                if (i == lastColorIndex) break;
                ++i;
            }
        }
        return MapsKt.build((Map)map);
    }

    private static final long readPaletteColor(String colorName) {
        String colorNameKey;
        UIDefaults defaults = IntUiBridgeKt.getUiDefaults();
        Object object = defaults.get(colorNameKey = "ColorPalette." + colorName);
        java.awt.Color color = object instanceof java.awt.Color ? (java.awt.Color)object : null;
        return color != null ? BridgeUtilsKt.toComposeColor(color) : Color.Companion.getUnspecified-0d7_KjU();
    }

    private static final boolean readPaletteColors$lambda$0(String $colorNameKeyPrefix, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)$colorNameKeyPrefix, (boolean)false, (int)2, null);
    }

    private static final Integer readPaletteColors$lambda$1(int $colorNameKeyPrefixLength, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.substring($colorNameKeyPrefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String afterName = string;
        return StringsKt.toIntOrNull((String)afterName);
    }

    static {
        Logger logger = Logger.getInstance((String)"BridgeThemeColorPalette");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BridgeThemeColorPaletteKt.logger = logger;
    }
}

