/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;

public class ListeningCollection<T>
extends AbstractCollection<T> {
    private final List<T> base;
    private final Runnable runOnModification;

    public ListeningCollection(List<T> base, Runnable runOnModification) {
        this.base = base;
        this.runOnModification = runOnModification;
    }

    @Override
    public final Iterator<T> iterator() {
        final Iterator<T> it = this.base.iterator();
        return new Iterator<T>(){
            private T object;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                this.object = it.next();
                return this.object;
            }

            @Override
            public void remove() {
                if (this.object != null) {
                    ListeningCollection.this.removed(this.object);
                    this.object = null;
                }
                it.remove();
            }
        };
    }

    @Override
    public final int size() {
        return this.base.size();
    }

    @Override
    public final boolean remove(Object o) {
        boolean remove = this.base.remove(o);
        if (remove) {
            this.removed(o);
        }
        return remove;
    }

    @Override
    public final boolean add(T e) {
        boolean add = this.base.add(e);
        this.added(e);
        return add;
    }

    protected void removed(T object) {
        this.runOnModification.run();
    }

    protected void added(T object) {
        this.runOnModification.run();
    }
}

