/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;

final class P11DSAKeyFactory
extends P11KeyFactory {
    P11DSAKeyFactory(Token token, String string) {
        super(token, string);
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        try {
            if (publicKey instanceof java.security.interfaces.DSAPublicKey) {
                java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)publicKey;
                DSAParams dSAParams = dSAPublicKey.getParams();
                return this.generatePublic(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            }
            if ("X.509".equals(publicKey.getFormat())) {
                byte[] byArray = publicKey.getEncoded();
                publicKey = new DSAPublicKey(byArray);
                return this.implTranslatePublicKey(publicKey);
            }
            throw new InvalidKeyException("PublicKey must be instance of DSAPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create DSA public key", pKCS11Exception);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        try {
            if (privateKey instanceof java.security.interfaces.DSAPrivateKey) {
                java.security.interfaces.DSAPrivateKey dSAPrivateKey = (java.security.interfaces.DSAPrivateKey)privateKey;
                DSAParams dSAParams = dSAPrivateKey.getParams();
                return this.generatePrivate(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            }
            if ("PKCS#8".equals(privateKey.getFormat())) {
                byte[] byArray = privateKey.getEncoded();
                privateKey = new DSAPrivateKey(byArray);
                return this.implTranslatePrivateKey(privateKey);
            }
            throw new InvalidKeyException("PrivateKey must be instance of DSAPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create DSA private key", pKCS11Exception);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                DSAPublicKey dSAPublicKey = new DSAPublicKey(byArray);
                return this.implTranslatePublicKey(dSAPublicKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException("Could not create DSA public key", invalidKeyException);
            }
        }
        if (!(keySpec instanceof DSAPublicKeySpec)) {
            throw new InvalidKeySpecException("Only DSAPublicKeySpec and X509EncodedKeySpec supported for DSA public keys");
        }
        try {
            DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
            return this.generatePublic(dSAPublicKeySpec.getY(), dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create DSA public key", pKCS11Exception);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(byArray);
                return this.implTranslatePrivateKey(dSAPrivateKey);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidKeySpecException("Could not create DSA private key", generalSecurityException);
            }
        }
        if (!(keySpec instanceof DSAPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only DSAPrivateKeySpec and PKCS8EncodedKeySpec supported for DSA private keys");
        }
        try {
            DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
            return this.generatePrivate(dSAPrivateKeySpec.getX(), dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create DSA private key", pKCS11Exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 1L), new CK_ATTRIBUTE(17L, bigInteger), new CK_ATTRIBUTE(304L, bigInteger2), new CK_ATTRIBUTE(305L, bigInteger3), new CK_ATTRIBUTE(306L, bigInteger4)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 2L, 1L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PublicKey publicKey = P11Key.publicKey(session, l, "DSA", bigInteger2.bitLength(), cK_ATTRIBUTEArray);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 1L), new CK_ATTRIBUTE(17L, bigInteger), new CK_ATTRIBUTE(304L, bigInteger2), new CK_ATTRIBUTE(305L, bigInteger3), new CK_ATTRIBUTE(306L, bigInteger4)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 1L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PrivateKey privateKey = P11Key.privateKey(session, l, "DSA", bigInteger2.bitLength(), cK_ATTRIBUTEArray);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends KeySpec> T implGetPublicKeySpec(P11Key p11Key, Class<T> clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (clazz.isAssignableFrom(DSAPublicKeySpec.class)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(305L), new CK_ATTRIBUTE(306L)};
            long l = p11Key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(sessionArray[0].id(), l, cK_ATTRIBUTEArray);
            }
            finally {
                p11Key.releaseKeyID();
            }
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(cK_ATTRIBUTEArray[0].getBigInteger(), cK_ATTRIBUTEArray[1].getBigInteger(), cK_ATTRIBUTEArray[2].getBigInteger(), cK_ATTRIBUTEArray[3].getBigInteger());
            return (T)((KeySpec)clazz.cast(dSAPublicKeySpec));
        }
        throw new InvalidKeySpecException("Only DSAPublicKeySpec and X509EncodedKeySpec supported for DSA public keys");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends KeySpec> T implGetPrivateKeySpec(P11Key p11Key, Class<T> clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (clazz.isAssignableFrom(DSAPrivateKeySpec.class)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(305L), new CK_ATTRIBUTE(306L)};
            long l = p11Key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(sessionArray[0].id(), l, cK_ATTRIBUTEArray);
            }
            finally {
                p11Key.releaseKeyID();
            }
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(cK_ATTRIBUTEArray[0].getBigInteger(), cK_ATTRIBUTEArray[1].getBigInteger(), cK_ATTRIBUTEArray[2].getBigInteger(), cK_ATTRIBUTEArray[3].getBigInteger());
            return (T)((KeySpec)clazz.cast(dSAPrivateKeySpec));
        }
        throw new InvalidKeySpecException("Only DSAPrivateKeySpec and PKCS8EncodedKeySpec supported for DSA private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return KeyFactory.getInstance("DSA", P11Util.getSunProvider());
    }
}

