/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import java.util.Arrays;
import java.util.Objects;

public enum TransactionConfirmationDisplay {
    ANY(1, "any"),
    PRIVILEGED_SOFTWARE(2, "privileged_software"),
    TEE(4, "tee"),
    HARDWARE(8, "hardware"),
    REMOTE(16, "remote");

    private static final String VALUE_OUT_OF_RANGE_TEMPLATE = "value %s is out of range";
    private final int value;
    private final String string;

    private TransactionConfirmationDisplay(int value, String string2) {
        this.value = value;
        this.string = string2;
    }

    public static TransactionConfirmationDisplay create(String value) {
        return Arrays.stream(TransactionConfirmationDisplay.values()).filter(item -> Objects.equals(item.string, value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public static TransactionConfirmationDisplay create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value));
        }
        return Arrays.stream(TransactionConfirmationDisplay.values()).filter(item -> item.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.string;
    }
}

