/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class BaseMaterialGroup extends Resource {

	public BaseMaterialGroup(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the count of base materials in the material group.
	 *
	 * @return returns the count of base materials.
	 * @throws Lib3MFException
	 */
	public int getCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_getcount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * returns all the PropertyIDs of all materials in this group
	 *
	 * @return PropertyID of the material in the material group.
	 * @throws Lib3MFException
	 */
	public int[] getAllPropertyIDs() throws Lib3MFException {
		Pointer countNeededPropertyIDs = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_getallpropertyids.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededPropertyIDs, Pointer.NULL}));
		long countPropertyIDs = countNeededPropertyIDs.getLong(0);
		Pointer bufferPropertyIDs = new Memory(Math.max(1, 4 * countPropertyIDs));
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_getallpropertyids.invokeInt(new java.lang.Object[]{mHandle, countPropertyIDs, countNeededPropertyIDs, bufferPropertyIDs}));
		return bufferPropertyIDs.getIntArray(0, (int)countPropertyIDs);
	}

	/**
	 * Adds a new material to the material group
	 *
	 * @param name new name of the base material.
	 * @param displayColor Display color of the material
	 * @return returns new PropertyID of the new material in the material group.
	 * @throws Lib3MFException
	 */
	public int addMaterial(String name, Color displayColor) throws Lib3MFException {
		byte[] bytesName = name.getBytes(StandardCharsets.UTF_8);
		Memory bufferName = new Memory(bytesName.length + 1);
		bufferName.write(0, bytesName, 0, bytesName.length);
		bufferName.setByte(bytesName.length, (byte)0);
		Pointer bufferDisplayColor = new Memory(Color.SIZE);
		displayColor.writeToPointer(bufferDisplayColor, 0);
		Pointer bufferPropertyID = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_addmaterial.invokeInt(new java.lang.Object[]{mHandle, bufferName, bufferDisplayColor, bufferPropertyID}));
		return bufferPropertyID.getInt(0);
	}

	/**
	 * Removes a material from the material group.
	 *
	 * @param propertyID PropertyID of the material in the material group.
	 * @throws Lib3MFException
	 */
	public void removeMaterial(int propertyID) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_removematerial.invokeInt(new java.lang.Object[]{mHandle, propertyID}));
	}

	/**
	 * Returns the base material's name
	 *
	 * @param propertyID PropertyID of the material in the material group.
	 * @return returns the name of the base material.
	 * @throws Lib3MFException
	 */
	public String getName(int propertyID) throws Lib3MFException {
		Pointer bytesNeededName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_getname.invokeInt(new java.lang.Object[]{mHandle, propertyID, 0, bytesNeededName, null}));
		int sizeName = bytesNeededName.getInt(0);
		Pointer bufferName = new Memory(sizeName);
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_getname.invokeInt(new java.lang.Object[]{mHandle, propertyID, sizeName, bytesNeededName, bufferName}));
		return new String(bufferName.getByteArray(0, sizeName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets a base material's name
	 *
	 * @param propertyID PropertyID of the material in the material group.
	 * @param name new name of the base material.
	 * @throws Lib3MFException
	 */
	public void setName(int propertyID, String name) throws Lib3MFException {
		byte[] bytesName = name.getBytes(StandardCharsets.UTF_8);
		Memory bufferName = new Memory(bytesName.length + 1);
		bufferName.write(0, bytesName, 0, bytesName.length);
		bufferName.setByte(bytesName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_setname.invokeInt(new java.lang.Object[]{mHandle, propertyID, bufferName}));
	}

	/**
	 * Sets a base material's display color.
	 *
	 * @param propertyID PropertyID of the material in the material group.
	 * @param theColor The base material's display color
	 * @throws Lib3MFException
	 */
	public void setDisplayColor(int propertyID, Color theColor) throws Lib3MFException {
		Pointer bufferTheColor = new Memory(Color.SIZE);
		theColor.writeToPointer(bufferTheColor, 0);
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_setdisplaycolor.invokeInt(new java.lang.Object[]{mHandle, propertyID, bufferTheColor}));
	}

	/**
	 * Returns a base material's display color.
	 *
	 * @param propertyID PropertyID of the material in the material group.
	 * @return The base material's display color
	 * @throws Lib3MFException
	 */
	public Color getDisplayColor(int propertyID) throws Lib3MFException {
		Pointer bufferTheColor = new Memory(Color.SIZE);
		mWrapper.checkError(this, mWrapper.lib3mf_basematerialgroup_getdisplaycolor.invokeInt(new java.lang.Object[]{mHandle, propertyID, bufferTheColor}));
		Color theColor = new Color();
		theColor.readFromPointer(bufferTheColor, 0);
		return theColor;
	}


}

