/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import mediathek.controller.history.SeenHistoryController;
import mediathek.mainwindow.MediathekGui;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptimizeHistoryDbAction
extends AbstractAction {
    private final MediathekGui mediathekGui;
    private static final Logger logger = LogManager.getLogger();

    public OptimizeHistoryDbAction(MediathekGui mediathekGui) {
        this.mediathekGui = mediathekGui;
        this.putValue("Name", "History-Datenbank optimieren...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try (SeenHistoryController controller = new SeenHistoryController();){
            SeenHistoryController.DuplicateSearchResult dupes = controller.checkDuplicates();
            long numDuplicates = dupes.total() - dupes.distinct();
            logger.trace("{} duplicates found in history", (Object)numDuplicates);
            if (numDuplicates == 0L) {
                String msg = "Es sind keine Duplikate vorhanden.\nEine Optimierung ist nicht notwendig.";
                JOptionPane.showMessageDialog(this.mediathekGui, msg, "MediathekView", 1);
            } else {
                String msg = String.format("Es wurden %d Duplikate gefunden.\nM\u00f6chten Sie diese bereinigen?", numDuplicates);
                int answer = JOptionPane.showOptionDialog(this.mediathekGui, msg, "MediathekView", 0, 3, null, null, null);
                if (answer == 0) {
                    controller.removeDuplicates();
                    dupes = controller.checkDuplicates();
                    numDuplicates = dupes.total() - dupes.distinct();
                    logger.trace("{} duplicates found in history after cleanup", (Object)numDuplicates);
                    msg = String.format("Datenbank wurde bereinigt.\n%d Duplikate blieben \u00fcbrig.", numDuplicates);
                    JOptionPane.showMessageDialog(this.mediathekGui, msg, "MediathekView", 1);
                }
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.mediathekGui, ex.getMessage(), "MediathekView", 0);
        }
    }
}

