/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cache.common.policy;

import java.util.function.Function;
import java.util.function.Predicate;
import org.opensearch.common.cache.policy.CachedQueryResult;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;

public class TookTimePolicy<V>
implements Predicate<V> {
    private TimeValue threshold;
    private final Function<V, CachedQueryResult.PolicyValues> cachedResultParser;

    public TookTimePolicy(TimeValue threshold, Function<V, CachedQueryResult.PolicyValues> cachedResultParser, ClusterSettings clusterSettings, Setting<TimeValue> targetSetting) {
        if (threshold.compareTo(TimeValue.ZERO) < 0) {
            throw new IllegalArgumentException("Threshold for TookTimePolicy must be >= 0ms but was " + threshold.getStringRep());
        }
        this.threshold = threshold;
        this.cachedResultParser = cachedResultParser;
        clusterSettings.addSettingsUpdateConsumer(targetSetting, this::setThreshold);
    }

    private void setThreshold(TimeValue threshold) {
        this.threshold = threshold;
    }

    @Override
    public boolean test(V data) {
        long tookTimeNanos;
        if (this.threshold.equals((Object)TimeValue.ZERO)) {
            return true;
        }
        try {
            tookTimeNanos = this.cachedResultParser.apply(data).getTookTimeNanos();
        }
        catch (Exception e) {
            return false;
        }
        TimeValue tookTime = TimeValue.timeValueNanos((long)tookTimeNanos);
        return tookTime.compareTo(this.threshold) >= 0;
    }
}

