/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.Version;
import org.opensearch.common.annotation.DeprecatedApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class IndexingStats
implements Writeable,
ToXContentFragment {
    private final Stats totalStats;

    public IndexingStats() {
        this.totalStats = new Stats();
    }

    public IndexingStats(StreamInput in) throws IOException {
        this.totalStats = new Stats(in);
        if (in.getVersion().before(Version.V_2_0_0) && in.readBoolean()) {
            Map typeStats = in.readMap(StreamInput::readString, Stats::new);
            assert (typeStats.size() == 1);
            assert (typeStats.containsKey("_doc"));
        }
    }

    public IndexingStats(Stats totalStats) {
        this.totalStats = totalStats;
    }

    public void add(IndexingStats indexingStats) {
        if (indexingStats == null) {
            return;
        }
        this.addTotals(indexingStats);
    }

    public void addTotals(IndexingStats indexingStats) {
        if (indexingStats == null) {
            return;
        }
        this.totalStats.add(indexingStats.totalStats);
    }

    public Stats getTotal() {
        return this.totalStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("indexing");
        this.totalStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeBoolean(false);
        }
    }

    @PublicApi(since="1.0.0")
    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private long indexCount;
        private long indexTimeInMillis;
        private long indexCurrent;
        private long indexFailedCount;
        private long deleteCount;
        private long deleteTimeInMillis;
        private long deleteCurrent;
        private long noopUpdateCount;
        private long throttleTimeInMillis;
        private boolean isThrottled;
        private final DocStatusStats docStatusStats;
        private long maxLastIndexRequestTimestamp;

        Stats() {
            this.docStatusStats = null;
        }

        private Stats(Builder builder) {
            this.indexCount = builder.indexCount;
            this.indexTimeInMillis = builder.indexTimeInMillis;
            this.indexCurrent = builder.indexCurrent;
            this.indexFailedCount = builder.indexFailedCount;
            this.deleteCount = builder.deleteCount;
            this.deleteTimeInMillis = builder.deleteTimeInMillis;
            this.deleteCurrent = builder.deleteCurrent;
            this.noopUpdateCount = builder.noopUpdateCount;
            this.throttleTimeInMillis = builder.throttleTimeInMillis;
            this.isThrottled = builder.isThrottled;
            this.docStatusStats = builder.docStatusStats;
            this.maxLastIndexRequestTimestamp = builder.maxLastIndexRequestTimestamp;
        }

        public Stats(StreamInput in) throws IOException {
            this.indexCount = in.readVLong();
            this.indexTimeInMillis = in.readVLong();
            this.indexCurrent = in.readVLong();
            this.indexFailedCount = in.readVLong();
            this.deleteCount = in.readVLong();
            this.deleteTimeInMillis = in.readVLong();
            this.deleteCurrent = in.readVLong();
            this.noopUpdateCount = in.readVLong();
            this.isThrottled = in.readBoolean();
            this.throttleTimeInMillis = in.readLong();
            this.maxLastIndexRequestTimestamp = in.getVersion().onOrAfter(Version.V_3_2_0) ? in.readLong() : 0L;
            this.docStatusStats = in.getVersion().onOrAfter(Version.V_2_11_0) && in.getVersion().before(Version.V_3_4_0) ? (DocStatusStats)in.readOptionalWriteable(DocStatusStats::new) : null;
        }

        @Deprecated(since="3.4.0")
        public Stats(long indexCount, long indexTimeInMillis, long indexCurrent, long indexFailedCount, long deleteCount, long deleteTimeInMillis, long deleteCurrent, long noopUpdateCount, boolean isThrottled, long throttleTimeInMillis, DocStatusStats docStatusStats) {
            this(indexCount, indexTimeInMillis, indexCurrent, indexFailedCount, deleteCount, deleteTimeInMillis, deleteCurrent, noopUpdateCount, isThrottled, throttleTimeInMillis, docStatusStats, 0L);
        }

        @Deprecated(since="3.4.0")
        public Stats(long indexCount, long indexTimeInMillis, long indexCurrent, long indexFailedCount, long deleteCount, long deleteTimeInMillis, long deleteCurrent, long noopUpdateCount, boolean isThrottled, long throttleTimeInMillis, DocStatusStats docStatusStats, long maxLastIndexRequestTimestamp) {
            this.indexCount = indexCount;
            this.indexTimeInMillis = indexTimeInMillis;
            this.indexCurrent = indexCurrent;
            this.indexFailedCount = indexFailedCount;
            this.deleteCount = deleteCount;
            this.deleteTimeInMillis = deleteTimeInMillis;
            this.deleteCurrent = deleteCurrent;
            this.noopUpdateCount = noopUpdateCount;
            this.isThrottled = isThrottled;
            this.throttleTimeInMillis = throttleTimeInMillis;
            this.docStatusStats = docStatusStats;
            this.maxLastIndexRequestTimestamp = maxLastIndexRequestTimestamp;
        }

        public void add(Stats stats) {
            this.indexCount += stats.indexCount;
            this.indexTimeInMillis += stats.indexTimeInMillis;
            this.indexCurrent += stats.indexCurrent;
            this.indexFailedCount += stats.indexFailedCount;
            this.deleteCount += stats.deleteCount;
            this.deleteTimeInMillis += stats.deleteTimeInMillis;
            this.deleteCurrent += stats.deleteCurrent;
            this.noopUpdateCount += stats.noopUpdateCount;
            this.throttleTimeInMillis += stats.throttleTimeInMillis;
            this.isThrottled |= stats.isThrottled;
            if (this.getDocStatusStats() != null) {
                this.getDocStatusStats().add(stats.getDocStatusStats());
            }
            this.maxLastIndexRequestTimestamp = Math.max(this.maxLastIndexRequestTimestamp, stats.maxLastIndexRequestTimestamp);
        }

        public long getIndexCount() {
            return this.indexCount;
        }

        public long getIndexFailedCount() {
            return this.indexFailedCount;
        }

        public TimeValue getIndexTime() {
            return new TimeValue(this.indexTimeInMillis);
        }

        public long getIndexCurrent() {
            return this.indexCurrent;
        }

        public long getDeleteCount() {
            return this.deleteCount;
        }

        public boolean isThrottled() {
            return this.isThrottled;
        }

        public TimeValue getThrottleTime() {
            return new TimeValue(this.throttleTimeInMillis);
        }

        public TimeValue getDeleteTime() {
            return new TimeValue(this.deleteTimeInMillis);
        }

        public long getDeleteCurrent() {
            return this.deleteCurrent;
        }

        public long getNoopUpdateCount() {
            return this.noopUpdateCount;
        }

        public DocStatusStats getDocStatusStats() {
            return this.docStatusStats;
        }

        public long getMaxLastIndexRequestTimestamp() {
            return this.maxLastIndexRequestTimestamp;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.indexCount);
            out.writeVLong(this.indexTimeInMillis);
            out.writeVLong(this.indexCurrent);
            out.writeVLong(this.indexFailedCount);
            out.writeVLong(this.deleteCount);
            out.writeVLong(this.deleteTimeInMillis);
            out.writeVLong(this.deleteCurrent);
            out.writeVLong(this.noopUpdateCount);
            out.writeBoolean(this.isThrottled);
            out.writeLong(this.throttleTimeInMillis);
            if (out.getVersion().onOrAfter(Version.V_3_2_0)) {
                out.writeLong(this.maxLastIndexRequestTimestamp);
            }
            if (out.getVersion().onOrAfter(Version.V_2_11_0) && out.getVersion().before(Version.V_3_4_0)) {
                out.writeOptionalWriteable((Writeable)this.docStatusStats);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("index_total", this.indexCount);
            builder.humanReadableField("index_time_in_millis", "index_time", (Object)this.getIndexTime());
            builder.field("index_current", this.indexCurrent);
            builder.field("index_failed", this.indexFailedCount);
            builder.field("delete_total", this.deleteCount);
            builder.humanReadableField("delete_time_in_millis", "delete_time", (Object)this.getDeleteTime());
            builder.field("delete_current", this.deleteCurrent);
            builder.field("noop_update_total", this.noopUpdateCount);
            builder.field("is_throttled", this.isThrottled);
            builder.humanReadableField("throttle_time_in_millis", "throttle_time", (Object)this.getThrottleTime());
            if (this.getDocStatusStats() != null) {
                this.getDocStatusStats().toXContent(builder, params);
            }
            builder.field("max_last_index_request_timestamp", this.maxLastIndexRequestTimestamp);
            return builder;
        }

        @PublicApi(since="1.0.0")
        @DeprecatedApi(since="3.4.0")
        public static class DocStatusStats
        implements Writeable,
        ToXContentFragment {
            final AtomicLong[] docStatusCounter;

            public DocStatusStats() {
                this.docStatusCounter = new AtomicLong[5];
                for (int i = 0; i < this.docStatusCounter.length; ++i) {
                    this.docStatusCounter[i] = new AtomicLong(0L);
                }
            }

            public DocStatusStats(StreamInput in) throws IOException {
                this.docStatusCounter = (AtomicLong[])in.readArray(i -> new AtomicLong(i.readLong()), AtomicLong[]::new);
                assert (this.docStatusCounter.length == 5) : "Length of incoming array should be 5! Got " + this.docStatusCounter.length;
            }

            public void inc(RestStatus status) {
                this.add(status, 1L);
            }

            void add(RestStatus status, long delta) {
                this.docStatusCounter[status.getStatusFamilyCode() - 1].addAndGet(delta);
            }

            public void add(DocStatusStats stats) {
                if (null == stats) {
                    return;
                }
                for (int i = 0; i < this.docStatusCounter.length; ++i) {
                    this.docStatusCounter[i].addAndGet(stats.docStatusCounter[i].longValue());
                }
            }

            public AtomicLong[] getDocStatusCounter() {
                return this.docStatusCounter;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject("doc_status");
                for (int i = 0; i < this.docStatusCounter.length; ++i) {
                    long value = this.docStatusCounter[i].longValue();
                    if (value <= 0L) continue;
                    String key = i + 1 + "xx";
                    builder.field(key, value);
                }
                return builder.endObject();
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeArray((o, v) -> o.writeLong(v.longValue()), (Object[])this.docStatusCounter);
            }
        }

        public static class Builder {
            private long indexCount = 0L;
            private long indexTimeInMillis = 0L;
            private long indexCurrent = 0L;
            private long indexFailedCount = 0L;
            private long deleteCount = 0L;
            private long deleteTimeInMillis = 0L;
            private long deleteCurrent = 0L;
            private long noopUpdateCount = 0L;
            private long throttleTimeInMillis = 0L;
            private boolean isThrottled = false;
            private DocStatusStats docStatusStats = null;
            private long maxLastIndexRequestTimestamp = 0L;

            public Builder indexCount(long count) {
                this.indexCount = count;
                return this;
            }

            public Builder indexTimeInMillis(long time) {
                this.indexTimeInMillis = time;
                return this;
            }

            public Builder indexCurrent(long current) {
                this.indexCurrent = current;
                return this;
            }

            public Builder indexFailedCount(long count) {
                this.indexFailedCount = count;
                return this;
            }

            public Builder deleteCount(long count) {
                this.deleteCount = count;
                return this;
            }

            public Builder deleteTimeInMillis(long time) {
                this.deleteTimeInMillis = time;
                return this;
            }

            public Builder deleteCurrent(long current) {
                this.deleteCurrent = current;
                return this;
            }

            public Builder noopUpdateCount(long count) {
                this.noopUpdateCount = count;
                return this;
            }

            public Builder throttleTimeInMillis(long time) {
                this.throttleTimeInMillis = time;
                return this;
            }

            public Builder isThrottled(boolean throttled) {
                this.isThrottled = throttled;
                return this;
            }

            public Builder docStatusStats(DocStatusStats stats) {
                this.docStatusStats = stats;
                return this;
            }

            public Builder maxLastIndexRequestTimestamp(long timestamp) {
                this.maxLastIndexRequestTimestamp = timestamp;
                return this;
            }

            public Stats build() {
                return new Stats(this);
            }
        }
    }

    private static final class Fields {
        static final String INDEXING = "indexing";
        static final String INDEX_TOTAL = "index_total";
        static final String INDEX_TIME = "index_time";
        static final String INDEX_TIME_IN_MILLIS = "index_time_in_millis";
        static final String INDEX_CURRENT = "index_current";
        static final String INDEX_FAILED = "index_failed";
        static final String DELETE_TOTAL = "delete_total";
        static final String DELETE_TIME = "delete_time";
        static final String DELETE_TIME_IN_MILLIS = "delete_time_in_millis";
        static final String DELETE_CURRENT = "delete_current";
        static final String NOOP_UPDATE_TOTAL = "noop_update_total";
        static final String IS_THROTTLED = "is_throttled";
        static final String THROTTLED_TIME_IN_MILLIS = "throttle_time_in_millis";
        static final String THROTTLED_TIME = "throttle_time";
        static final String DOC_STATUS = "doc_status";
        static final String MAX_LAST_INDEX_REQUEST_TIMESTAMP = "max_last_index_request_timestamp";

        private Fields() {
        }
    }
}

