/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.lang;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.lang.LangSpec;

public class PPLLangSpec
implements LangSpec {
    public static final PPLLangSpec PPL_SPEC = new PPLLangSpec();
    private static Map<ExprType, String> exprTypeToPPLType = new HashMap<ExprType, String>();

    private PPLLangSpec() {
    }

    @Override
    public QueryType language() {
        return QueryType.PPL;
    }

    @Override
    public String typeName(ExprType exprType) {
        return exprTypeToPPLType.getOrDefault(exprType, exprType.typeName());
    }

    static {
        exprTypeToPPLType.put(ExprCoreType.BYTE, "tinyint");
        exprTypeToPPLType.put(ExprCoreType.SHORT, "smallint");
        exprTypeToPPLType.put(ExprCoreType.INTEGER, "int");
        exprTypeToPPLType.put(ExprCoreType.LONG, "bigint");
    }
}

