/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleSpace
implements Command {
    private static final Pattern2 pattern = Pattern2.cmpile("^(\\<space:(\\d+)/?\\>)");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleSpace() {
    }

    public static Command create() {
        return new CommandCreoleSpace();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        int size = Integer.parseInt(m.group(2));
        stripe.addSpace(size);
        return line.substring(m.group(1).length());
    }
}

