/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegmentDependency;

public final class HyperEdgeCycleDetector {
    private HyperEdgeCycleDetector() {
        assert (false);
    }

    public static List<HyperEdgeSegmentDependency> detectCycles(List<HyperEdgeSegment> segments, boolean criticalOnly, Random random) {
        ArrayList<HyperEdgeSegmentDependency> result = new ArrayList<HyperEdgeSegmentDependency>();
        LinkedList<HyperEdgeSegment> sources = Lists.newLinkedList();
        LinkedList<HyperEdgeSegment> sinks = Lists.newLinkedList();
        HyperEdgeCycleDetector.initialize(segments, sources, sinks, criticalOnly);
        HyperEdgeCycleDetector.computeLinearOrderingMarks(segments, sources, sinks, criticalOnly, random);
        for (HyperEdgeSegment source : segments) {
            for (HyperEdgeSegmentDependency outDependency : source.getOutgoingSegmentDependencies()) {
                if (criticalOnly && outDependency.getType() != HyperEdgeSegmentDependency.DependencyType.CRITICAL || source.mark <= outDependency.getTarget().mark) continue;
                result.add(outDependency);
            }
        }
        return result;
    }

    private static void initialize(List<HyperEdgeSegment> segments, List<HyperEdgeSegment> sources, List<HyperEdgeSegment> sinks, boolean criticalOnly) {
        int nextMark = -1;
        for (HyperEdgeSegment segment : segments) {
            segment.mark = nextMark--;
            int criticalInWeight = segment.getIncomingSegmentDependencies().stream().filter(dep -> dep.getType() == HyperEdgeSegmentDependency.DependencyType.CRITICAL).mapToInt(dep -> dep.getWeight()).sum();
            int criticalOutWeight = segment.getOutgoingSegmentDependencies().stream().filter(dep -> dep.getType() == HyperEdgeSegmentDependency.DependencyType.CRITICAL).mapToInt(dep -> dep.getWeight()).sum();
            int inWeight = criticalInWeight;
            int outWeight = criticalOutWeight;
            if (!criticalOnly) {
                inWeight = segment.getIncomingSegmentDependencies().stream().mapToInt(dep -> dep.getWeight()).sum();
                outWeight = segment.getOutgoingSegmentDependencies().stream().mapToInt(dep -> dep.getWeight()).sum();
            }
            segment.setInWeight(inWeight);
            segment.setCriticalInWeight(criticalInWeight);
            segment.setOutWeight(outWeight);
            segment.setCriticalOutWeight(criticalOutWeight);
            if (outWeight == 0) {
                sinks.add(segment);
                continue;
            }
            if (inWeight != 0) continue;
            sources.add(segment);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void computeLinearOrderingMarks(List<HyperEdgeSegment> segments, LinkedList<HyperEdgeSegment> sources, LinkedList<HyperEdgeSegment> sinks, boolean criticalOnly, Random random) {
        unprocessed = Sets.newTreeSet(segments);
        maxSegments = new ArrayList<HyperEdgeSegment>();
        markBase = segments.size();
        nextSinkMark = markBase - 1;
        nextSourceMark = markBase + 1;
        ** GOTO lbl43
        {
            sink = sinks.removeFirst();
            unprocessed.remove(sink);
            sink.mark = nextSinkMark--;
            HyperEdgeCycleDetector.updateNeighbors(sink, sources, sinks, criticalOnly);
            do {
                if (!sinks.isEmpty()) continue block0;
                while (!sources.isEmpty()) {
                    source = sources.removeFirst();
                    unprocessed.remove(source);
                    source.mark = nextSourceMark++;
                    HyperEdgeCycleDetector.updateNeighbors(source, sources, sinks, criticalOnly);
                }
                maxOutflow = -2147483648;
                for (HyperEdgeSegment segment : unprocessed) {
                    if (!criticalOnly && segment.getCriticalOutWeight() > 0 && segment.getCriticalInWeight() <= 0) {
                        maxSegments.clear();
                        maxSegments.add(segment);
                        break;
                    }
                    outflow = segment.getOutWeight() - segment.getInWeight();
                    if (outflow < maxOutflow) continue;
                    if (outflow > maxOutflow) {
                        maxSegments.clear();
                        maxOutflow = outflow;
                    }
                    maxSegments.add(segment);
                }
                if (maxSegments.isEmpty()) continue;
                maxNode = (HyperEdgeSegment)maxSegments.get(random.nextInt(maxSegments.size()));
                unprocessed.remove(maxNode);
                maxNode.mark = nextSourceMark++;
                HyperEdgeCycleDetector.updateNeighbors(maxNode, sources, sinks, criticalOnly);
                maxSegments.clear();
lbl43:
                // 3 sources

            } while (!unprocessed.isEmpty());
        }
        shiftBase = segments.size() + 1;
        for (HyperEdgeSegment node : segments) {
            if (node.mark >= markBase) continue;
            node.mark += shiftBase;
        }
    }

    private static void updateNeighbors(HyperEdgeSegment node, List<HyperEdgeSegment> sources, List<HyperEdgeSegment> sinks, boolean criticalOnly) {
        for (HyperEdgeSegmentDependency dep : node.getOutgoingSegmentDependencies()) {
            if (criticalOnly && dep.getType() != HyperEdgeSegmentDependency.DependencyType.CRITICAL) continue;
            HyperEdgeSegment target = dep.getTarget();
            if (target.mark >= 0 || dep.getWeight() <= 0) continue;
            target.setInWeight(target.getInWeight() - dep.getWeight());
            if (dep.getType() == HyperEdgeSegmentDependency.DependencyType.CRITICAL) {
                target.setCriticalInWeight(target.getCriticalInWeight() - dep.getWeight());
            }
            if (target.getInWeight() > 0 || target.getOutWeight() <= 0) continue;
            sources.add(target);
        }
        for (HyperEdgeSegmentDependency dep : node.getIncomingSegmentDependencies()) {
            if (criticalOnly && dep.getType() != HyperEdgeSegmentDependency.DependencyType.CRITICAL) continue;
            HyperEdgeSegment source = dep.getSource();
            if (source.mark >= 0 || dep.getWeight() <= 0) continue;
            source.setOutWeight(source.getOutWeight() - dep.getWeight());
            if (dep.getType() == HyperEdgeSegmentDependency.DependencyType.CRITICAL) {
                source.setCriticalOutWeight(source.getCriticalOutWeight() - dep.getWeight());
            }
            if (source.getOutWeight() > 0 || source.getInWeight() <= 0) continue;
            sinks.add(source);
        }
    }
}

