/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.HashUtil;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.Preconditions;

abstract class XXH3Base
implements AbstractHasher64 {
    protected static final int BLOCK_LEN_EXP = 10;
    protected static final long SECRET_00 = -4734510112055689544L;
    protected static final long SECRET_01 = 2066345149520216444L;
    protected static final long SECRET_02 = -2623469361688619810L;
    protected static final long SECRET_03 = 2262974939099578482L;
    protected static final long SECRET_04 = 8711581037947681227L;
    protected static final long SECRET_05 = 2410270004345854594L;
    protected static final long SECRET_06 = -8204357891075471176L;
    protected static final long SECRET_07 = 5487137525590930912L;
    protected static final long SECRET_08 = -3818837453329782724L;
    protected static final long SECRET_09 = -6688317018830679928L;
    protected static final long SECRET_10 = 5690594596133299313L;
    protected static final long SECRET_11 = -2833645246901970632L;
    protected static final long SECRET_12 = 4554437623014685352L;
    protected static final long SECRET_13 = 2111919702937427193L;
    protected static final long SECRET_14 = 3556072174620004746L;
    protected static final long SECRET_15 = 7238261902898274248L;
    protected static final long SECRET_16 = -4329134394285701654L;
    protected static final long SECRET_17 = -1485321483350670907L;
    protected static final long SECRET_18 = 5321830579834785047L;
    protected static final long SECRET_19 = -7032137544937171245L;
    protected static final long SECRET_20 = -242834301215959509L;
    protected static final long SECRET_21 = -3588858202114426737L;
    protected static final long SECRET_22 = 2883454493032893253L;
    protected static final long SECRET_23 = 9097354517224871855L;
    protected static final long INIT_ACC_0 = 3266489917L;
    protected static final long INIT_ACC_1 = -7046029288634856825L;
    protected static final long INIT_ACC_2 = -4417276706812531889L;
    protected static final long INIT_ACC_3 = 1609587929392839161L;
    protected static final long INIT_ACC_4 = -8796714831421723037L;
    protected static final long INIT_ACC_5 = 2246822519L;
    protected static final long INIT_ACC_6 = 2870177450012600261L;
    protected static final long INIT_ACC_7 = 2654435761L;
    protected final long[] secret;
    protected final long[] secShift;
    protected final long secShiftFinalA0;
    protected final long secShiftFinalA1;
    protected final long secShiftFinalA2;
    protected final long secShiftFinalA3;
    protected final long secShiftFinalA4;
    protected final long secShiftFinalA5;
    protected final long secShiftFinalA6;
    protected final long secShiftFinalA7;
    protected final long secShiftFinalB0;
    protected final long secShiftFinalB1;
    protected final long secShiftFinalB2;
    protected final long secShiftFinalB3;
    protected final long secShiftFinalB4;
    protected final long secShiftFinalB5;
    protected final long secShiftFinalB6;
    protected final long secShiftFinalB7;
    protected final long bitflip00;

    protected XXH3Base(long seed, boolean is128) {
        this.secret = new long[]{-4734510112055689544L + seed, 2066345149520216444L - seed, -2623469361688619810L + seed, 2262974939099578482L - seed, 8711581037947681227L + seed, 2410270004345854594L - seed, -8204357891075471176L + seed, 5487137525590930912L - seed, -3818837453329782724L + seed, -6688317018830679928L - seed, 5690594596133299313L + seed, -2833645246901970632L - seed, 4554437623014685352L + seed, 2111919702937427193L - seed, 3556072174620004746L + seed, 7238261902898274248L - seed, -4329134394285701654L + seed, -1485321483350670907L - seed, 5321830579834785047L + seed, -7032137544937171245L - seed, -242834301215959509L + seed, -3588858202114426737L - seed, 2883454493032893253L + seed, 9097354517224871855L - seed};
        this.secShift = new long[16];
        this.secShift[0] = -9150895811085458631L + seed;
        this.secShift[1] = 7914194659941938988L - seed;
        this.secShift[2] = -6611157965513653271L + seed;
        this.secShift[3] = -1839215637059881052L - seed;
        this.secShift[4] = -3433288310154277810L + seed;
        this.secShift[5] = 5046485836271438973L - seed;
        this.secShift[6] = -8055285457383852172L + seed;
        this.secShift[7] = 5920048007935066598L - seed;
        this.secShift[8] = 7336514198459093435L + seed;
        this.secShift[9] = 5216419214072683403L - seed;
        this.secShift[10] = -1217880312389983593L + seed;
        this.secShift[11] = 8573350489219836230L - seed;
        if (is128) {
            this.secShift[12] = 5695865814404364607L - seed;
            this.secShift[13] = 6464017090953185821L + seed;
            this.secShift[14] = 8320639771003045937L - seed;
            this.secShift[15] = -1453760514566526364L + seed;
        } else {
            this.secShift[12] = -4909775443879730369L + seed;
            this.secShift[13] = -2282891677615274041L - seed;
            this.secShift[14] = 8320639771003045937L + seed;
            this.secShift[15] = -1453760514566526364L - seed;
        }
        this.secShiftFinalA0 = this.secret[15] >>> 8 | this.secret[16] << 56;
        this.secShiftFinalA1 = this.secret[16] >>> 8 | this.secret[17] << 56;
        this.secShiftFinalA2 = this.secret[17] >>> 8 | this.secret[18] << 56;
        this.secShiftFinalA3 = this.secret[18] >>> 8 | this.secret[19] << 56;
        this.secShiftFinalA4 = this.secret[19] >>> 8 | this.secret[20] << 56;
        this.secShiftFinalA5 = this.secret[20] >>> 8 | this.secret[21] << 56;
        this.secShiftFinalA6 = this.secret[21] >>> 8 | this.secret[22] << 56;
        this.secShiftFinalA7 = this.secret[22] >>> 8 | this.secret[23] << 56;
        this.secShiftFinalB0 = this.secret[1] >>> 24 | this.secret[2] << 40;
        this.secShiftFinalB1 = this.secret[2] >>> 24 | this.secret[3] << 40;
        this.secShiftFinalB2 = this.secret[3] >>> 24 | this.secret[4] << 40;
        this.secShiftFinalB3 = this.secret[4] >>> 24 | this.secret[5] << 40;
        this.secShiftFinalB4 = this.secret[5] >>> 24 | this.secret[6] << 40;
        this.secShiftFinalB5 = this.secret[6] >>> 24 | this.secret[7] << 40;
        this.secShiftFinalB6 = this.secret[7] >>> 24 | this.secret[8] << 40;
        this.secShiftFinalB7 = this.secret[8] >>> 24 | this.secret[9] << 40;
        this.bitflip00 = 2267503259L + seed;
    }

    protected long getSeed() {
        return this.secret[0] - -4734510112055689544L;
    }

    protected static long avalanche64(long h64) {
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        return (h64 *= 1609587929392839161L) ^ h64 >>> 32;
    }

    protected static long avalanche3(long h64) {
        h64 ^= h64 >>> 37;
        return (h64 *= 1609587791953885689L) ^ h64 >>> 32;
    }

    protected static long contrib(long a, long b) {
        long k = a ^ b;
        return (0xFFFFFFFFL & k) * (k >>> 32);
    }

    protected static long mixAcc(long acc, long sec) {
        return (acc ^ acc >>> 47 ^ sec) * 2654435761L;
    }

    protected abstract long finish12Bytes(long var1, long var3);

    @Override
    public long hashIntIntIntToLong(int v1, int v2, int v3) {
        return this.finish12Bytes((long)v1 & 0xFFFFFFFFL ^ (long)v2 << 32, (long)v3 << 32 ^ (long)v2 & 0xFFFFFFFFL);
    }

    @Override
    public long hashIntLongToLong(int v1, long v2) {
        return this.finish12Bytes((long)v1 & 0xFFFFFFFFL ^ v2 << 32, v2);
    }

    @Override
    public long hashLongIntToLong(long v1, int v2) {
        return this.finish12Bytes(v1, (long)v2 << 32 ^ v1 >>> 32);
    }

    protected abstract class HashStreamImplBase
    implements HashStream64 {
        protected static final int BULK_SIZE = 256;
        protected static final int BULK_SIZE_HALF = 128;
        protected static final int BULK_SIZE_MASK = 255;
        protected long acc0 = 3266489917L;
        protected long acc1 = -7046029288634856825L;
        protected long acc2 = -4417276706812531889L;
        protected long acc3 = 1609587929392839161L;
        protected long acc4 = -8796714831421723037L;
        protected long acc5 = 2246822519L;
        protected long acc6 = 2870177450012600261L;
        protected long acc7 = 2654435761L;
        protected final byte[] buffer = new byte[264];
        protected int offset = 0;
        protected long byteCount = 0L;
        private static final byte SERIAL_VERSION_V0 = 0;

        protected HashStreamImplBase() {
        }

        public int hashCode() {
            return this.getAsInt();
        }

        public boolean equals(Object o) {
            return HashUtil.equalsHelper(this, o);
        }

        protected void putByteImpl(byte v) {
            if (this.offset >= 256) {
                this.processBuffer();
                this.offset -= 256;
            }
            this.buffer[this.offset] = v;
            ++this.offset;
            ++this.byteCount;
        }

        protected void putShortImpl(short v) {
            ByteArrayUtil.setShort(this.buffer, this.offset, v);
            if (this.offset >= 255) {
                this.processBuffer();
                this.offset -= 256;
                ByteArrayUtil.setShort(this.buffer, 0, (short)(v >>> (-this.offset << 3)));
            }
            this.offset += 2;
            this.byteCount += 2L;
        }

        protected void putCharImpl(char v) {
            ByteArrayUtil.setChar(this.buffer, this.offset, v);
            if (this.offset >= 255) {
                this.processBuffer();
                this.offset -= 256;
                ByteArrayUtil.setChar(this.buffer, 0, (char)(v >>> (-this.offset << 3)));
            }
            this.offset += 2;
            this.byteCount += 2L;
        }

        protected void putIntImpl(int v) {
            ByteArrayUtil.setInt(this.buffer, this.offset, v);
            if (this.offset >= 253) {
                this.processBuffer();
                this.offset -= 256;
                ByteArrayUtil.setInt(this.buffer, 0, v >>> (-this.offset << 3));
            }
            this.offset += 4;
            this.byteCount += 4L;
        }

        protected void putLongImpl(long v) {
            ByteArrayUtil.setLong(this.buffer, this.offset, v);
            if (this.offset >= 249) {
                this.processBuffer();
                this.offset -= 256;
                ByteArrayUtil.setLong(this.buffer, 0, v >>> (-this.offset << 3));
            }
            this.offset += 8;
            this.byteCount += 8L;
        }

        protected void putBytesImpl(byte[] input, int off, int len) {
            int remaining = len;
            int x = 256 - this.offset;
            if (len > x) {
                int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                if (this.offset > 0) {
                    System.arraycopy(input, off, this.buffer, this.offset, x);
                    this.processBuffer(0, this.buffer, s);
                    this.offset = 0;
                    off += x;
                    remaining -= x;
                }
                if (remaining > 256) {
                    do {
                        s += 4;
                        this.processBuffer(off, input, s &= 0xC);
                        off += 256;
                    } while ((remaining -= 256) > 256);
                    if (remaining < 64) {
                        int l = 64 - remaining;
                        System.arraycopy(input, off - l, this.buffer, 256 - l, l);
                    }
                }
            }
            System.arraycopy(input, off, this.buffer, this.offset, remaining);
            this.offset += remaining;
            this.byteCount += (long)len;
        }

        protected <T> void putBytesImpl(T input, long off, long len, ByteAccess<T> access) {
            long remaining = len;
            int x = 256 - this.offset;
            if (len > (long)x) {
                int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                if (this.offset > 0) {
                    access.copyToByteArray(input, off, this.buffer, this.offset, x);
                    this.processBuffer(0, this.buffer, s);
                    this.offset = 0;
                    off += (long)x;
                    remaining -= (long)x;
                }
                if (remaining > 256L) {
                    do {
                        s += 4;
                        this.processBuffer(off, input, s &= 0xC, access);
                        off += 256L;
                    } while ((remaining -= 256L) > 256L);
                    if (remaining < 64L) {
                        int l = 64 - (int)remaining;
                        access.copyToByteArray(input, off - (long)l, this.buffer, 256 - l, l);
                    }
                }
            }
            access.copyToByteArray(input, off, this.buffer, this.offset, (int)remaining);
            this.offset += (int)remaining;
            this.byteCount += len;
        }

        protected void putCharsImpl(CharSequence c) {
            int off = 0;
            int remaining = c.length();
            int x = 128 - (this.offset >>> 1);
            if ((this.offset & 1) == 0) {
                if (c.length() > x) {
                    int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                    if (this.offset > 0) {
                        ByteArrayUtil.copyCharsToByteArray(c, 0, this.buffer, this.offset, x);
                        this.processBuffer(0, this.buffer, s);
                        this.offset = 0;
                        off += x;
                        remaining -= x;
                    }
                    if (remaining > 128) {
                        do {
                            s += 4;
                            this.processBuffer(off, c, s &= 0xC);
                            off += 128;
                        } while ((remaining -= 128) > 128);
                        if (remaining < 32) {
                            int l = 32 - remaining;
                            ByteArrayUtil.copyCharsToByteArray(c, off - l, this.buffer, 256 - (l << 1), l);
                        }
                    }
                }
            } else if (c.length() >= x) {
                int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                ByteArrayUtil.copyCharsToByteArray(c, 0, this.buffer, this.offset, x);
                long extraByte = (long)this.buffer[256] & 0xFFL;
                this.processBuffer(0, this.buffer, s);
                this.offset = 1;
                off += x;
                if ((remaining -= x) >= 128) {
                    do {
                        s += 4;
                        extraByte = this.processBuffer(off, c, s &= 0xC, extraByte);
                        off += 128;
                    } while ((remaining -= 128) >= 128);
                    if (remaining < 32) {
                        int l = 32 - remaining;
                        ByteArrayUtil.copyCharsToByteArray(c, off - l, this.buffer, 257 - (l << 1), l);
                    }
                }
                this.buffer[0] = (byte)extraByte;
            }
            ByteArrayUtil.copyCharsToByteArray(c, off, this.buffer, this.offset, remaining);
            this.offset += remaining << 1;
            this.byteCount += (long)c.length() << 1;
        }

        protected void resetImpl() {
            this.acc0 = 3266489917L;
            this.acc1 = -7046029288634856825L;
            this.acc2 = -4417276706812531889L;
            this.acc3 = 1609587929392839161L;
            this.acc4 = -8796714831421723037L;
            this.acc5 = 2246822519L;
            this.acc6 = 2870177450012600261L;
            this.acc7 = 2654435761L;
            this.offset = 0;
            this.byteCount = 0L;
        }

        @Override
        public byte[] getState() {
            int numBufferBytes = (this.byteCount > 256L || this.byteCount < 0L) && this.offset < 64 ? 64 : this.offset;
            byte[] state = new byte[9 + (this.byteCount > 256L || this.byteCount < 0L ? 64 : 0) + numBufferBytes];
            state[0] = 0;
            int off = 1;
            ByteArrayUtil.setLong(state, off, this.byteCount);
            off += 8;
            if (this.byteCount > 256L || this.byteCount < 0L) {
                ByteArrayUtil.setLong(state, off, this.acc0);
                ByteArrayUtil.setLong(state, off += 8, this.acc1);
                ByteArrayUtil.setLong(state, off += 8, this.acc2);
                ByteArrayUtil.setLong(state, off += 8, this.acc3);
                ByteArrayUtil.setLong(state, off += 8, this.acc4);
                ByteArrayUtil.setLong(state, off += 8, this.acc5);
                ByteArrayUtil.setLong(state, off += 8, this.acc6);
                ByteArrayUtil.setLong(state, off += 8, this.acc7);
                off += 8;
            }
            if ((this.byteCount > 256L || this.byteCount < 0L) && this.offset < 64) {
                System.arraycopy(this.buffer, 192 + this.offset, state, off, 64 - this.offset);
                off += 64 - this.offset;
            }
            System.arraycopy(this.buffer, 0, state, off, this.offset);
            return state;
        }

        protected void setStateImpl(byte[] state) {
            Preconditions.checkArgument(state != null);
            Preconditions.checkArgument(state.length >= 9);
            Preconditions.checkArgument(state[0] == 0);
            int off = 1;
            this.byteCount = ByteArrayUtil.getLong(state, off);
            off += 8;
            this.offset = this.byteCount != 0L ? ((int)this.byteCount - 1 & 0xFF) + 1 : 0;
            int numBufferBytes = (this.byteCount > 256L || this.byteCount < 0L) && this.offset < 64 ? 64 : this.offset;
            Preconditions.checkArgument(state.length == 9 + (this.byteCount > 256L || this.byteCount < 0L ? 64 : 0) + numBufferBytes);
            if (this.byteCount > 256L || this.byteCount < 0L) {
                this.acc0 = ByteArrayUtil.getLong(state, off);
                this.acc1 = ByteArrayUtil.getLong(state, off += 8);
                this.acc2 = ByteArrayUtil.getLong(state, off += 8);
                this.acc3 = ByteArrayUtil.getLong(state, off += 8);
                this.acc4 = ByteArrayUtil.getLong(state, off += 8);
                this.acc5 = ByteArrayUtil.getLong(state, off += 8);
                this.acc6 = ByteArrayUtil.getLong(state, off += 8);
                this.acc7 = ByteArrayUtil.getLong(state, off += 8);
                off += 8;
            } else {
                this.acc0 = 3266489917L;
                this.acc1 = -7046029288634856825L;
                this.acc2 = -4417276706812531889L;
                this.acc3 = 1609587929392839161L;
                this.acc4 = -8796714831421723037L;
                this.acc5 = 2246822519L;
                this.acc6 = 2870177450012600261L;
                this.acc7 = 2654435761L;
            }
            if ((this.byteCount > 256L || this.byteCount < 0L) && this.offset < 64) {
                System.arraycopy(state, off, this.buffer, 192 + this.offset, 64 - this.offset);
                off += 64 - this.offset;
            }
            System.arraycopy(state, off, this.buffer, 0, this.offset);
        }

        private void processBuffer() {
            int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
            this.processBuffer(0, this.buffer, s);
        }

        private void mixAcc() {
            this.acc0 = XXH3Base.mixAcc(this.acc0, XXH3Base.this.secret[16]);
            this.acc1 = XXH3Base.mixAcc(this.acc1, XXH3Base.this.secret[17]);
            this.acc2 = XXH3Base.mixAcc(this.acc2, XXH3Base.this.secret[18]);
            this.acc3 = XXH3Base.mixAcc(this.acc3, XXH3Base.this.secret[19]);
            this.acc4 = XXH3Base.mixAcc(this.acc4, XXH3Base.this.secret[20]);
            this.acc5 = XXH3Base.mixAcc(this.acc5, XXH3Base.this.secret[21]);
            this.acc6 = XXH3Base.mixAcc(this.acc6, XXH3Base.this.secret[22]);
            this.acc7 = XXH3Base.mixAcc(this.acc7, XXH3Base.this.secret[23]);
        }

        private void processBuffer(int off, byte[] buffer, int s) {
            for (int i = 0; i < 4; ++i) {
                int o = off + (i << 6);
                long b0 = ByteArrayUtil.getLong(buffer, o + 0);
                long b1 = ByteArrayUtil.getLong(buffer, o + 8);
                long b2 = ByteArrayUtil.getLong(buffer, o + 16);
                long b3 = ByteArrayUtil.getLong(buffer, o + 24);
                long b4 = ByteArrayUtil.getLong(buffer, o + 32);
                long b5 = ByteArrayUtil.getLong(buffer, o + 40);
                long b6 = ByteArrayUtil.getLong(buffer, o + 48);
                long b7 = ByteArrayUtil.getLong(buffer, o + 56);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
        }

        private <T> void processBuffer(long off, T buffer, int s, ByteAccess<T> access) {
            for (int i = 0; i < 4; ++i) {
                long o = off + (long)(i << 6);
                long b0 = access.getLong(buffer, o + 0L);
                long b1 = access.getLong(buffer, o + 8L);
                long b2 = access.getLong(buffer, o + 16L);
                long b3 = access.getLong(buffer, o + 24L);
                long b4 = access.getLong(buffer, o + 32L);
                long b5 = access.getLong(buffer, o + 40L);
                long b6 = access.getLong(buffer, o + 48L);
                long b7 = access.getLong(buffer, o + 56L);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
        }

        private void processBuffer(int off, CharSequence c, int s) {
            for (int i = 0; i < 4; ++i) {
                int o = off + (i << 5);
                long b0 = ByteArrayUtil.getLong(c, o + 0);
                long b1 = ByteArrayUtil.getLong(c, o + 4);
                long b2 = ByteArrayUtil.getLong(c, o + 8);
                long b3 = ByteArrayUtil.getLong(c, o + 12);
                long b4 = ByteArrayUtil.getLong(c, o + 16);
                long b5 = ByteArrayUtil.getLong(c, o + 20);
                long b6 = ByteArrayUtil.getLong(c, o + 24);
                long b7 = ByteArrayUtil.getLong(c, o + 28);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
        }

        private long processBuffer(int off, CharSequence c, int s, long extraByte) {
            for (int i = 0; i < 4; ++i) {
                int o = off + (i << 5);
                long b0 = ByteArrayUtil.getLong(c, o + 0);
                long b1 = ByteArrayUtil.getLong(c, o + 4);
                long b2 = ByteArrayUtil.getLong(c, o + 8);
                long b3 = ByteArrayUtil.getLong(c, o + 12);
                long b4 = ByteArrayUtil.getLong(c, o + 16);
                long b5 = ByteArrayUtil.getLong(c, o + 20);
                long b6 = ByteArrayUtil.getLong(c, o + 24);
                long b7 = ByteArrayUtil.getLong(c, o + 28);
                long y = b7 >>> 56;
                b7 = b6 >>> 56 | b7 << 8;
                b6 = b5 >>> 56 | b6 << 8;
                b5 = b4 >>> 56 | b5 << 8;
                b4 = b3 >>> 56 | b4 << 8;
                b3 = b2 >>> 56 | b3 << 8;
                b2 = b1 >>> 56 | b2 << 8;
                b1 = b0 >>> 56 | b1 << 8;
                b0 = extraByte | b0 << 8;
                extraByte = y;
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
            return extraByte;
        }

        private void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7, int s) {
            this.acc0 += b1 + XXH3Base.contrib(b0, XXH3Base.this.secret[s + 0]);
            this.acc1 += b0 + XXH3Base.contrib(b1, XXH3Base.this.secret[s + 1]);
            this.acc2 += b3 + XXH3Base.contrib(b2, XXH3Base.this.secret[s + 2]);
            this.acc3 += b2 + XXH3Base.contrib(b3, XXH3Base.this.secret[s + 3]);
            this.acc4 += b5 + XXH3Base.contrib(b4, XXH3Base.this.secret[s + 4]);
            this.acc5 += b4 + XXH3Base.contrib(b5, XXH3Base.this.secret[s + 5]);
            this.acc6 += b7 + XXH3Base.contrib(b6, XXH3Base.this.secret[s + 6]);
            this.acc7 += b6 + XXH3Base.contrib(b7, XXH3Base.this.secret[s + 7]);
        }
    }
}

