/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorDirectNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;

@GenerateInline
@GenerateCached(value=false)
@GenerateUncached
@ImportStatic(value={JSInteropUtil.class})
public abstract class GetIteratorFromMethodNode
extends JavaScriptBaseNode {
    protected GetIteratorFromMethodNode() {
    }

    public abstract IteratorRecord execute(Node var1, Object var2, Object var3);

    @Specialization
    protected static IteratorRecord getIteratorFromMethod(Node node, Object iteratedObject, Object method, @Cached(inline=false) IsCallableNode isCallableNode, @Cached(value="createCall()", uncached="getUncachedCall()", inline=false) JSFunctionCallNode iteratorCallNode, @Cached GetIteratorDirectNode getIteratorDirectNode, @Cached InlinedBranchProfile errorBranch) {
        if (!isCallableNode.executeBoolean(method)) {
            errorBranch.enter(node);
            throw Errors.createTypeErrorNotIterable(iteratedObject, node);
        }
        Object iterator = iteratorCallNode.executeCall(JSArguments.createZeroArg(iteratedObject, method));
        return getIteratorDirectNode.execute(node, iterator);
    }
}

