/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CSocketInputStreamWrapper;
import oracle.jdbc.driver.T4CSocketOutputStreamWrapper;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CMAREngineStream
extends T4CMAREngine {
    NetInputStream inStream;
    NetOutputStream outStream;
    byte[] nativeUB2Buffer;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    T4CMAREngineStream(Communication net) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$31, null, net);
            }
            this.nativeUB2Buffer = new byte[2];
            if (net == null) {
                if (bl) {
                    this.debug($$$loggerRef$$$31, Level.FINEST, $$$methodRef$$$31, "T4CMAREngineStream: net == null");
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$31, null, sQLException);
                }
                throw sQLException;
            }
            this.net = net;
            try {
                this.outStream = new T4CSocketOutputStreamWrapper((NetOutputStream)net.getOutputStream(), net.getSessionAttributes());
                this.inStream = new T4CSocketInputStreamWrapper((NetInputStream)net.getInputStream(), (T4CSocketOutputStreamWrapper)this.outStream, net.getSessionAttributes());
            }
            catch (NetException ne) {
                IOException iOException = new IOException(ne.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$31, null, iOException);
                }
                throw iOException;
            }
            this.types = new T4CTypeRep(this, false);
            this.types.setRep((byte)1, (byte)2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$31, null);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$31, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    void initBuffers() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalSB1(byte by) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$1, this, by);
            }
            this.marshalSB2((short)value);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalUB1(short s2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$2, this, s2);
            }
            this.outStream.write((byte)(value & 0xFF));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalSB2(short s2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$3, this, s2);
            }
            if (value == false) {
                this.outStream.write(0);
            } else {
                if (value < 0 || value > 256) {
                    this.tmpBuffer10[0] = 2;
                    this.tmpBuffer10[2] = (byte)(value & 0xFF);
                    this.tmpBuffer10[1] = (byte)(value >> 8 & 0xFF);
                } else {
                    this.tmpBuffer10[0] = 1;
                    this.tmpBuffer10[1] = (byte)(value & 0xFF);
                }
                this.outStream.write(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void marshalNativeUB2(short s2, boolean bl) throws IOException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void isLsb;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$4, this, s2, bl);
            }
            if (isLsb != false) {
                this.nativeUB2Buffer[0] = (byte)(value & 0xFF);
                this.nativeUB2Buffer[1] = (byte)(value >>> 8 & 0xFF);
            } else {
                this.nativeUB2Buffer[1] = (byte)(value & 0xFF);
                this.nativeUB2Buffer[0] = (byte)(value >>> 8 & 0xFF);
            }
            this.outStream.write(this.nativeUB2Buffer);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalUB2(int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$5, this, n2);
            }
            this.marshalSB2((short)(value & 0xFFFF));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalSB4(int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$6, this, n2);
            }
            if (value == false) {
                this.outStream.write(0);
            } else {
                if (value < 0) {
                    this.tmpBuffer10[0] = 4;
                    this.tmpBuffer10[1] = (byte)(value >> 24 & 0xFF);
                    this.tmpBuffer10[2] = (byte)(value >> 16 & 0xFF);
                    this.tmpBuffer10[3] = (byte)(value >> 8 & 0xFF);
                    this.tmpBuffer10[4] = (byte)(value & 0xFF);
                } else if (value < 256) {
                    this.tmpBuffer10[0] = 1;
                    this.tmpBuffer10[1] = (byte)(value & 0xFF);
                } else if (value < 65536) {
                    this.tmpBuffer10[0] = 2;
                    this.tmpBuffer10[1] = (byte)(value >> 8 & 0xFF);
                    this.tmpBuffer10[2] = (byte)(value & 0xFF);
                } else if (value < 0x1000000) {
                    this.tmpBuffer10[0] = 3;
                    this.tmpBuffer10[1] = (byte)(value >> 16 & 0xFF);
                    this.tmpBuffer10[2] = (byte)(value >> 8 & 0xFF);
                    this.tmpBuffer10[3] = (byte)(value & 0xFF);
                } else {
                    this.tmpBuffer10[0] = 4;
                    this.tmpBuffer10[1] = (byte)(value >> 24 & 0xFF);
                    this.tmpBuffer10[2] = (byte)(value >> 16 & 0xFF);
                    this.tmpBuffer10[3] = (byte)(value >> 8 & 0xFF);
                    this.tmpBuffer10[4] = (byte)(value & 0xFF);
                }
                this.outStream.write(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalUB4(long l2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$7, this, l2);
            }
            this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalUB8(long l2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$8, this, l2);
            }
            this.marshalSB8((long)value);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalSB8(long l2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$9, this, l2);
            }
            if (value == 0L) {
                this.outStream.write(0);
            } else {
                if (value < 0L) {
                    this.tmpBuffer10[0] = 8;
                    this.tmpBuffer10[1] = (byte)(value >> 56 & 0xFFL);
                    this.tmpBuffer10[2] = (byte)(value >> 48 & 0xFFL);
                    this.tmpBuffer10[3] = (byte)(value >> 40 & 0xFFL);
                    this.tmpBuffer10[4] = (byte)(value >> 32 & 0xFFL);
                    this.tmpBuffer10[5] = (byte)(value >> 24 & 0xFFL);
                    this.tmpBuffer10[6] = (byte)(value >> 16 & 0xFFL);
                    this.tmpBuffer10[7] = (byte)(value >> 8 & 0xFFL);
                    this.tmpBuffer10[8] = (byte)(value & 0xFFL);
                } else if (value < 256L) {
                    this.tmpBuffer10[0] = 1;
                    this.tmpBuffer10[1] = (byte)(value & 0xFFL);
                } else if (value < 65536L) {
                    this.tmpBuffer10[0] = 2;
                    this.tmpBuffer10[1] = (byte)(value >> 8 & 0xFFL);
                    this.tmpBuffer10[2] = (byte)(value & 0xFFL);
                } else if (value < 0x1000000L) {
                    this.tmpBuffer10[0] = 3;
                    this.tmpBuffer10[1] = (byte)(value >> 16 & 0xFFL);
                    this.tmpBuffer10[2] = (byte)(value >> 8 & 0xFFL);
                    this.tmpBuffer10[3] = (byte)(value & 0xFFL);
                } else if (value < 0x100000000L) {
                    this.tmpBuffer10[0] = 4;
                    this.tmpBuffer10[1] = (byte)(value >> 24 & 0xFFL);
                    this.tmpBuffer10[2] = (byte)(value >> 16 & 0xFFL);
                    this.tmpBuffer10[3] = (byte)(value >> 8 & 0xFFL);
                    this.tmpBuffer10[4] = (byte)(value & 0xFFL);
                } else if (value < 0x10000000000L) {
                    this.tmpBuffer10[0] = 5;
                    this.tmpBuffer10[1] = (byte)(value >> 32 & 0xFFL);
                    this.tmpBuffer10[2] = (byte)(value >> 24 & 0xFFL);
                    this.tmpBuffer10[3] = (byte)(value >> 16 & 0xFFL);
                    this.tmpBuffer10[4] = (byte)(value >> 8 & 0xFFL);
                    this.tmpBuffer10[5] = (byte)(value & 0xFFL);
                } else if (value < 0x1000000000000L) {
                    this.tmpBuffer10[0] = 6;
                    this.tmpBuffer10[1] = (byte)(value >> 40 & 0xFFL);
                    this.tmpBuffer10[2] = (byte)(value >> 32 & 0xFFL);
                    this.tmpBuffer10[3] = (byte)(value >> 24 & 0xFFL);
                    this.tmpBuffer10[4] = (byte)(value >> 16 & 0xFFL);
                    this.tmpBuffer10[5] = (byte)(value >> 8 & 0xFFL);
                    this.tmpBuffer10[6] = (byte)(value & 0xFFL);
                } else if (value < 0x100000000000000L) {
                    this.tmpBuffer10[0] = 7;
                    this.tmpBuffer10[1] = (byte)(value >> 48 & 0xFFL);
                    this.tmpBuffer10[2] = (byte)(value >> 40 & 0xFFL);
                    this.tmpBuffer10[3] = (byte)(value >> 32 & 0xFFL);
                    this.tmpBuffer10[4] = (byte)(value >> 24 & 0xFFL);
                    this.tmpBuffer10[5] = (byte)(value >> 16 & 0xFFL);
                    this.tmpBuffer10[6] = (byte)(value >> 8 & 0xFFL);
                    this.tmpBuffer10[7] = (byte)(value & 0xFFL);
                } else {
                    this.tmpBuffer10[0] = 8;
                    this.tmpBuffer10[1] = (byte)(value >> 56 & 0xFFL);
                    this.tmpBuffer10[2] = (byte)(value >> 48 & 0xFFL);
                    this.tmpBuffer10[3] = (byte)(value >> 40 & 0xFFL);
                    this.tmpBuffer10[4] = (byte)(value >> 32 & 0xFFL);
                    this.tmpBuffer10[5] = (byte)(value >> 24 & 0xFFL);
                    this.tmpBuffer10[6] = (byte)(value >> 16 & 0xFFL);
                    this.tmpBuffer10[7] = (byte)(value >> 8 & 0xFFL);
                    this.tmpBuffer10[8] = (byte)(value & 0xFFL);
                }
                this.outStream.write(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalB1Array(byte[] byArray) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$10, this, new Object[]{byArray});
            }
            if (bl) {
                this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, OracleLog.bytesToPrintableForm("value", (byte[])value, ((void)value).length));
            }
            if (((void)value).length > 0) {
                this.outStream.write((byte[])value);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$11, this, byArray, n2, n3);
            }
            if (((void)value).length > 0) {
                void len;
                void off;
                this.outStream.write((byte[])value, (int)off, (int)len);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final byte unmarshalSB1() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$12, this, new Object[0]);
            }
            byte by = result = (byte)this.unmarshalSB2();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$12, this, by);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$12, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final short unmarshalUB1() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$13, this, new Object[0]);
            }
            short value = 0;
            try {
                value = (short)this.inStream.read();
            }
            catch (SocketTimeoutException toe) {
                ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                SocketTimeoutException socketTimeoutException = toe;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$13, this, socketTimeoutException);
                }
                throw socketTimeoutException;
            }
            catch (BreakNetException e2) {
                if (bl) {
                    this.debug($$$loggerRef$$$13, Level.FINEST, $$$methodRef$$$13, "T4CMAREngineStream.unmarshalUB1: reakNetException. resetting");
                }
                this.net.sendReset();
                BreakNetException breakNetException = e2;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$13, this, breakNetException);
                }
                throw breakNetException;
            }
            if (value < 0) {
                if (bl) {
                    this.debug($$$loggerRef$$$13, Level.FINEST, $$$methodRef$$$13, "T4CMAREngineStream.unmarshalUB1: end of buffer");
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$13, this, sQLException);
                }
                throw sQLException;
            }
            short s2 = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$13, this, s2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$13, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final short unmarshalSB2() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean isNegative;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$14, this, new Object[0]);
            }
            int value = 0;
            int bufSize = this.inStream.readB1();
            boolean bl2 = isNegative = bufSize > 128;
            if (isNegative) {
                bufSize &= 0x7F;
            }
            switch (bufSize) {
                case 0: {
                    break;
                }
                case 1: {
                    value = this.inStream.readB1() & 0xFF;
                    break;
                }
                case 2: {
                    this.inStream.read(this.tmpBuffer2);
                    value = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$14, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (isNegative) {
                value *= -1;
            }
            short s2 = (short)value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$14, this, s2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$14, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final int unmarshalUB2() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$15, this, new Object[0]);
            }
            int value = 0;
            switch (this.inStream.readB1()) {
                case 0: {
                    break;
                }
                case 1: {
                    value = this.inStream.readB1() & 0xFF;
                    break;
                }
                case 2: {
                    this.inStream.read(this.tmpBuffer2);
                    value = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                    break;
                }
                case 3: {
                    this.inStream.read(this.tmpBuffer4, 0, 3);
                    value = this.tmpBuffer4[0] << 16 & 0xFF0000 | this.tmpBuffer4[1] << 8 & 0xFF00 | this.tmpBuffer4[2] & 0xFF;
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$15, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            int n2 = value & 0xFFFF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$15, this, n2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$15, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final int unmarshalSB4() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean isNegative;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$16, this, new Object[0]);
            }
            int value = 0;
            int bufSize = this.inStream.readB1();
            boolean bl2 = isNegative = bufSize > 128;
            if (isNegative) {
                bufSize &= 0x7F;
            }
            switch (bufSize) {
                case 0: {
                    break;
                }
                case 1: {
                    value = this.inStream.readB1() & 0xFF;
                    break;
                }
                case 2: {
                    this.inStream.read(this.tmpBuffer2, 0, 2);
                    value = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                    break;
                }
                case 3: {
                    this.inStream.read(this.tmpBuffer4, 0, 3);
                    value = this.tmpBuffer4[0] << 16 & 0xFF0000 | this.tmpBuffer4[1] << 8 & 0xFF00 | this.tmpBuffer4[2] & 0xFF;
                    break;
                }
                case 4: {
                    this.inStream.read(this.tmpBuffer4, 0, 4);
                    value = this.tmpBuffer4[0] << 24 & 0xFF000000 | this.tmpBuffer4[1] << 16 & 0xFF0000 | this.tmpBuffer4[2] << 8 & 0xFF00 | this.tmpBuffer4[3] & 0xFF;
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$16, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (isNegative) {
                value *= -1;
            }
            int n2 = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$16, this, n2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$16, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final long unmarshalUB4() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$17, this, new Object[0]);
            }
            long value = 0L;
            switch (this.inStream.readB1()) {
                case 0: {
                    break;
                }
                case 1: {
                    value = this.inStream.readB1() & 0xFF;
                    break;
                }
                case 2: {
                    this.inStream.read(this.tmpBuffer2, 0, 2);
                    value = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                    break;
                }
                case 3: {
                    this.inStream.read(this.tmpBuffer4, 0, 3);
                    value = this.tmpBuffer4[0] << 16 & 0xFF0000 | this.tmpBuffer4[1] << 8 & 0xFF00 | this.tmpBuffer4[2] & 0xFF;
                    break;
                }
                case 4: {
                    this.inStream.read(this.tmpBuffer4, 0, 4);
                    value = this.tmpBuffer4[0] << 24 & 0xFF000000 | this.tmpBuffer4[1] << 16 & 0xFF0000 | this.tmpBuffer4[2] << 8 & 0xFF00 | this.tmpBuffer4[3] & 0xFF;
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$17, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            long l2 = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$17, this, l2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$17, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$18, this, n2);
            }
            byte[] tmpBuffer = new byte[n3];
            if (n3 > 0) {
                try {
                    if (this.inStream.read(tmpBuffer) < 0) {
                        if (bl) {
                            this.debug($$$loggerRef$$$18, Level.FINEST, $$$methodRef$$$18, "T4CMAREngineStream.unmarshalNBytes: end of buffer");
                        }
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$18, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                catch (SocketTimeoutException toe) {
                    ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                    SocketTimeoutException socketTimeoutException = toe;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$18, this, socketTimeoutException);
                    }
                    throw socketTimeoutException;
                }
                catch (BreakNetException e2) {
                    if (bl) {
                        this.debug($$$loggerRef$$$18, Level.FINEST, $$$methodRef$$$18, "T4CMAREngineStream.unmarshalNBytes: BreakNetException. resetting");
                    }
                    this.net.sendReset();
                    BreakNetException breakNetException = e2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$18, this, breakNetException);
                    }
                    throw breakNetException;
                }
            }
            byte[] byArray = tmpBuffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$18, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$18, this, null);
            }
            return tmpBuffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int bytes;
            void buf;
            int n4;
            void off;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$19, this, byArray, n2, n3);
            }
            if (off + n4 > ((void)buf).length) {
                n4 = ((void)buf).length - off;
            }
            for (bytes = 0; bytes < n4; bytes += this.getNBytes((byte[])buf, (int)(off + bytes), n4 - bytes)) {
            }
            int n5 = bytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$19, this, n5);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$19, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void buf;
            int len;
            void off;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$20, this, byArray, n2, n3);
            }
            if (off + len > ((void)buf).length) {
                len = ((void)buf).length - off;
            }
            int cnt = 0;
            try {
                cnt = this.inStream.read((byte[])buf, (int)off, len);
                if (cnt < 0) {
                    if (bl) {
                        this.debug($$$loggerRef$$$20, Level.FINEST, $$$methodRef$$$20, "T4CMAREngineStream.getNBytes: end of buffer");
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$20, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            catch (SocketTimeoutException toe) {
                ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                SocketTimeoutException socketTimeoutException = toe;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$20, this, socketTimeoutException);
                }
                throw socketTimeoutException;
            }
            catch (BreakNetException e2) {
                if (bl) {
                    this.debug($$$loggerRef$$$20, Level.FINEST, $$$methodRef$$$20, "T4CMAREngineStream.getNBytes: BreakNetException. resetting");
                }
                this.net.sendReset();
                BreakNetException breakNetException = e2;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$20, this, breakNetException);
                }
                throw breakNetException;
            }
            int n4 = cnt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$20, this, n4);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$20, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getNBytes(int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$21, this, n2);
            }
            byte[] tmpBuffer = new byte[n3];
            try {
                if (this.inStream.read(tmpBuffer) < 0) {
                    if (bl) {
                        this.debug($$$loggerRef$$$21, Level.FINEST, $$$methodRef$$$21, "T4CMAREngineStream.getNBytes(int): end of buffer");
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$21, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            catch (SocketTimeoutException toe) {
                ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                SocketTimeoutException socketTimeoutException = toe;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$21, this, socketTimeoutException);
                }
                throw socketTimeoutException;
            }
            catch (BreakNetException e2) {
                if (bl) {
                    this.debug($$$loggerRef$$$21, Level.FINEST, $$$methodRef$$$21, "T4CMAREngineStream.getNBytes: BreakNetException. resetting");
                }
                this.net.sendReset();
                BreakNetException breakNetException = e2;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$21, this, breakNetException);
                }
                throw breakNetException;
            }
            byte[] byArray = tmpBuffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$21, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$21, this, null);
            }
            return tmpBuffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] buffer;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$22, this, n2);
            }
            int offset = 0;
            byte[] tmpBuffer = new byte[bytes];
            while (offset < bytes) {
                try {
                    if (this.inStream.read(tmpBuffer, offset, 1) < 0) {
                        if (bl) {
                            this.debug($$$loggerRef$$$22, Level.FINEST, $$$methodRef$$$22, "T4CMAREngineStream.unmarshalTEXT: end of buffer");
                        }
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$22, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                catch (SocketTimeoutException toe) {
                    ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                    SocketTimeoutException socketTimeoutException = toe;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$22, this, socketTimeoutException);
                    }
                    throw socketTimeoutException;
                }
                catch (BreakNetException e2) {
                    if (bl) {
                        this.debug($$$loggerRef$$$22, Level.FINEST, $$$methodRef$$$22, "T4CMAREngineStream.unmarshalTEXT: BreakNetException. resetting");
                    }
                    this.net.sendReset();
                    BreakNetException breakNetException = e2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$22, this, breakNetException);
                    }
                    throw breakNetException;
                }
                if (tmpBuffer[offset++] != 0) continue;
            }
            if (tmpBuffer.length == --offset) {
                buffer = tmpBuffer;
            } else {
                buffer = new byte[offset];
                System.arraycopy(tmpBuffer, 0, buffer, 0, offset);
            }
            byte[] byArray = buffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$22, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$22, this, null);
            }
            return buffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final long buffer2Value(byte by) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block17: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$23, this, by);
                }
                try {
                    void repOffset;
                    long returnValue = 0L;
                    int bufLength = 1;
                    if ((this.types.rep[repOffset] & 1) > 0) {
                        bufLength = this.inStream.readB1();
                    } else {
                        switch (repOffset) {
                            case 1: {
                                bufLength = 2;
                                break;
                            }
                            case 2: {
                                bufLength = 4;
                                break;
                            }
                            case 3: {
                                bufLength = 8;
                            }
                        }
                    }
                    returnValue = (this.types.rep[repOffset] & 2) > 0 ? this.inStream.readLongLSB(bufLength) : this.inStream.readLongMSB(bufLength);
                    l2 = returnValue;
                    if (!bl) break block17;
                }
                catch (BreakNetException e2) {
                    if (bl) {
                        this.debug($$$loggerRef$$$23, Level.FINEST, $$$methodRef$$$23, "T4CMAREngineStream.buffer2Value: BreakNetException. resetting");
                    }
                    this.net.sendReset();
                    BreakNetException breakNetException = e2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$23, this, breakNetException);
                    }
                    throw breakNetException;
                }
                catch (SocketTimeoutException toe) {
                    ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                    SocketTimeoutException socketTimeoutException = toe;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$23, this, socketTimeoutException);
                    }
                    throw socketTimeoutException;
                }
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$23, this, l2);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$23, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void setByteOrder(byte by) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$24, this, by);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void flush() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$25, this, new Object[0]);
            }
            ((T4CSocketOutputStreamWrapper)this.outStream).flush(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void offset;
            void userBuffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$26, this, byArray, n2, n3);
            }
            this.outStream.flush();
            this.outStream.writeZeroCopyIO((byte[])userBuffer, (int)offset, (int)length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void writeZeroCopyIOHeader(boolean bl, int n2, boolean bl2) throws IOException {
        boolean bl3 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void isLastDD;
            void lengthInDD;
            void flushBuffer;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$27, this, bl, n2, bl2);
            }
            if (flushBuffer != false) {
                this.outStream.flush();
            }
            this.outStream.writeZeroCopyIOHeader((boolean)flushBuffer, (int)lengthInDD, (boolean)isLastDD);
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void writeZeroCopyIOData(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void offset;
            void userBuffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$28, this, byArray, n2, n3);
            }
            this.outStream.writeZeroCopyIOData((byte[])userBuffer, (int)offset, (int)length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void clearWriteBuffer() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$29, this, new Object[0]);
            }
            ((T4CSocketOutputStreamWrapper)this.outStream).bIndex = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void prepareForUnmarshalAsync(Consumer<Throwable> consumer) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void completionHandler;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$30, this, consumer);
            }
            completionHandler.accept(new UnsupportedOperationException("Asynchronous IO is not supported when oracle.jdbc.javaNetNio=false"));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CMAREngineStream.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$31 = T4CMAREngineStream.class.getDeclaredConstructor(Communication.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CMAREngineStream.class.getDeclaredMethod("prepareForUnmarshalAsync", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CMAREngineStream.class.getDeclaredMethod("clearWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CMAREngineStream.class.getDeclaredMethod("writeZeroCopyIOData", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CMAREngineStream.class.getDeclaredMethod("writeZeroCopyIOHeader", Boolean.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CMAREngineStream.class.getDeclaredMethod("writeZeroCopyIO", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CMAREngineStream.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CMAREngineStream.class.getDeclaredMethod("setByteOrder", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CMAREngineStream.class.getDeclaredMethod("buffer2Value", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalTEXT", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CMAREngineStream.class.getDeclaredMethod("getNBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CMAREngineStream.class.getDeclaredMethod("getNBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalNBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalNBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalUB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalSB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalUB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalSB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalUB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalSB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CMAREngineStream.class.getDeclaredMethod("marshalB1Array", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CMAREngineStream.class.getDeclaredMethod("marshalB1Array", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CMAREngineStream.class.getDeclaredMethod("marshalSB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CMAREngineStream.class.getDeclaredMethod("marshalUB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CMAREngineStream.class.getDeclaredMethod("marshalUB4", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CMAREngineStream.class.getDeclaredMethod("marshalSB4", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CMAREngineStream.class.getDeclaredMethod("marshalUB2", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CMAREngineStream.class.getDeclaredMethod("marshalNativeUB2", Short.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CMAREngineStream.class.getDeclaredMethod("marshalSB2", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CMAREngineStream.class.getDeclaredMethod("marshalUB1", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CMAREngineStream.class.getDeclaredMethod("marshalSB1", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CMAREngineStream.class.getDeclaredMethod("initBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

