/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanToPropertyValueTransformer
implements Transformer {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String propertyName;
    private final boolean ignoreNull;

    public BeanToPropertyValueTransformer(String propertyName) {
        this(propertyName, false);
    }

    public BeanToPropertyValueTransformer(String propertyName, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.ignoreNull = ignoreNull;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public Object transform(Object object) {
        Object propertyValue = null;
        try {
            propertyValue = PropertyUtils.getProperty(object, this.propertyName);
        }
        catch (IllegalArgumentException e) {
            String errorMsg = "Problem during transformation. Null value encountered in property path...";
            if (!this.ignoreNull) {
                throw new IllegalArgumentException("Problem during transformation. Null value encountered in property path...", e);
            }
            this.log.warn((Object)("WARNING: Problem during transformation. Null value encountered in property path..." + e));
        }
        catch (IllegalAccessException e) {
            String errorMsg = "Unable to access the property provided.";
            throw new IllegalArgumentException("Unable to access the property provided.", e);
        }
        catch (InvocationTargetException e) {
            String errorMsg = "Exception occurred in property's getter";
            throw new IllegalArgumentException("Exception occurred in property's getter", e);
        }
        catch (NoSuchMethodException e) {
            String errorMsg = "No property found for name [" + this.propertyName + "]";
            throw new IllegalArgumentException(errorMsg, e);
        }
        return propertyValue;
    }
}

