/**
 * This file is part of the CernVM File System.
 *
 * It provide a series of several tar files useful for test purposes.
 */

#ifndef TEST_UNITTESTS_AUX_TAR_FILES_H_
#define TEST_UNITTESTS_AUX_TAR_FILES_H_

#include <string>

/*
 * To construct these strings is sufficient to create the normale .tar archive,
 * then from any unix shell is enough to use the utility base64, as an example.
 *
 * $ base64 tar_file.tar
 *
 */

/* 4_empty_files
 * ├── [   0]  bar
 * ├── [   0]  baz
 * ├── [   0]  foo
 * └── [   0]  fuz
 */

static const char *four_empty_files = "YmFyAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAADAwMDY2NCAAMDAxNzUw"
                                      "IAAwMDE3NTAgADAwMDAwMDAwMDAwIDEzMjQxNTIw"
                                      "NTIxIDAxMTUxMAAgMAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB1"
                                      "c3RhcgAwMHNpbW8AAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAc2ltbwAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAwMDAwMDAgADAwMDAw"
                                      "MCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABm"
                                      "b28AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAMDAwNjY0IAAwMDE3NTAg"
                                      "ADAwMTc1MCAAMDAwMDAwMDAwMDAgMTMyNDE1MjA1"
                                      "MTYgMDExNTMzACAwAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHVz"
                                      "dGFyADAwc2ltbwAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAABzaW1vAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAADAwMDAwMCAAMDAwMDAw"
                                      "IAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGZ1"
                                      "egAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAwMDA2NjQgADAwMTc1MCAA"
                                      "MDAxNzUwIAAwMDAwMDAwMDAwMCAxMzI0MTUyMDUz"
                                      "MyAwMTE1NTMAIDAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAdXN0"
                                      "YXIAMDBzaW1vAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAHNpbW8AAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAMDAwMDAwIAAwMDAwMDAg"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAYmF6"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAADAwMDY2NCAAMDAxNzUwIAAw"
                                      "MDE3NTAgADAwMDAwMDAwMDAwIDEzMjQxNTIwNTI0"
                                      "IDAxMTUyMwAgMAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB1c3Rh"
                                      "cgAwMHNpbW8AAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAc2ltbwAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAwMDAwMDAgADAwMDAwMCAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                      "AAAAAAAAAAAAAAAAAAAAAAAAAAAA";

/*
 * tar
 * ├── [4.0K]  aaa
 * │   └── [   7]  joker
 * └── [   7]  hero
 *
 */

static const char *simple_tar = "dGFyL2FhYS8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAADAwMDc3NSAAMDAxNzUw"
                                "IAAwMDE3NTAgADAwMDAwMDAwMDAwIDEzMjM2NjExNDczID"
                                "AxMjM1NgAgNQAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB1c3Rhcg"
                                "AwMHNpbW8AAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAc2ltbwAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAwMDAwMDAgADAwMDAw"
                                "MCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAB0"
                                "YXIvYWFhL2pva2VyAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAMDAwNjY0IAAwMDE3NTAg"
                                "ADAwMTc1MCAAMDAwMDAwMDAwMDcgMTMyMzY2MTE1MTAgMD"
                                "EzNDAwACAwAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHVzdGFyAD"
                                "Awc2ltbwAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAABzaW1vAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAADAwMDAwMCAAMDAwMDAw"
                                "IAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAGJh"
                                "dG1hbgoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAdGFy"
                                "LwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAADAwMDc3NSAAMDAxNzUwIAAw"
                                "MDE3NTAgADAwMDAwMDAwMDAwIDEzMjM2NjExNDYyIDAxMT"
                                "YzMgAgNQAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB1c3RhcgAwMH"
                                "NpbW8AAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAc2ltbwAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAwMDAwMDAgADAwMDAwMCAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAB0YXIv"
                                "aGVybwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAMDAwNjY0IAAwMDE3NTAgADAw"
                                "MTc1MCAAMDAwMDAwMDAwMDcgMTMyMzY2MTE0MTUgMDEyNT"
                                "A1ACAwAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHVzdGFyADAwc2"
                                "ltbwAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAABzaW1vAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAADAwMDAwMCAAMDAwMDAwIAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAGZvb2Jh"
                                "cgoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                "AAAAAAAAAAAAAAAAAAAA==";

/*
 *
 * $ tree -sh
 * .
 * ├── [   0]  bar
 * ├── [4.0K]  dir
 * │   └── [4.0K]  inside_dir
 * │       └── [   0]  foo
 * ├── [   4]  foo
 * └── [  18]  foo_link -> ./foo
 *
 * 2 directories, 4 files
 * $ cat foo_link
 * baz
 * $ cat ./foo
 * baz
 *
 */

static const char *complex_tar = "YmFyAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAADAwMDY2NCAAMDAxNzUw"
                                 "IAAwMDE3NTAgADAwMDAwMDAwMDAwIDEzMjQxNTU2MDAxI"
                                 "DAxMTUxMgAgMAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB1c3Rhc"
                                 "gAwMHNpbW8AAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAc2ltbwAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAwMDAwMDAgADAwMDAw"
                                 "MCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAABk"
                                 "aXIvAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAMDAwNzc1IAAwMDE3NTAg"
                                 "ADAwMTc1MCAAMDAwMDAwMDAwMDAgMTMyNDE1NTU3NTcgM"
                                 "DExNjM0ACA1AAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHVzdGFyA"
                                 "DAwc2ltbwAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAABzaW1vAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAADAwMDAwMCAAMDAwMDAw"
                                 "IAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAGZv"
                                 "b19saW5rAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAwMDA3NzcgADAwMTc1MCAA"
                                 "MDAxNzUwIAAwMDAwMDAwMDAwMCAxMzI0MTU1NjAxMCAwM"
                                 "TYxMzYAIDIvdG1wL3dvcmtzcGFjZS9m"
                                 "b28AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAdXN0YXIAM"
                                 "DBzaW1vAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAHNpbW8AAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAMDAwMDAwIAAwMDAwMDAg"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAZGly"
                                 "L2luc2lkZV9kaXIvZm9vAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAADAwMDY2NCAAMDAxNzUwIAAw"
                                 "MDE3NTAgADAwMDAwMDAwMDAwIDEzMjQxNTU1Nzc0IDAxN"
                                 "DQ0MAAgMAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB1c3RhcgAwM"
                                 "HNpbW8AAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAc2ltbwAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAwMDAwMDAgADAwMDAwMCAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAABkaXIv"
                                 "aW5zaWRlX2Rpci8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAMDAwNzc1IAAwMDE3NTAgADAw"
                                 "MTc1MCAAMDAwMDAwMDAwMDAgMTMyNDE1NTU3NzQgMDEzN"
                                 "zQ0ACA1AAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHVzdGFyADAwc"
                                 "2ltbwAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAABzaW1vAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAADAwMDAwMCAAMDAwMDAwIAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAGZvbwAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAwMDA2NjQgADAwMTc1MCAAMDAx"
                                 "NzUwIAAwMDAwMDAwMDAwNCAxMzI0MTU1NjE0MCAwMTE1N"
                                 "DEAIDAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAdXN0YXIAMDBza"
                                 "W1vAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAHNpbW8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAMDAwMDAwIAAwMDAwMDAgAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAYmF6CgAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                                 "AAAAAAAAAAAAAAAAAAA";


#endif  //  TEST_UNITTESTS_AUX_TAR_FILES_H_
