---
title: pixi config set
---
<!--- This file is autogenerated. Do not edit manually! -->
# [pixi](../../pixi.md) [config](../config.md) set

Set a configuration value

--8<-- "docs/reference/cli/pixi/config/set_extender:description"

## Usage
```
pixi config set [OPTIONS] <KEY> [VALUE]
```

## Arguments
- <a id="arg-<KEY>" href="#arg-<KEY>">`<KEY>`</a>
:  Configuration key to set
<br>**required**: `true`
- <a id="arg-<VALUE>" href="#arg-<VALUE>">`<VALUE>`</a>
:  Configuration value to set (key will be unset if value not provided)

## Config Options
- <a id="arg---local" href="#arg---local">`--local (-l)`</a>
:  Operation on project-local configuration
- <a id="arg---global" href="#arg---global">`--global (-g)`</a>
:  Operation on global configuration
- <a id="arg---system" href="#arg---system">`--system (-s)`</a>
:  Operation on system configuration

## Global Options
- <a id="arg---manifest-path" href="#arg---manifest-path">`--manifest-path (-m) <MANIFEST_PATH>`</a>
:  The path to `pixi.toml`, `pyproject.toml`, or the workspace directory

## Description
Set a configuration value

Example: `pixi config set default-channels '["conda-forge", "bioconda"]'`


--8<-- "docs/reference/cli/pixi/config/set_extender:example"
