/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;

public class ChoiceFormat
extends NumberFormat {
    private static final long serialVersionUID = 1795184449645032964L;
    private double[] choiceLimits;
    private String[] choiceFormats;
    static final long SIGN = Long.MIN_VALUE;
    static final long EXPONENT = 0x7FF0000000000000L;
    static final long POSITIVEINFINITY = 0x7FF0000000000000L;

    public void applyPattern(String string) {
        StringBuffer[] stringBufferArray = new StringBuffer[2];
        for (int i = 0; i < stringBufferArray.length; ++i) {
            stringBufferArray[i] = new StringBuffer();
        }
        double[] dArray = new double[30];
        String[] stringArray = new String[30];
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = Double.NaN;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                if (i + 1 < string.length() && string.charAt(i + 1) == c) {
                    stringBufferArray[n2].append(c);
                    ++i;
                    continue;
                }
                bl = !bl;
                continue;
            }
            if (bl) {
                stringBufferArray[n2].append(c);
                continue;
            }
            if (c == '<' || c == '#' || c == '\u2264') {
                if (stringBufferArray[0].length() == 0) {
                    throw new IllegalArgumentException();
                }
                try {
                    String string2 = stringBufferArray[0].toString();
                    d = string2.equals("\u221e") ? Double.POSITIVE_INFINITY : (string2.equals("-\u221e") ? Double.NEGATIVE_INFINITY : Double.valueOf(stringBufferArray[0].toString()));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException();
                }
                if (c == '<' && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                    d = ChoiceFormat.nextDouble(d);
                }
                if (d <= d2) {
                    throw new IllegalArgumentException();
                }
                stringBufferArray[0].setLength(0);
                n2 = 1;
                continue;
            }
            if (c == '|') {
                if (n == dArray.length) {
                    dArray = ChoiceFormat.doubleArraySize(dArray);
                    stringArray = this.doubleArraySize(stringArray);
                }
                dArray[n] = d;
                stringArray[n] = stringBufferArray[1].toString();
                ++n;
                d2 = d;
                stringBufferArray[1].setLength(0);
                n2 = 0;
                continue;
            }
            stringBufferArray[n2].append(c);
        }
        if (n2 == 1) {
            if (n == dArray.length) {
                dArray = ChoiceFormat.doubleArraySize(dArray);
                stringArray = this.doubleArraySize(stringArray);
            }
            dArray[n] = d;
            stringArray[n] = stringBufferArray[1].toString();
            ++n;
        }
        this.choiceLimits = new double[n];
        System.arraycopy(dArray, 0, this.choiceLimits, 0, n);
        this.choiceFormats = new String[n];
        System.arraycopy(stringArray, 0, this.choiceFormats, 0, n);
    }

    public String toPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            boolean bl;
            double d;
            if (i != 0) {
                stringBuffer.append('|');
            }
            double d2 = ChoiceFormat.previousDouble(this.choiceLimits[i]);
            double d3 = Math.abs(Math.IEEEremainder(this.choiceLimits[i], 1.0));
            if (d3 < (d = Math.abs(Math.IEEEremainder(d2, 1.0)))) {
                stringBuffer.append("" + this.choiceLimits[i]);
                stringBuffer.append('#');
            } else {
                if (this.choiceLimits[i] == Double.POSITIVE_INFINITY) {
                    stringBuffer.append("\u221e");
                } else if (this.choiceLimits[i] == Double.NEGATIVE_INFINITY) {
                    stringBuffer.append("-\u221e");
                } else {
                    stringBuffer.append("" + d2);
                }
                stringBuffer.append('<');
            }
            String string = this.choiceFormats[i];
            boolean bl2 = bl = string.indexOf(60) >= 0 || string.indexOf(35) >= 0 || string.indexOf(8804) >= 0 || string.indexOf(124) >= 0;
            if (bl) {
                stringBuffer.append('\'');
            }
            if (string.indexOf(39) < 0) {
                stringBuffer.append(string);
            } else {
                for (int j = 0; j < string.length(); ++j) {
                    char c = string.charAt(j);
                    stringBuffer.append(c);
                    if (c != '\'') continue;
                    stringBuffer.append(c);
                }
            }
            if (!bl) continue;
            stringBuffer.append('\'');
        }
        return stringBuffer.toString();
    }

    public ChoiceFormat(String string) {
        this.applyPattern(string);
    }

    public ChoiceFormat(double[] dArray, String[] stringArray) {
        this.setChoices(dArray, stringArray);
    }

    public void setChoices(double[] dArray, String[] stringArray) {
        if (dArray.length != stringArray.length) {
            throw new IllegalArgumentException("Array and limit arrays must be of the same length.");
        }
        this.choiceLimits = Arrays.copyOf(dArray, dArray.length);
        this.choiceFormats = Arrays.copyOf(stringArray, stringArray.length);
    }

    public double[] getLimits() {
        double[] dArray = Arrays.copyOf(this.choiceLimits, this.choiceLimits.length);
        return dArray;
    }

    public Object[] getFormats() {
        Object[] objectArray = Arrays.copyOf(this.choiceFormats, this.choiceFormats.length);
        return objectArray;
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        for (n = 0; n < this.choiceLimits.length && d >= this.choiceLimits[n]; ++n) {
        }
        if (--n < 0) {
            n = 0;
        }
        return stringBuffer.append(this.choiceFormats[n]);
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        int n;
        int n2 = n = parsePosition.index;
        double d = Double.NaN;
        double d2 = 0.0;
        for (int i = 0; i < this.choiceFormats.length; ++i) {
            String string2 = this.choiceFormats[i];
            if (!string.regionMatches(n, string2, 0, string2.length())) continue;
            parsePosition.index = n + string2.length();
            d2 = this.choiceLimits[i];
            if (parsePosition.index <= n2) continue;
            n2 = parsePosition.index;
            d = d2;
            if (n2 == string.length()) break;
        }
        parsePosition.index = n2;
        if (parsePosition.index == n) {
            parsePosition.errorIndex = n2;
        }
        return new Double(d);
    }

    public static final double nextDouble(double d) {
        return ChoiceFormat.nextDouble(d, true);
    }

    public static final double previousDouble(double d) {
        return ChoiceFormat.nextDouble(d, false);
    }

    @Override
    public Object clone() {
        ChoiceFormat choiceFormat = (ChoiceFormat)super.clone();
        choiceFormat.choiceLimits = (double[])this.choiceLimits.clone();
        choiceFormat.choiceFormats = (String[])this.choiceFormats.clone();
        return choiceFormat;
    }

    @Override
    public int hashCode() {
        int n = this.choiceLimits.length;
        if (this.choiceFormats.length > 0) {
            n ^= this.choiceFormats[this.choiceFormats.length - 1].hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChoiceFormat choiceFormat = (ChoiceFormat)object;
        return Arrays.equals(this.choiceLimits, choiceFormat.choiceLimits) && Arrays.equals(this.choiceFormats, choiceFormat.choiceFormats);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.choiceLimits.length != this.choiceFormats.length) {
            throw new InvalidObjectException("limits and format arrays of different length.");
        }
    }

    public static double nextDouble(double d, boolean bl) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (d == 0.0) {
            double d2 = Double.longBitsToDouble(1L);
            if (bl) {
                return d2;
            }
            return -d2;
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l & Long.MAX_VALUE;
        if (l > 0L == bl) {
            if (l2 != 0x7FF0000000000000L) {
                ++l2;
            }
        } else {
            --l2;
        }
        long l3 = l & Long.MIN_VALUE;
        return Double.longBitsToDouble(l2 | l3);
    }

    private static double[] doubleArraySize(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n * 2];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    private String[] doubleArraySize(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n * 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }
}

